/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineServiceStatusJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineServiceStatusJob.class);
    private static final String COUNTER_NAME = "pipelineServiceClientStatus.counter";
    private static final String CLUSTER_TAG_NAME = "clusterName";
    private static final String UNHEALTHY_TAG_NAME = "unhealthy";

    public void execute(JobExecutionContext jobExecutionContext) {
        PipelineServiceClientInterface pipelineServiceClient = (PipelineServiceClientInterface)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"pipelineServiceClient");
        PrometheusMeterRegistry meterRegistry = (PrometheusMeterRegistry)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"meterRegistry");
        String clusterName = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)CLUSTER_TAG_NAME);
        try {
            this.registerStatusMetric(pipelineServiceClient, meterRegistry, clusterName);
        }
        catch (Exception e) {
            LOG.error("[Pipeline Service Status Job] Failed in sending metric due to", (Throwable)e);
            this.publishUnhealthyCounter(meterRegistry, clusterName);
        }
    }

    private void registerStatusMetric(PipelineServiceClientInterface pipelineServiceClient, PrometheusMeterRegistry meterRegistry, String clusterName) {
        String status = pipelineServiceClient.getServiceStatusBackoff();
        if (!"healthy".equals(status)) {
            this.publishUnhealthyCounter(meterRegistry, clusterName);
        }
    }

    private void publishUnhealthyCounter(PrometheusMeterRegistry meterRegistry, String clusterName) {
        Counter.builder((String)COUNTER_NAME).tags(new String[]{"status", UNHEALTHY_TAG_NAME, CLUSTER_TAG_NAME, clusterName}).register((MeterRegistry)meterRegistry).increment();
    }
}

