/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled.template;

import java.util.Map;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;

public class DataInsightTotalAssetTemplate {
    private String totalDataAssets;
    private String percentChangeTotalAssets;
    private String percentChangeMessage;
    private String completeMessage;
    private int numberOfDaysChange;
    private Map<String, Integer> dateMap;

    public DataInsightTotalAssetTemplate(String totalDataAssets, Double percentChangeTotalAssets, int numberOfDaysChange, Map<String, Integer> dateMap) {
        this.totalDataAssets = totalDataAssets;
        this.percentChangeTotalAssets = String.format("%.2f", percentChangeTotalAssets);
        this.percentChangeMessage = DataInsightDescriptionAndOwnerTemplate.getFormattedPercentChangeMessage(percentChangeTotalAssets);
        this.numberOfDaysChange = numberOfDaysChange;
        this.dateMap = dateMap;
        String color = "#BF0000";
        if (percentChangeTotalAssets > 0.0) {
            color = "#008510";
        }
        this.completeMessage = String.format("In the past week, the Total Data Assets changed by <span style=\"color: %s; font-weight: bold;\">%s%%</span>.", color, this.percentChangeTotalAssets);
    }

    public void setTotalDataAssets(Double totalDataAssets) {
        this.totalDataAssets = String.format("%.2f", totalDataAssets);
    }

    public void setPercentChangeTotalAssets(Double percentChangeTotalAssets) {
        this.percentChangeTotalAssets = String.format("%.2f", percentChangeTotalAssets);
    }

    public String getTotalDataAssets() {
        return this.totalDataAssets;
    }

    public String getPercentChangeTotalAssets() {
        return this.percentChangeTotalAssets;
    }

    public String getPercentChangeMessage() {
        return this.percentChangeMessage;
    }

    public String getCompleteMessage() {
        return this.completeMessage;
    }

    public int getNumberOfDaysChange() {
        return this.numberOfDaysChange;
    }

    public Map<String, Integer> getDateMap() {
        return this.dateMap;
    }

    public void setPercentChangeMessage(String percentChangeMessage) {
        this.percentChangeMessage = percentChangeMessage;
    }

    public void setCompleteMessage(String completeMessage) {
        this.completeMessage = completeMessage;
    }

    public void setNumberOfDaysChange(int numberOfDaysChange) {
        this.numberOfDaysChange = numberOfDaysChange;
    }

    public void setDateMap(Map<String, Integer> dateMap) {
        this.dateMap = dateMap;
    }
}

