/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class EmailMessageDecorator
implements MessageDecorator<EmailMessage> {
    @Override
    public String getBold() {
        return "<b>%s</b>";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "<b>";
    }

    @Override
    public String getAddMarkerClose() {
        return "</b>";
    }

    @Override
    public String getRemoveMarker() {
        return "<s>";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "</s>";
    }

    @Override
    public String getEntityUrl(String prefix, String fqn, String additionalParams) {
        return String.format("<a href = '%s/%s/%s%s'>%s</a>", EmailUtil.getSmtpSettings().getOpenMetadataUrl(), prefix, fqn.trim(), CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams), fqn.trim());
    }

    @Override
    public EmailMessage buildEntityMessage(String publisherName, ChangeEvent event) {
        return this.getEmailMessage(this.createEntityMessage(publisherName, event));
    }

    @Override
    public EmailMessage buildTestMessage(String publisherName) {
        return this.getEmailTestMessage(publisherName);
    }

    @Override
    public EmailMessage buildThreadMessage(String publisherName, ChangeEvent event) {
        return this.getEmailMessage(this.createThreadMessage(publisherName, event));
    }

    public EmailMessage getEmailMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setUserName(outgoingMessage.getUserName());
            emailMessage.setEntityUrl(outgoingMessage.getEntityUrl());
            emailMessage.setUpdatedBy(outgoingMessage.getUserName());
            emailMessage.setChangeMessage(new ArrayList<String>(outgoingMessage.getMessages()));
            return emailMessage;
        }
        throw new UnhandledServerException("No messages found for the event");
    }

    public EmailMessage getEmailTestMessage(String publisherName) {
        if (!publisherName.isEmpty()) {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setUserName("test_user");
            emailMessage.setUpdatedBy("system");
            emailMessage.setChangeMessage(new ArrayList<CallSite>(Collections.singleton("This is a test alert to verify the destination configuration for alerts. Publisher: " + publisherName + ". If you received this message, your alert configuration is correct.")));
            return emailMessage;
        }
        throw new UnhandledServerException("Publisher name not found.");
    }
}

