/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.TeamsMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class MSTeamsMessageDecorator
implements MessageDecorator<TeamsMessage> {
    @Override
    public String getBold() {
        return "**%s**";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "**";
    }

    @Override
    public String getAddMarkerClose() {
        return "** ";
    }

    @Override
    public String getRemoveMarker() {
        return "~~";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "~~ ";
    }

    @Override
    public String getEntityUrl(String prefix, String fqn, String additionalParams) {
        return String.format("[%s](/%s/%s%s)", fqn.trim(), EmailUtil.getSmtpSettings().getOpenMetadataUrl(), prefix, CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams));
    }

    @Override
    public TeamsMessage buildEntityMessage(String publisherName, ChangeEvent event) {
        return this.getTeamMessage(this.createEntityMessage(publisherName, event));
    }

    @Override
    public TeamsMessage buildTestMessage(String publisherName) {
        return this.getTeamTestMessage(publisherName);
    }

    @Override
    public TeamsMessage buildThreadMessage(String publisherName, ChangeEvent event) {
        return this.getTeamMessage(this.createThreadMessage(publisherName, event));
    }

    private TeamsMessage getTeamMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            TeamsMessage teamsMessage = new TeamsMessage();
            teamsMessage.setSummary("Change Event From OpenMetadata");
            TeamsMessage.Section teamsSections = new TeamsMessage.Section();
            teamsSections.setActivityTitle(outgoingMessage.getHeader());
            ArrayList<TeamsMessage.Section> attachmentList = new ArrayList<TeamsMessage.Section>();
            outgoingMessage.getMessages().forEach(m -> attachmentList.add(this.getTeamsSection(teamsSections.getActivityTitle(), (String)m)));
            teamsMessage.setSections(attachmentList);
            return teamsMessage;
        }
        throw new UnhandledServerException("No messages found for the event");
    }

    private TeamsMessage getTeamTestMessage(String publisherName) {
        if (!publisherName.isEmpty()) {
            TeamsMessage teamsMessage = new TeamsMessage();
            teamsMessage.setSummary("This is a test message from OpenMetadata to confirm your Microsoft Teams destination is configured correctly.");
            TeamsMessage.Section teamsSection = new TeamsMessage.Section();
            teamsSection.setActivityTitle("Alert: " + publisherName);
            ArrayList<TeamsMessage.Section> sectionList = new ArrayList<TeamsMessage.Section>();
            sectionList.add(teamsSection);
            teamsMessage.setSections(sectionList);
            return teamsMessage;
        }
        throw new UnhandledServerException("Publisher name not found.");
    }

    private TeamsMessage.Section getTeamsSection(String activityTitle, String message) {
        TeamsMessage.Section section = new TeamsMessage.Section();
        section.setActivityTitle(activityTitle);
        section.setActivityText(message);
        return section;
    }
}

