/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.util.JsonUtils;

public class IngestionPipelineFormatter
implements EntityFormatter {
    private static final String PIPELINE_STATUS_FIELD = "pipelineStatus";

    @Override
    public String format(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange, FormatterUtil.CHANGE_TYPE changeType) {
        if (PIPELINE_STATUS_FIELD.equals(fieldChange.getName())) {
            return this.transformIngestionPipelineStatus(messageFormatter, thread, fieldChange);
        }
        return FormatterUtil.transformMessage(messageFormatter, thread, fieldChange, changeType);
    }

    private String transformIngestionPipelineStatus(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange) {
        EntityInterface entity = (EntityInterface)Entity.getEntity(thread.getEntityRef().getType(), thread.getEntityRef().getId(), "id", Include.ALL);
        String ingestionPipelineName = entity.getName();
        PipelineStatus status = JsonUtils.readOrConvertValue(fieldChange.getNewValue(), PipelineStatus.class);
        if (status != null) {
            String date = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(status.getTimestamp()));
            String format = String.format("Ingestion Pipeline %s %s at %s", messageFormatter.getBold(), messageFormatter.getBold(), date);
            return String.format(format, ingestionPipelineName, status.getPipelineState());
        }
        String format = String.format("Ingestion Pipeline %s is updated", messageFormatter.getBold());
        return String.format(format, ingestionPipelineName);
    }

    public static String getIngestionPipelineUrl(MessageDecorator<?> formatter, String entityType, EntityInterface entityInterface) {
        if (entityType.equals("ingestionPipeline")) {
            IngestionPipeline ingestionPipeline = (IngestionPipeline)entityInterface;
            EntityReference serviceRef = ingestionPipeline.getService();
            if (CommonUtil.nullOrEmpty((Object)serviceRef)) {
                serviceRef = ((IngestionPipeline)Entity.getEntity(ingestionPipeline.getEntityReference(), "service", Include.ALL)).getService();
            }
            if (ingestionPipeline.getPipelineType().equals((Object)PipelineType.TEST_SUITE)) {
                String suffix = ".testSuite";
                return !CommonUtil.nullOrEmpty((Object)serviceRef) ? formatter.getEntityUrl("table", serviceRef.getFullyQualifiedName().substring(0, serviceRef.getFullyQualifiedName().length() - suffix.length()), "profiler?activeTab=Data%20Quality") : "";
            }
            if (ingestionPipeline.getPipelineType().equals((Object)PipelineType.APPLICATION)) {
                return !CommonUtil.nullOrEmpty((Object)serviceRef) ? formatter.getEntityUrl("automations", serviceRef.getFullyQualifiedName(), "automator-details") : "";
            }
            return !CommonUtil.nullOrEmpty((Object)serviceRef) ? formatter.getEntityUrl(String.format("service/%ss", serviceRef.getType()), serviceRef.getFullyQualifiedName(), "ingestions") : "";
        }
        return "";
    }
}

