/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.factory;

import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.DefaultEntityFormatter;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.entity.IngestionPipelineFormatter;
import org.openmetadata.service.formatter.entity.KpiFormatter;
import org.openmetadata.service.formatter.entity.PipelineFormatter;
import org.openmetadata.service.formatter.entity.QueryFormatter;
import org.openmetadata.service.formatter.field.AssetsFieldFormatter;
import org.openmetadata.service.formatter.field.CustomPropertiesFormatter;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.formatter.field.DescriptionFormatter;
import org.openmetadata.service.formatter.field.DomainFormatter;
import org.openmetadata.service.formatter.field.FollowersFormatter;
import org.openmetadata.service.formatter.field.OwnerFormatter;
import org.openmetadata.service.formatter.field.TagFormatter;
import org.openmetadata.service.formatter.field.TestCaseResultFormatter;

public final class ParserFactory {
    private ParserFactory() {
    }

    public static EntityFormatter getEntityParser(String entityType) {
        if (entityType.equals("THREAD")) {
            throw new IllegalArgumentException("Thread entity cannot be handled by Entity Parser.");
        }
        return switch (entityType) {
            case "query" -> new QueryFormatter();
            case "kpi" -> new KpiFormatter();
            case "ingestionPipeline" -> new IngestionPipelineFormatter();
            case "pipeline" -> new PipelineFormatter();
            default -> new DefaultEntityFormatter();
        };
    }

    public static DefaultFieldFormatter getFieldParserObject(MessageDecorator<?> decorator, Thread thread, FieldChange fieldChange, String fieldChangeName) {
        return switch (fieldChangeName) {
            case "tags" -> new TagFormatter(decorator, thread, fieldChange);
            case "followers" -> new FollowersFormatter(decorator, thread, fieldChange);
            case "owners" -> new OwnerFormatter(decorator, thread, fieldChange);
            case "description" -> new DescriptionFormatter(decorator, thread, fieldChange);
            case "domain" -> new DomainFormatter(decorator, thread, fieldChange);
            case "extension" -> new CustomPropertiesFormatter(decorator, thread, fieldChange);
            case "testCaseResult" -> new TestCaseResultFormatter(decorator, thread, fieldChange);
            case "assets" -> new AssetsFieldFormatter(decorator, thread, fieldChange);
            default -> new DefaultFieldFormatter(decorator, thread, fieldChange);
        };
    }
}

