/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import java.util.List;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.TagFeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.util.JsonUtils;

public class TagFormatter
extends DefaultFieldFormatter {
    private static final String HEADER_MESSAGE = "%s %s the tags for %s %s";

    public TagFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
    }

    @Override
    public String formatAddedField() {
        Object message = this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Added " + this.getMessageDecorator().getBold() + " to " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), message) : String.format("Added " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), message);
        String spanAdd = this.getMessageDecorator().getAddMarker();
        String spanAddClose = this.getMessageDecorator().getAddMarkerClose();
        if (message != null) {
            message = this.getMessageDecorator().replaceMarkers((String)message, this.getMessageDecorator().httpAddMarker(), spanAdd, spanAddClose);
        }
        this.populateTagFeedInfo(Thread.FieldOperation.ADDED, (String)message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        Object diff = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker() + " changed to " + this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        String spanAdd = this.getMessageDecorator().getAddMarker();
        String spanAddClose = this.getMessageDecorator().getAddMarkerClose();
        String spanRemove = this.getMessageDecorator().getRemoveMarker();
        String spanRemoveClose = this.getMessageDecorator().getRemoveMarkerClose();
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpAddMarker(), spanAdd, spanAddClose);
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpRemoveMarker(), spanRemove, spanRemoveClose);
        String message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Updated " + this.getMessageDecorator().getBold() + " of " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), diff) : String.format("Updated " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), diff);
        this.populateTagFeedInfo(Thread.FieldOperation.UPDATED, message);
        return String.format(message, this.getFieldChangeName());
    }

    @Override
    public String formatDeletedField() {
        Object message = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker();
        message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Deleted " + this.getMessageDecorator().getBold() + " from " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), message) : String.format("Deleted " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), message);
        String spanAdd = this.getMessageDecorator().getRemoveMarker();
        String spanAddClose = this.getMessageDecorator().getRemoveMarkerClose();
        if (message != null) {
            message = this.getMessageDecorator().replaceMarkers((String)message, this.getMessageDecorator().httpRemoveMarker(), spanAdd, spanAddClose);
        }
        this.populateTagFeedInfo(Thread.FieldOperation.DELETED, (String)message);
        return message;
    }

    private String getTransformedName(String fieldName) {
        if ("columns".equals(fieldName)) {
            return "column";
        }
        return fieldName;
    }

    private void populateTagFeedInfo(Thread.FieldOperation operation, String threadMessage) {
        List<TagLabel> oldTags = JsonUtils.readOrConvertValues(this.fieldChange.getOldValue(), TagLabel.class);
        List<TagLabel> newTags = JsonUtils.readOrConvertValues(this.fieldChange.getNewValue(), TagLabel.class);
        TagFeedInfo tagFeedInfo = new TagFeedInfo().withPreviousTags(oldTags).withUpdatedTags(newTags);
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForTagsUpdate(operation.value())).withFieldName("tags").withEntitySpecificInfo((Object)tagFeedInfo);
        TagFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.TAGS, operation, feedInfo);
    }

    private String getHeaderForTagsUpdate(String eventTypeMessage) {
        return String.format(HEADER_MESSAGE, this.thread.getUpdatedBy(), eventTypeMessage, this.thread.getEntityRef().getType(), this.thread.getEntityUrlLink());
    }
}

