/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.TestCaseResultFeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.formatter.decorators.FeedMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public class TestCaseResultFormatter
extends DefaultFieldFormatter {
    public static final String TEST_RESULT_FIELD = "testCaseResult";
    private static final String HEADER_MESSAGE = "%s added results to test Case %s";

    public TestCaseResultFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
    }

    @Override
    public String formatAddedField() {
        String message = this.fieldChangeName.equals(TEST_RESULT_FIELD) ? this.transformTestCaseResult(this.messageDecorator, this.thread, this.fieldChange) : super.formatAddedField();
        this.populateTestResultFeedInfo(Thread.FieldOperation.UPDATED, message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = this.fieldChangeName.equals(TEST_RESULT_FIELD) ? this.transformTestCaseResult(this.messageDecorator, this.thread, this.fieldChange) : super.formatUpdatedField();
        this.populateTestResultFeedInfo(Thread.FieldOperation.UPDATED, message);
        return message;
    }

    private void populateTestResultFeedInfo(Thread.FieldOperation operation, String threadMessage) {
        long currentTime = System.currentTimeMillis();
        long lastWeekTime = currentTime - 604800000L;
        TestCaseRepository testCaseRepository = (TestCaseRepository)Entity.getEntityRepository("testCase");
        TestCase testCaseEntity = (TestCase)Entity.getEntity(this.thread.getEntityRef().getType(), this.thread.getEntityRef().getId(), "id,testSuite", Include.ALL);
        TestSuite testSuiteEntity = (TestSuite)Entity.getEntity(testCaseEntity.getTestSuite(), "id", Include.ALL);
        ResultList<TestCaseResult> testCaseResultResultList = testCaseRepository.getTestCaseResults(testCaseEntity.getFullyQualifiedName(), lastWeekTime, currentTime);
        TestCaseResultFeedInfo testCaseResultFeedInfo = new TestCaseResultFeedInfo().withTestCaseResult(testCaseResultResultList.getData()).withEntityTestResultSummary(testSuiteEntity.getTestCaseResultSummary()).withParameterValues(testCaseEntity.getParameterValues());
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForTestResultUpdate()).withFieldName(TEST_RESULT_FIELD).withEntitySpecificInfo((Object)testCaseResultFeedInfo);
        TestCaseResultFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.TEST_CASE_RESULT, operation, feedInfo);
    }

    private String getHeaderForTestResultUpdate() {
        return String.format(HEADER_MESSAGE, this.thread.getUpdatedBy(), this.thread.getEntityUrlLink());
    }

    private String transformTestCaseResult(MessageDecorator<?> messageFormatter, Thread thread, FieldChange fieldChange) {
        TestCase testCaseEntity = (TestCase)Entity.getEntity(thread.getEntityRef().getType(), thread.getEntityRef().getId(), "id", Include.ALL);
        String testCaseName = testCaseEntity.getName();
        TestCaseResult result = JsonUtils.convertValue(fieldChange.getNewValue(), TestCaseResult.class);
        if (result != null) {
            String format = String.format("Test Case %s is %s in %s", messageFormatter.getBold(), messageFormatter.getBold(), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN());
            return String.format(format, testCaseName, this.getStatusMessage(messageFormatter, result.getTestCaseStatus()));
        }
        String format = String.format("Test Case %s is updated in %s", messageFormatter.getBold(), messageFormatter.getBold());
        return String.format(format, testCaseName, MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN());
    }

    private String getStatusMessage(MessageDecorator<?> messageDecorator, TestCaseStatus status) {
        if (messageDecorator instanceof FeedMessageDecorator) {
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case TestCaseStatus.Success -> "<span style=\"color:#48CA9E\">Passed</span>";
                case TestCaseStatus.Failed -> "<span style=\"color:#F24822\">Failed</span>";
                case TestCaseStatus.Aborted -> "<span style=\"color:#FFBE0E\">Aborted</span>";
                case TestCaseStatus.Queued -> "<span style=\"color:#959595\">Queued</span>";
            };
        }
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case TestCaseStatus.Success -> "Passed";
            case TestCaseStatus.Failed -> "Failed";
            case TestCaseStatus.Aborted -> "Aborted";
            case TestCaseStatus.Queued -> "Queued";
        };
    }
}

