/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.APICollection;
import org.openmetadata.schema.entity.services.APIService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APICollectionRepository
extends EntityRepository<APICollection> {
    private static final Logger LOG = LoggerFactory.getLogger(APICollectionRepository.class);

    public APICollectionRepository() {
        super("v1/databases/", "apiCollection", APICollection.class, Entity.getCollectionDAO().apiCollectionDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(APICollection apiCollection) {
        apiCollection.setFullyQualifiedName(FullyQualifiedName.build(apiCollection.getService().getName(), apiCollection.getName()));
    }

    @Override
    public void prepare(APICollection apiCollection, boolean update) {
        this.populateService(apiCollection);
    }

    @Override
    public void storeEntity(APICollection apiCollection, boolean update) {
        EntityReference service = apiCollection.getService();
        apiCollection.withService(null);
        this.store(apiCollection, update);
        apiCollection.withService(service);
    }

    @Override
    public void storeRelationships(APICollection apiCollection) {
        this.addServiceRelationship(apiCollection, apiCollection.getService());
    }

    private List<EntityReference> getAPIEndpoints(APICollection apiCollection) {
        return apiCollection == null ? null : this.findTo(apiCollection.getId(), "apiCollection", Relationship.CONTAINS, "apiEndpoint");
    }

    @Override
    public EntityInterface getParentEntity(APICollection entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    @Override
    public void setFields(APICollection apiCollection, EntityUtil.Fields fields) {
        apiCollection.setService(this.getContainer(apiCollection.getId()));
        apiCollection.setApiEndpoints(fields.contains("apiEndpoints") ? this.getAPIEndpoints(apiCollection) : apiCollection.getApiEndpoints());
    }

    @Override
    public void clearFields(APICollection apiCollection, EntityUtil.Fields fields) {
        apiCollection.setApiEndpoints(fields.contains("apiEndpoints") ? apiCollection.getApiEndpoints() : null);
    }

    @Override
    public void restorePatchAttributes(APICollection original, APICollection updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(APICollection original, APICollection updated, EntityRepository.Operation operation) {
        return new APICollectionUpdater(original, updated, operation);
    }

    private void populateService(APICollection apiCollection) {
        APIService service = (APIService)Entity.getEntity(apiCollection.getService(), "", Include.NON_DELETED);
        apiCollection.setService(service.getEntityReference());
        apiCollection.setServiceType(service.getServiceType());
    }

    public class APICollectionUpdater
    extends EntityRepository.EntityUpdater {
        public APICollectionUpdater(APICollection original, APICollection updated, EntityRepository.Operation operation) {
            super((EntityRepository)APICollectionRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("sourceHash", ((APICollection)this.original).getSourceHash(), ((APICollection)this.updated).getSourceHash());
        }
    }
}

