/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.APICollection;
import org.openmetadata.schema.entity.data.APIEndpoint;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class APIEndpointRepository
extends EntityRepository<APIEndpoint> {
    public APIEndpointRepository() {
        super("v1/apiEndpoints/", "apiEndpoint", APIEndpoint.class, Entity.getCollectionDAO().apiEndpointDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(APIEndpoint apiEndpoint) {
        apiEndpoint.setFullyQualifiedName(FullyQualifiedName.add(apiEndpoint.getApiCollection().getFullyQualifiedName(), apiEndpoint.getName()));
        if (apiEndpoint.getRequestSchema() != null) {
            this.setFieldFQN(apiEndpoint.getFullyQualifiedName() + ".requestSchema", apiEndpoint.getRequestSchema().getSchemaFields());
        }
        if (apiEndpoint.getResponseSchema() != null) {
            this.setFieldFQN(apiEndpoint.getFullyQualifiedName() + ".responseSchema", apiEndpoint.getResponseSchema().getSchemaFields());
        }
    }

    @Override
    public void setInheritedFields(APIEndpoint endpoint, EntityUtil.Fields fields) {
        APICollection apiCollection = (APICollection)Entity.getEntity("apiCollection", endpoint.getApiCollection().getId(), "owners,domain", Include.ALL);
        this.inheritOwners(endpoint, fields, (EntityInterface)apiCollection);
        this.inheritDomain(endpoint, fields, (EntityInterface)apiCollection);
    }

    @Override
    public void prepare(APIEndpoint apiEndpoint, boolean update) {
        this.populateAPICollection(apiEndpoint);
    }

    @Override
    public void storeEntity(APIEndpoint apiEndpoint, boolean update) {
        EntityReference apiCollection = apiEndpoint.getApiCollection();
        apiEndpoint.withApiCollection(null);
        List requestFieldsWithTags = null;
        if (apiEndpoint.getRequestSchema() != null) {
            requestFieldsWithTags = apiEndpoint.getRequestSchema().getSchemaFields();
            apiEndpoint.getRequestSchema().setSchemaFields(this.cloneWithoutTags(requestFieldsWithTags));
            apiEndpoint.getRequestSchema().getSchemaFields().forEach(field -> field.setTags(null));
        }
        List responseFieldsWithTags = null;
        if (apiEndpoint.getResponseSchema() != null) {
            responseFieldsWithTags = apiEndpoint.getResponseSchema().getSchemaFields();
            apiEndpoint.getResponseSchema().setSchemaFields(this.cloneWithoutTags(responseFieldsWithTags));
            apiEndpoint.getResponseSchema().getSchemaFields().forEach(field -> field.setTags(null));
        }
        this.store(apiEndpoint, update);
        if (requestFieldsWithTags != null) {
            apiEndpoint.getRequestSchema().withSchemaFields(requestFieldsWithTags);
        }
        if (responseFieldsWithTags != null) {
            apiEndpoint.getResponseSchema().withSchemaFields(responseFieldsWithTags);
        }
        apiEndpoint.withApiCollection(apiCollection);
    }

    @Override
    public void storeRelationships(APIEndpoint apiEndpoint) {
        EntityReference apiCollection = apiEndpoint.getApiCollection();
        this.addRelationship(apiCollection.getId(), apiEndpoint.getId(), apiCollection.getType(), "apiEndpoint", Relationship.CONTAINS);
    }

    @Override
    public void setFields(APIEndpoint apiEndpoint, EntityUtil.Fields fields) {
        this.setDefaultFields(apiEndpoint);
        if (apiEndpoint.getRequestSchema() != null) {
            Entity.populateEntityFieldTags(this.entityType, apiEndpoint.getRequestSchema().getSchemaFields(), apiEndpoint.getFullyQualifiedName() + ".requestSchema", fields.contains("tags"));
        }
        if (apiEndpoint.getResponseSchema() != null) {
            Entity.populateEntityFieldTags(this.entityType, apiEndpoint.getResponseSchema().getSchemaFields(), apiEndpoint.getFullyQualifiedName() + ".responseSchema", fields.contains("tags"));
        }
    }

    @Override
    public void clearFields(APIEndpoint apiEndpoint, EntityUtil.Fields fields) {
    }

    public APIEndpointUpdater getUpdater(APIEndpoint original, APIEndpoint updated, EntityRepository.Operation operation) {
        return new APIEndpointUpdater(original, updated, operation);
    }

    private void setDefaultFields(APIEndpoint apiEndpoint) {
        EntityReference apiCollectionRef = this.getContainer(apiEndpoint.getId());
        APICollection apiCollection = (APICollection)Entity.getEntity(apiCollectionRef, "", Include.ALL);
        apiEndpoint.withApiCollection(apiCollectionRef).withService(apiCollection.getService());
    }

    private void populateAPICollection(APIEndpoint apiEndpoint) {
        APICollection apiCollection = (APICollection)Entity.getEntity(apiEndpoint.getApiCollection(), "", Include.ALL);
        apiEndpoint.setApiCollection(apiCollection.getEntityReference());
        apiEndpoint.setService(apiCollection.getService());
        apiEndpoint.setServiceType(apiCollection.getServiceType());
    }

    private void setFieldFQN(String parentFQN, List<Field> fields) {
        fields.forEach(c -> {
            String fieldFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(fieldFqn);
            if (c.getChildren() != null) {
                this.setFieldFQN(fieldFqn, c.getChildren());
            }
        });
    }

    List<Field> cloneWithoutTags(List<Field> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return fields;
        }
        ArrayList<Field> copy = new ArrayList<Field>();
        fields.forEach(f -> copy.add(this.cloneWithoutTags((Field)f)));
        return copy;
    }

    private Field cloneWithoutTags(Field field) {
        List<Field> children = this.cloneWithoutTags(field.getChildren());
        return new Field().withDescription(field.getDescription()).withName(field.getName()).withDisplayName(field.getDisplayName()).withFullyQualifiedName(field.getFullyQualifiedName()).withDataType(field.getDataType()).withDataTypeDisplay(field.getDataTypeDisplay()).withChildren(children);
    }

    private void validateSchemaFieldTags(List<Field> fields) {
        for (Field field : fields) {
            this.validateTags(field.getTags());
            field.setTags(TagLabelUtil.addDerivedTags(field.getTags()));
            TagLabelUtil.checkMutuallyExclusive(field.getTags());
            if (field.getChildren() == null) continue;
            this.validateSchemaFieldTags(field.getChildren());
        }
    }

    @Override
    private void applyTags(List<Field> fields) {
        for (Field field : fields) {
            this.applyTags(field.getTags(), field.getFullyQualifiedName());
            if (field.getChildren() == null) continue;
            this.applyTags(field.getChildren());
        }
    }

    @Override
    public void applyTags(APIEndpoint apiEndpoint) {
        super.applyTags(apiEndpoint);
        if (apiEndpoint.getRequestSchema() != null) {
            this.applyTags(apiEndpoint.getRequestSchema().getSchemaFields());
        }
        if (apiEndpoint.getResponseSchema() != null) {
            this.applyTags(apiEndpoint.getResponseSchema().getSchemaFields());
        }
    }

    @Override
    public EntityInterface getParentEntity(APIEndpoint entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getApiCollection(), fields, Include.ALL);
    }

    @Override
    public void validateTags(APIEndpoint entity) {
        super.validateTags(entity);
        if (entity.getRequestSchema() != null) {
            this.validateSchemaFieldTags(entity.getRequestSchema().getSchemaFields());
        }
        if (entity.getResponseSchema() != null) {
            this.validateSchemaFieldTags(entity.getResponseSchema().getSchemaFields());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        APIEndpoint apiEndpoint = (APIEndpoint)entity;
        EntityUtil.mergeTags(allTags, apiEndpoint.getTags());
        List requestSchemaFields = apiEndpoint.getRequestSchema() != null ? apiEndpoint.getRequestSchema().getSchemaFields() : null;
        List responseSchemaFields = apiEndpoint.getResponseSchema() != null ? apiEndpoint.getResponseSchema().getSchemaFields() : null;
        for (Field schemaField : CommonUtil.listOrEmpty((List)responseSchemaFields)) {
            EntityUtil.mergeTags(allTags, schemaField.getTags());
        }
        for (Field schemaField : CommonUtil.listOrEmpty((List)requestSchemaFields)) {
            EntityUtil.mergeTags(allTags, schemaField.getTags());
        }
        return allTags;
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("responseSchema")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new ResponseSchemaDescriptionWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new ResponseSchemaTagWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    private static Field getResponseSchemaField(APIEndpoint apiEndpoint, String schemaName) {
        String childrenSchemaName = "";
        if (schemaName.contains(".")) {
            String fieldNameWithoutQuotes = schemaName.substring(1, schemaName.length() - 1);
            schemaName = fieldNameWithoutQuotes.substring(0, fieldNameWithoutQuotes.indexOf("."));
            childrenSchemaName = fieldNameWithoutQuotes.substring(fieldNameWithoutQuotes.lastIndexOf(".") + 1);
        }
        Field schemaField = null;
        for (Field field : apiEndpoint.getResponseSchema().getSchemaFields()) {
            if (!field.getName().equals(schemaName)) continue;
            schemaField = field;
            break;
        }
        if (!"".equals(childrenSchemaName) && schemaField != null) {
            schemaField = APIEndpointRepository.getChildSchemaField(schemaField.getChildren(), childrenSchemaName);
        }
        if (schemaField == null) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("responseSchema", schemaName));
        }
        return schemaField;
    }

    private static Field getChildSchemaField(List<Field> fields, String childrenSchemaName) {
        Field childrenSchemaField;
        block2: {
            childrenSchemaField = null;
            for (Field field : fields) {
                if (!field.getName().equals(childrenSchemaName)) continue;
                childrenSchemaField = field;
                break;
            }
            if (childrenSchemaField != null) break block2;
            for (Field field : fields) {
                if (field.getChildren() != null && (childrenSchemaField = APIEndpointRepository.getChildSchemaField(field.getChildren(), childrenSchemaName)) != null) break;
            }
        }
        return childrenSchemaField;
    }

    public static Set<TagLabel> getAllFieldTags(Field field) {
        HashSet<TagLabel> tags = new HashSet<TagLabel>();
        if (!CommonUtil.listOrEmpty((List)field.getTags()).isEmpty()) {
            tags.addAll(field.getTags());
        }
        for (Field c : CommonUtil.listOrEmpty((List)field.getChildren())) {
            tags.addAll(APIEndpointRepository.getAllFieldTags(c));
        }
        return tags;
    }

    public class APIEndpointUpdater
    extends EntityRepository.EntityUpdater {
        public static final String FIELD_DATA_TYPE_DISPLAY = "dataTypeDisplay";

        public APIEndpointUpdater(APIEndpoint original, APIEndpoint updated, EntityRepository.Operation operation) {
            super((EntityRepository)APIEndpointRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("endpointURL", ((APIEndpoint)this.original).getEndpointURL(), ((APIEndpoint)this.updated).getEndpointURL());
            this.recordChange("requestMethod", ((APIEndpoint)this.original).getRequestMethod(), ((APIEndpoint)this.updated).getRequestMethod());
            if (((APIEndpoint)this.updated).getRequestSchema() != null && ((APIEndpoint)this.updated).getRequestSchema().getSchemaFields() != null) {
                this.updateSchemaFields("requestSchema.schemaFields", ((APIEndpoint)this.original).getResponseSchema() == null ? new ArrayList() : CommonUtil.listOrEmpty(((APIEndpoint)this.original).getRequestSchema() != null ? ((APIEndpoint)this.original).getRequestSchema().getSchemaFields() : null), CommonUtil.listOrEmpty((List)((APIEndpoint)this.updated).getRequestSchema().getSchemaFields()), EntityUtil.schemaFieldMatch);
            }
            if (((APIEndpoint)this.updated).getResponseSchema() != null && ((APIEndpoint)this.updated).getResponseSchema().getSchemaFields() != null) {
                this.updateSchemaFields("responseSchema.schemaFields", ((APIEndpoint)this.original).getResponseSchema() == null ? new ArrayList() : CommonUtil.listOrEmpty(((APIEndpoint)this.original).getResponseSchema().getSchemaFields() != null ? ((APIEndpoint)this.original).getResponseSchema().getSchemaFields() : null), CommonUtil.listOrEmpty((List)((APIEndpoint)this.updated).getResponseSchema().getSchemaFields()), EntityUtil.schemaFieldMatch);
            }
            this.recordChange("sourceHash", ((APIEndpoint)this.original).getSourceHash(), ((APIEndpoint)this.updated).getSourceHash());
        }

        private void updateSchemaFields(String fieldName, List<Field> origFields, List<Field> updatedFields, BiPredicate<Field, Field> fieldMatch) {
            ArrayList deletedFields = new ArrayList();
            ArrayList addedFields = new ArrayList();
            this.recordListChange(fieldName, origFields, updatedFields, addedFields, deletedFields, fieldMatch);
            Map addedFieldMap = addedFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            for (Field deleted2 : deletedFields) {
                if (!addedFieldMap.containsKey(deleted2.getName())) continue;
                Field addedField = (Field)addedFieldMap.get(deleted2.getName());
                if (CommonUtil.nullOrEmpty((String)addedField.getDescription()) && CommonUtil.nullOrEmpty((String)deleted2.getDescription())) {
                    addedField.setDescription(deleted2.getDescription());
                }
                if (!CommonUtil.nullOrEmpty((List)addedField.getTags()) || !CommonUtil.nullOrEmpty((List)deleted2.getTags())) continue;
                addedField.setTags(deleted2.getTags());
            }
            deletedFields.forEach(deleted -> APIEndpointRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(deleted.getFullyQualifiedName()));
            for (Field added : addedFields) {
                APIEndpointRepository.this.applyTags(added.getTags(), added.getFullyQualifiedName());
            }
            for (Field updated : updatedFields) {
                Field stored = origFields.stream().filter(c -> fieldMatch.test((Field)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateFieldDescription(stored, updated);
                this.updateFieldDataTypeDisplay(stored, updated);
                this.updateFieldDisplayName(stored, updated);
                this.updateTags(stored.getFullyQualifiedName(), EntityUtil.getFieldName(fieldName, updated.getName(), "tags"), stored.getTags(), updated.getTags());
                if (updated.getChildren() == null || stored.getChildren() == null) continue;
                String childrenFieldName = EntityUtil.getFieldName(fieldName, updated.getName());
                this.updateSchemaFields(childrenFieldName, CommonUtil.listOrEmpty((List)stored.getChildren()), CommonUtil.listOrEmpty((List)updated.getChildren()), fieldMatch);
            }
            this.majorVersionChange = this.majorVersionChange || !deletedFields.isEmpty();
        }

        private void updateFieldDescription(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDescription(origField.getDescription());
                return;
            }
            String field = EntityUtil.getSchemaField((APIEndpoint)this.original, origField, "description");
            this.recordChange(field, origField.getDescription(), updatedField.getDescription());
        }

        private void updateFieldDisplayName(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDisplayName(origField.getDisplayName());
                return;
            }
            String field = EntityUtil.getSchemaField((APIEndpoint)this.original, origField, "displayName");
            this.recordChange(field, origField.getDisplayName(), updatedField.getDisplayName());
        }

        private void updateFieldDataTypeDisplay(Field origField, Field updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDataTypeDisplay()) && this.updatedByBot()) {
                updatedField.setDataTypeDisplay(origField.getDataTypeDisplay());
                return;
            }
            String field = EntityUtil.getSchemaField((APIEndpoint)this.original, origField, FIELD_DATA_TYPE_DISPLAY);
            this.recordChange(field, origField.getDataTypeDisplay(), updatedField.getDataTypeDisplay());
        }
    }

    static class ResponseSchemaDescriptionWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Field schemaField;

        ResponseSchemaDescriptionWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = APIEndpointRepository.getResponseSchemaField((APIEndpoint)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.schemaField.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class ResponseSchemaTagWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Field schemaField;

        ResponseSchemaTagWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = APIEndpointRepository.getResponseSchemaField((APIEndpoint)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.schemaField.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }
}

