/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateUser;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.AppException;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.AppMarketPlaceRepository;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRepository
extends EntityRepository<App> {
    private static final Logger LOG = LoggerFactory.getLogger(AppRepository.class);
    public static final String APP_BOT_ROLE = "ApplicationBotRole";
    public static final String UPDATE_FIELDS = "appConfiguration,appSchedule";

    public AppRepository() {
        super("v1/apps/", "app", App.class, Entity.getCollectionDAO().applicationDAO(), UPDATE_FIELDS, UPDATE_FIELDS);
        this.supportsSearch = false;
        this.quoteFqn = true;
    }

    @Override
    public void setFields(App entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : entity.getPipelines());
        entity.withBot(this.getBotUser(entity));
    }

    @Override
    protected List<EntityReference> getIngestionPipelines(App service) {
        return this.findTo(service.getId(), this.entityType, Relationship.HAS, "ingestionPipeline");
    }

    public AppMarketPlaceRepository getMarketPlace() {
        return (AppMarketPlaceRepository)Entity.getEntityRepository("appMarketPlaceDefinition");
    }

    @Override
    public void clearFields(App entity, EntityUtil.Fields fields) {
    }

    @Override
    public void prepare(App entity, boolean update) {
    }

    public EntityReference createNewAppBot(App application) {
        Bot bot;
        User botUser;
        String botName = String.format("%sBot", application.getName());
        BotRepository botRepository = (BotRepository)Entity.getEntityRepository("bot");
        UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
        try {
            botUser = userRepository.getByName(null, botName, userRepository.getFields("id"));
        }
        catch (EntityNotFoundException ex) {
            EntityReference roleRef = Entity.getEntityReferenceByName("role", APP_BOT_ROLE, Include.NON_DELETED);
            AuthenticationMechanism authMechanism = new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.JWT).withConfig((Object)new JWTAuthMechanism().withJWTTokenExpiry(JWTTokenExpiry.Unlimited));
            CreateUser createUser = new CreateUser().withName(botName).withDisplayName(application.getDisplayName()).withEmail(String.format("%s@openmetadata.org", botName)).withIsAdmin(Boolean.valueOf(false)).withIsBot(Boolean.valueOf(true)).withAuthenticationMechanism(authMechanism).withRoles(List.of(roleRef.getId()));
            User user = UserUtil.getUser("admin", createUser);
            user.setOwners(application.getOwners());
            JWTAuthMechanism jwtAuthMechanism = (JWTAuthMechanism)authMechanism.getConfig();
            authMechanism.setConfig((Object)JWTTokenGenerator.getInstance().generateJWTToken(user, jwtAuthMechanism.getJWTTokenExpiry()));
            user.setAuthenticationMechanism(authMechanism);
            botUser = userRepository.createInternal(user);
        }
        try {
            bot = (Bot)botRepository.findByName(botName, Include.NON_DELETED);
        }
        catch (EntityNotFoundException ex) {
            Bot appBot = new Bot().withId(UUID.randomUUID()).withName(botName).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withBotUser(botUser.getEntityReference()).withProvider(ProviderType.USER).withFullyQualifiedName(botName);
            bot = botRepository.createInternal(appBot);
        }
        if (bot != null) {
            return bot.getEntityReference();
        }
        LOG.error("System Failed in Creating a Bot for the Application.");
        return null;
    }

    @Override
    public void storeEntity(App entity, boolean update) {
        List ownerRefs = entity.getOwners();
        entity.withOwners(null);
        this.store(entity, update);
        entity.withOwners(ownerRefs);
    }

    public EntityReference getBotUser(App application) {
        return application.getBot() != null ? application.getBot() : this.getToEntityRef(application.getId(), Relationship.CONTAINS, "bot", false);
    }

    @Override
    public void storeRelationships(App entity) {
        if (entity.getBot() != null) {
            this.addRelationship(entity.getId(), entity.getBot().getId(), "app", "bot", Relationship.CONTAINS);
        }
    }

    public final List<App> listAll() {
        List<String> jsons = this.dao.listAfterWithOffset(Integer.MAX_VALUE, 0);
        ArrayList<App> entities = new ArrayList<App>();
        for (String json : jsons) {
            App entity = JsonUtils.readValue(json, App.class);
            entities.add(entity);
        }
        return entities;
    }

    public ResultList<AppRunRecord> listAppRuns(UUID appId, int limitParam, int offset) {
        int total = this.daoCollection.appExtensionTimeSeriesDao().listAppRunRecordCount(appId.toString());
        ArrayList<AppRunRecord> entities = new ArrayList<AppRunRecord>();
        if (limitParam > 0) {
            List<String> jsons = this.daoCollection.appExtensionTimeSeriesDao().listAppRunRecord(appId.toString(), limitParam, offset);
            for (String json : jsons) {
                AppRunRecord entity = JsonUtils.readValue(json, AppRunRecord.class);
                entities.add(entity);
            }
            return new ResultList<AppRunRecord>(entities, offset, total);
        }
        return new ResultList<AppRunRecord>(entities, null, total);
    }

    @Override
    protected void cleanup(App app) {
        List<EntityReference> pipelineRef = this.getIngestionPipelines(app);
        pipelineRef.forEach(reference -> Entity.deleteEntity("admin", reference.getType(), reference.getId(), true, true));
        super.cleanup(app);
    }

    public AppRunRecord getLatestAppRuns(UUID appId) {
        String json = this.daoCollection.appExtensionTimeSeriesDao().getLatestAppRun(appId);
        if (json == null) {
            throw new AppException("No Available Application Run Records.");
        }
        return JsonUtils.readValue(json, AppRunRecord.class);
    }

    public AppRunRecord getLatestAppRunsAfterStartTime(UUID appId, long startTime) {
        String json = this.daoCollection.appExtensionTimeSeriesDao().getLatestAppRun(appId, startTime);
        if (json == null) {
            throw new AppException("No Available Application Run Records.");
        }
        return JsonUtils.readValue(json, AppRunRecord.class);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(App original, App updated, EntityRepository.Operation operation) {
        return new AppUpdater(original, updated, operation);
    }

    public class AppUpdater
    extends EntityRepository.EntityUpdater {
        public AppUpdater(App original, App updated, EntityRepository.Operation operation) {
            super((EntityRepository)AppRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.recordChange("appConfiguration", ((App)this.original).getAppConfiguration(), ((App)this.updated).getAppConfiguration());
            this.recordChange("appSchedule", ((App)this.original).getAppSchedule(), ((App)this.updated).getAppSchedule());
            this.recordChange("bot", ((App)this.original).getBot(), ((App)this.updated).getBot());
        }
    }
}

