/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRepository
extends EntityRepository<Chart> {
    private static final Logger LOG = LoggerFactory.getLogger(ChartRepository.class);
    private static final String CHART_UPDATE_FIELDS = "dashboards";
    private static final String CHART_PATCH_FIELDS = "dashboards";

    public ChartRepository() {
        super("v1/charts/", "chart", Chart.class, Entity.getCollectionDAO().chartDAO(), "dashboards", "dashboards");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Chart chart) {
        chart.setFullyQualifiedName(FullyQualifiedName.add(chart.getService().getFullyQualifiedName(), chart.getName()));
    }

    @Override
    public void prepare(Chart chart, boolean update) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(chart.getService(), "", Include.ALL);
        chart.setService(dashboardService.getEntityReference());
        chart.setServiceType(dashboardService.getServiceType());
        chart.setDashboards(EntityUtil.getEntityReferences(chart.getDashboards(), Include.NON_DELETED));
    }

    @Override
    public void storeEntity(Chart chart, boolean update) {
        EntityReference service = chart.getService();
        List dashboards = chart.getDashboards();
        chart.withService(null).withDashboards(null);
        this.store(chart, update);
        chart.withService(service).withDashboards(dashboards);
    }

    @Override
    public void storeRelationships(Chart chart) {
        this.addServiceRelationship(chart, chart.getService());
        for (EntityReference dashboard : CommonUtil.listOrEmpty((List)chart.getDashboards())) {
            this.addRelationship(dashboard.getId(), chart.getId(), "dashboard", "chart", Relationship.HAS);
        }
    }

    @Override
    public void setFields(Chart chart, EntityUtil.Fields fields) {
        chart.withService(this.getContainer(chart.getId()));
        chart.setDashboards(fields.contains("dashboards") ? this.getRelatedEntities(chart, "dashboard") : null);
    }

    @Override
    public void clearFields(Chart chart, EntityUtil.Fields fields) {
    }

    @Override
    public void restorePatchAttributes(Chart original, Chart updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Chart original, Chart updated, EntityRepository.Operation operation) {
        return new ChartUpdater(original, updated, operation);
    }

    @Override
    public EntityInterface getParentEntity(Chart entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    private List<EntityReference> getRelatedEntities(Chart chart, String entityType) {
        return chart == null ? Collections.emptyList() : this.findFrom(chart.getId(), "chart", Relationship.HAS, entityType);
    }

    public class ChartUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public ChartUpdater(Chart chart, Chart updated, EntityRepository.Operation operation) {
            super((EntityRepository)ChartRepository.this, (EntityInterface)chart, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("chartType", ((Chart)this.original).getChartType(), ((Chart)this.updated).getChartType());
            this.recordChange("sourceUrl", ((Chart)this.original).getSourceUrl(), ((Chart)this.updated).getSourceUrl());
            this.recordChange("sourceHash", ((Chart)this.original).getSourceHash(), ((Chart)this.updated).getSourceHash());
            this.update("dashboard", "dashboards", CommonUtil.listOrEmpty((List)((Chart)this.updated).getDashboards()), CommonUtil.listOrEmpty((List)((Chart)this.original).getDashboards()));
        }

        private void update(String entityType, String field, List<EntityReference> updEntities, List<EntityReference> oriEntities) {
            ChartRepository.this.deleteTo(((Chart)this.updated).getId(), "chart", Relationship.HAS, entityType);
            for (EntityReference entity : updEntities) {
                ChartRepository.this.addRelationship(entity.getId(), ((Chart)this.updated).getId(), entityType, "chart", Relationship.HAS);
            }
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange(field, oriEntities, updEntities, added, deleted, EntityUtil.entityReferenceMatch);
        }
    }
}

