/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.util.EntityUtil;

public class DataInsightSystemChartRepository
extends EntityRepository<DataInsightCustomChart> {
    public static final String COLLECTION_PATH = "/v1/analytics/dataInsights/system/charts";
    private static final SearchClient searchClient = Entity.getSearchRepository().getSearchClient();
    public static final String TIMESTAMP_FIELD = "@timestamp";
    public static final String DI_SEARCH_INDEX = "di-data-assets-*";
    public static final String FORMULA_FUNC_REGEX = "\\b(count|sum|min|max|avg|unique)+\\((k='([^']*)')?,?\\s*(q='([^']*)')?\\)?";
    public static final String NUMERIC_VALIDATION_REGEX = "[\\d\\.+-\\/\\*\\(\\) ]+";

    public DataInsightSystemChartRepository() {
        super(COLLECTION_PATH, "dataInsightCustomChart", DataInsightCustomChart.class, Entity.getCollectionDAO().dataInsightCustomChartDAO(), "", "");
    }

    @Override
    public void setFields(DataInsightCustomChart entity, EntityUtil.Fields fields) {
    }

    @Override
    public void clearFields(DataInsightCustomChart entity, EntityUtil.Fields fields) {
    }

    @Override
    public void prepare(DataInsightCustomChart entity, boolean update) {
    }

    @Override
    public void storeEntity(DataInsightCustomChart entity, boolean update) {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(DataInsightCustomChart entity) {
    }

    public DataInsightCustomChartResultList getPreviewData(DataInsightCustomChart chart, long startTimestamp, long endTimestamp, String filter) throws IOException {
        if (chart.getChartDetails() != null && filter != null) {
            ((LinkedHashMap)chart.getChartDetails()).put("filter", filter);
        }
        return this.getPreviewData(chart, startTimestamp, endTimestamp);
    }

    public DataInsightCustomChartResultList getPreviewData(DataInsightCustomChart chart, long startTimestamp, long endTimestamp) throws IOException {
        return searchClient.buildDIChart(chart, startTimestamp, endTimestamp);
    }

    public Map<String, DataInsightCustomChartResultList> listChartData(String chartNames, long startTimestamp, long endTimestamp, String filter) throws IOException {
        HashMap<String, DataInsightCustomChartResultList> result = new HashMap<String, DataInsightCustomChartResultList>();
        if (chartNames == null) {
            return result;
        }
        for (String chartName : chartNames.split(",")) {
            DataInsightCustomChart chart = (DataInsightCustomChart)Entity.getEntityByName("dataInsightCustomChart", chartName, "", Include.NON_DELETED);
            if (chart == null) continue;
            if (chart.getChartDetails() != null && filter != null) {
                ((LinkedHashMap)chart.getChartDetails()).put("filter", filter);
            }
            DataInsightCustomChartResultList data = searchClient.buildDIChart(chart, startTimestamp, endTimestamp);
            result.put(chartName, data);
        }
        return result;
    }
}

