/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.email.EmailTemplate;
import org.openmetadata.schema.email.TemplateValidationResponse;
import org.openmetadata.schema.entities.docStore.Data;
import org.openmetadata.schema.entities.docStore.Document;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.DefaultTemplateProvider;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRepository
extends EntityRepository<Document> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentRepository.class);
    static final String DOCUMENT_UPDATE_FIELDS = "data";
    static final String DOCUMENT_PATCH_FIELDS = "data";
    private final CollectionDAO.DocStoreDAO dao;
    private final TemplateProvider templateProvider;

    public DocumentRepository() {
        super("/v1/docStore", "document", Document.class, Entity.getCollectionDAO().docStoreDAO(), "data", "data");
        this.supportsSearch = false;
        this.dao = Entity.getCollectionDAO().docStoreDAO();
        this.templateProvider = new DefaultTemplateProvider();
    }

    public List<Document> fetchAllEmailTemplates() {
        List<String> jsons = this.dao.fetchAllEmailTemplates();
        return jsons.stream().map(json -> JsonUtils.readValue(json, Document.class)).toList();
    }

    public EmailTemplate fetchEmailTemplateByName(String name) {
        String json = this.dao.fetchEmailTemplateByName(name);
        if (json == null) {
            throw new EntityNotFoundException("Email template not found with name : " + name);
        }
        Document document = JsonUtils.readValue(json, Document.class);
        return JsonUtils.convertValue((Object)document.getData(), EmailTemplate.class);
    }

    @Transaction
    public void deleteEmailTemplates() {
        this.dao.deleteEmailTemplates();
    }

    @Override
    public void setFullyQualifiedName(Document doc) {
        doc.setFullyQualifiedName(doc.getFullyQualifiedName());
    }

    @Override
    public void setFields(Document document, EntityUtil.Fields fields) {
    }

    @Override
    public void clearFields(Document document, EntityUtil.Fields fields) {
    }

    @Override
    public void prepare(Document document, boolean update) {
    }

    @Override
    public void storeEntity(Document document, boolean update) {
        this.store(document, update);
    }

    @Override
    public void storeRelationships(Document entity) {
    }

    public TemplateValidationResponse validateEmailTemplate(String name, String content) {
        return this.templateProvider.validateEmailTemplate(name, content);
    }

    public DocumentUpdater getUpdater(Document original, Document updated, EntityRepository.Operation operation) {
        return new DocumentUpdater(original, updated, operation);
    }

    public void updateEmailTemplatePlaceholders(Document original, Document updated) {
        if (updated.getEntityType().equals("EmailTemplate")) {
            EmailTemplate originalTemplate = JsonUtils.convertValue((Object)original.getData(), EmailTemplate.class);
            EmailTemplate updatedTemplate = JsonUtils.convertValue((Object)updated.getData(), EmailTemplate.class);
            updatedTemplate.setPlaceHolders(originalTemplate.getPlaceHolders());
            updated.setData(JsonUtils.convertValue((Object)updatedTemplate, Data.class));
        }
    }

    public class DocumentUpdater
    extends EntityRepository.EntityUpdater {
        public DocumentUpdater(Document original, Document updated, EntityRepository.Operation operation) {
            super((EntityRepository)DocumentRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            DocumentRepository.this.updateEmailTemplatePlaceholders((Document)this.original, (Document)this.updated);
            this.recordChange("data", ((Document)this.original).getData(), ((Document)this.updated).getData(), true);
        }
    }
}

