/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResult;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.util.EntityUtil;

public class KpiRepository
extends EntityRepository<Kpi> {
    private static final String KPI_RESULT_FIELD = "kpiResult";
    public static final String COLLECTION_PATH = "/v1/kpi";
    private static final String UPDATE_FIELDS = "targetValue,dataInsightChart,startDate,endDate,metricType";
    private static final String PATCH_FIELDS = "targetValue,dataInsightChart,description,startDate,endDate,metricType";

    public KpiRepository() {
        super(COLLECTION_PATH, "kpi", Kpi.class, Entity.getCollectionDAO().kpiDAO(), PATCH_FIELDS, UPDATE_FIELDS);
    }

    @Override
    public void setFields(Kpi kpi, EntityUtil.Fields fields) {
        kpi.setDataInsightChart(fields.contains("dataInsightChart") ? this.getDataInsightChart(kpi) : kpi.getDataInsightChart());
        kpi.withKpiResult(fields.contains(KPI_RESULT_FIELD) ? this.getKpiResult(kpi.getFullyQualifiedName()) : kpi.getKpiResult());
    }

    @Override
    public void clearFields(Kpi kpi, EntityUtil.Fields fields) {
        kpi.setDataInsightChart(fields.contains("dataInsightChart") ? kpi.getDataInsightChart() : null);
        kpi.withKpiResult(fields.contains(KPI_RESULT_FIELD) ? kpi.getKpiResult() : null);
    }

    @Override
    public void prepare(Kpi kpi, boolean update) {
        DataInsightCustomChart chart = (DataInsightCustomChart)Entity.getEntity(kpi.getDataInsightChart(), null, Include.NON_DELETED);
        kpi.setDataInsightChart(chart.getEntityReference());
    }

    @Override
    public void storeEntity(Kpi kpi, boolean update) {
        EntityReference dataInsightChart = kpi.getDataInsightChart();
        KpiResult kpiResults = kpi.getKpiResult();
        kpi.withDataInsightChart(null).withKpiResult(null);
        this.store(kpi, update);
        kpi.withDataInsightChart(dataInsightChart).withKpiResult(kpiResults);
    }

    @Override
    public void storeRelationships(Kpi kpi) {
        this.addRelationship(kpi.getId(), kpi.getDataInsightChart().getId(), "kpi", "dataInsightCustomChart", Relationship.USES);
    }

    private EntityReference getDataInsightChart(Kpi kpi) {
        return this.getToEntityRef(kpi.getId(), Relationship.USES, "dataInsightCustomChart", true);
    }

    public KpiResult getKpiResult(String fqn) {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        Kpi kpi = (Kpi)Entity.getEntityByName("kpi", fqn, UPDATE_FIELDS, null);
        DataInsightCustomChart dataInsightCustomChart = (DataInsightCustomChart)Entity.getEntity(kpi.getDataInsightChart(), null, Include.NON_DELETED);
        DataInsightCustomChartResultList resultList = null;
        try {
            resultList = this.searchRepository.getSearchClient().buildDIChart(dataInsightCustomChart, start, end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (resultList != null && !resultList.getResults().isEmpty()) {
            DataInsightCustomChartResult result = (DataInsightCustomChartResult)resultList.getResults().get(0);
            KpiTarget target = new KpiTarget().withValue(result.getCount().toString()).withTargetMet(Boolean.valueOf(result.getCount() >= kpi.getTargetValue()));
            ArrayList<KpiTarget> targetList = new ArrayList<KpiTarget>();
            targetList.add(target);
            return new KpiResult().withKpiFqn(kpi.getFullyQualifiedName()).withTimestamp(Long.valueOf(end)).withTargetResult(targetList);
        }
        return null;
    }

    public DataInsightCustomChartResultList getKpiResults(String fqn, Long startTs, Long endTs, EntityTimeSeriesDAO.OrderBy orderBy) throws IOException {
        Kpi kpi = (Kpi)Entity.getEntityByName("kpi", fqn, UPDATE_FIELDS, null);
        DataInsightCustomChart dataInsightCustomChart = (DataInsightCustomChart)Entity.getEntity(kpi.getDataInsightChart(), null, Include.NON_DELETED);
        DataInsightCustomChartResultList resultList = this.searchRepository.getSearchClient().buildDIChart(dataInsightCustomChart, startTs, endTs);
        return resultList;
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
        return new KpiUpdater(original, updated, operation);
    }

    public class KpiUpdater
    extends EntityRepository.EntityUpdater {
        public KpiUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
            super((EntityRepository)KpiRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateToRelationship("dataInsightChart", "kpi", ((Kpi)this.original).getId(), Relationship.USES, "dataInsightChart", ((Kpi)this.original).getDataInsightChart(), ((Kpi)this.updated).getDataInsightChart(), false);
            this.recordChange("targetValue", ((Kpi)this.original).getTargetValue(), ((Kpi)this.updated).getTargetValue(), true);
            this.recordChange("startDate", ((Kpi)this.original).getStartDate(), ((Kpi)this.updated).getStartDate());
            this.recordChange("endDate", ((Kpi)this.original).getEndDate(), ((Kpi)this.updated).getEndDate());
            this.recordChange("metricType", ((Kpi)this.original).getMetricType(), ((Kpi)this.updated).getMetricType());
        }
    }
}

