/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRepository
extends EntityRepository<Role> {
    private static final Logger LOG = LoggerFactory.getLogger(RoleRepository.class);
    public static final String DOMAIN_ONLY_ACCESS_ROLE = "DomainOnlyAccessRole";

    public RoleRepository() {
        super("/v1/roles/", "role", Role.class, Entity.getCollectionDAO().roleDAO(), "policies", "policies");
    }

    @Override
    public void setFields(Role role, EntityUtil.Fields fields) {
        role.setPolicies(fields.contains("policies") ? this.getPolicies(role) : role.getPolicies());
        role.setTeams(fields.contains("teams") ? this.getTeams(role) : role.getTeams());
        role.withUsers(fields.contains("users") ? this.getUsers(role) : role.getUsers());
    }

    @Override
    public void clearFields(Role role, EntityUtil.Fields fields) {
        role.setPolicies(fields.contains("policies") ? role.getPolicies() : null);
        role.setTeams(fields.contains("teams") ? role.getTeams() : null);
        role.withUsers(fields.contains("users") ? role.getUsers() : null);
    }

    private List<EntityReference> getPolicies(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.findTo(role.getId(), "role", Relationship.HAS, "policy");
    }

    private List<EntityReference> getUsers(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.findFrom(role.getId(), "role", Relationship.HAS, "user");
    }

    private List<EntityReference> getTeams(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.findFrom(role.getId(), "role", Relationship.HAS, "team");
    }

    @Override
    public void prepare(Role role, boolean update) {
        if (CommonUtil.listOrEmpty((List)role.getPolicies()).isEmpty()) {
            throw new IllegalArgumentException("At least one policy is required in a role");
        }
        EntityUtil.populateEntityReferences(role.getPolicies());
    }

    @Override
    public void storeEntity(Role role, boolean update) {
        List policies = role.getPolicies();
        role.withPolicies(null);
        this.store(role, update);
        role.withPolicies(policies);
    }

    @Override
    public void storeRelationships(Role role) {
        for (EntityReference policy : CommonUtil.listOrEmpty((List)role.getPolicies())) {
            this.addRelationship(role.getId(), policy.getId(), "role", "policy", Relationship.HAS);
        }
    }

    public RoleUpdater getUpdater(Role original, Role updated, EntityRepository.Operation operation) {
        return new RoleUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Role entity, String deletedBy) {
        if (Boolean.FALSE.equals(entity.getAllowDelete())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityDeleteNotAllowed(entity.getName(), "role"));
        }
    }

    public class RoleUpdater
    extends EntityRepository.EntityUpdater {
        public RoleUpdater(Role original, Role updated, EntityRepository.Operation operation) {
            super((EntityRepository)RoleRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updatePolicies(CommonUtil.listOrEmpty((List)((Role)this.original).getPolicies()), CommonUtil.listOrEmpty((List)((Role)this.updated).getPolicies()));
        }

        private void updatePolicies(List<EntityReference> origPolicies, List<EntityReference> updatedPolicies) {
            ArrayList addedPolicies = new ArrayList();
            ArrayList deletedPolicies = new ArrayList();
            boolean changed = this.recordListChange("policies", origPolicies, updatedPolicies, addedPolicies, deletedPolicies, EntityUtil.entityReferenceMatch);
            if (changed) {
                RoleRepository.this.deleteFrom(((Role)this.original).getId(), "role", Relationship.HAS, "policy");
                RoleRepository.this.storeRelationships((Role)this.updated);
            }
        }
    }
}

