/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Suggestion;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.SuggestionStatus;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.sdk.exception.SuggestionException;
import org.openmetadata.service.Entity;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.jdbi3.SuggestionFilter;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.feeds.SuggestionsResource;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public class SuggestionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestionRepository.class);
    private final CollectionDAO dao = Entity.getCollectionDAO();

    public SuggestionRepository() {
        Entity.setSuggestionRepository(this);
        ResourceRegistry.addResource("suggestion", null, Entity.getEntityFields(Suggestion.class));
    }

    @Transaction
    public Suggestion create(Suggestion suggestion) {
        this.store(suggestion);
        this.storeRelationships(suggestion);
        return suggestion;
    }

    @Transaction
    public Suggestion update(Suggestion suggestion, String userName) {
        suggestion.setUpdatedBy(userName);
        this.dao.suggestionDAO().update(suggestion.getId(), JsonUtils.pojoToJson(suggestion));
        this.storeRelationships(suggestion);
        return suggestion;
    }

    @Transaction
    public void store(Suggestion suggestion) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        this.dao.suggestionDAO().insert(entityLink.getEntityFQN(), JsonUtils.pojoToJson(suggestion));
    }

    @Transaction
    public void storeRelationships(Suggestion suggestion) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        this.dao.relationshipDAO().insert(suggestion.getCreatedBy().getId(), suggestion.getId(), suggestion.getCreatedBy().getType(), "SUGGESTION", Relationship.CREATED.ordinal());
        this.dao.fieldRelationshipDAO().insert(suggestion.getId().toString(), entityLink.getFullyQualifiedFieldValue(), suggestion.getId().toString(), entityLink.getFullyQualifiedFieldValue(), "SUGGESTION", entityLink.getFullyQualifiedFieldType(), Relationship.IS_ABOUT.ordinal(), null);
    }

    public Suggestion get(UUID id) {
        return EntityUtil.validate(id, this.dao.suggestionDAO().findById(id), Suggestion.class);
    }

    @Transaction
    public RestUtil.DeleteResponse<Suggestion> deleteSuggestion(Suggestion suggestion, String deletedByUser) {
        this.deleteSuggestionInternal(suggestion.getId());
        LOG.debug("{} deleted suggestion with id {}", (Object)deletedByUser, (Object)suggestion.getId());
        return new RestUtil.DeleteResponse<Suggestion>(suggestion, EventType.SUGGESTION_DELETED);
    }

    @Transaction
    public RestUtil.DeleteResponse<EntityInterface> deleteSuggestionsForAnEntity(EntityInterface entity, String deletedByUser) {
        this.deleteSuggestionInternalForAnEntity(entity);
        LOG.debug("{} deleted suggestions for the entity id {}", (Object)deletedByUser, (Object)entity.getId());
        return new RestUtil.DeleteResponse<EntityInterface>(entity, EventType.SUGGESTION_DELETED);
    }

    @Transaction
    public void deleteSuggestionInternal(UUID id) {
        this.dao.relationshipDAO().deleteAll(id, "SUGGESTION");
        this.dao.fieldRelationshipDAO().deleteAllByPrefix(id.toString());
        this.dao.suggestionDAO().delete(id);
    }

    @Transaction
    public void deleteSuggestionInternalForAnEntity(EntityInterface entity) {
        this.dao.fieldRelationshipDAO().deleteAllByPrefix(entity.getId().toString());
        this.dao.suggestionDAO().deleteByFQN(entity.getFullyQualifiedName());
    }

    public RestUtil.PutResponse<Suggestion> acceptSuggestion(UriInfo uriInfo, Suggestion suggestion, SecurityContext securityContext, Authorizer authorizer) {
        this.acceptSuggestion(suggestion, securityContext, authorizer);
        Suggestion updatedHref = SuggestionsResource.addHref(uriInfo, suggestion);
        return new RestUtil.PutResponse<Suggestion>(Response.Status.OK, updatedHref, EventType.SUGGESTION_ACCEPTED);
    }

    public RestUtil.PutResponse<List<Suggestion>> acceptSuggestionList(UriInfo uriInfo, List<Suggestion> suggestions, SuggestionType suggestionType, SecurityContext securityContext, Authorizer authorizer) {
        this.acceptSuggestionList(suggestions, suggestionType, securityContext, authorizer);
        List<Suggestion> updatedHref = suggestions.stream().map(suggestion -> SuggestionsResource.addHref(uriInfo, suggestion)).toList();
        return new RestUtil.PutResponse<List<Suggestion>>(Response.Status.OK, updatedHref, EventType.SUGGESTION_ACCEPTED);
    }

    protected void acceptSuggestion(Suggestion suggestion, SecurityContext securityContext, Authorizer authorizer) {
        String user = securityContext.getUserPrincipal().getName();
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityLink.getEntityType());
        EntityInterface entity = (EntityInterface)Entity.getEntity(entityLink, repository.getSuggestionFields(suggestion), Include.ALL);
        String origJson = JsonUtils.pojoToJson(entity);
        SuggestionWorkflow suggestionWorkflow = repository.getSuggestionWorkflow(entity);
        EntityInterface updatedEntity = suggestionWorkflow.acceptSuggestion(suggestion, entity);
        String updatedEntityJson = JsonUtils.pojoToJson(updatedEntity);
        JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedEntityJson);
        OperationContext operationContext = new OperationContext(entityLink.getEntityType(), patch);
        authorizer.authorize(securityContext, operationContext, new ResourceContext(entityLink.getEntityType(), entity.getId(), null));
        repository.patch(null, entity.getId(), user, patch);
        suggestion.setStatus(SuggestionStatus.Accepted);
        this.update(suggestion, user);
    }

    @Transaction
    protected void acceptSuggestionList(List<Suggestion> suggestions, SuggestionType suggestionType, SecurityContext securityContext, Authorizer authorizer) {
        String user = securityContext.getUserPrincipal().getName();
        EntityInterface entity = null;
        EntityRepository<? extends EntityInterface> repository = null;
        String origJson = null;
        SuggestionWorkflow suggestionWorkflow = null;
        for (Suggestion suggestion : suggestions) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
            if (entity == null) {
                entity = (EntityInterface)Entity.getEntity(entityLink, suggestionType == SuggestionType.SuggestTagLabel ? "tags" : "", Include.NON_DELETED);
                repository = Entity.getEntityRepository(entityLink.getEntityType());
                origJson = JsonUtils.pojoToJson(entity);
                suggestionWorkflow = repository.getSuggestionWorkflow(entity);
            } else if (!entity.getFullyQualifiedName().equals(entityLink.getEntityFQN())) {
                throw new SuggestionException("All suggestions must be for the same entity");
            }
            entity = suggestionWorkflow.acceptSuggestion(suggestion, entity);
        }
        String updatedEntityJson = JsonUtils.pojoToJson(entity);
        JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedEntityJson);
        OperationContext operationContext = new OperationContext(repository.getEntityType(), patch);
        authorizer.authorize(securityContext, operationContext, new ResourceContext(repository.getEntityType(), entity.getId(), null));
        repository.patch(null, entity.getId(), user, patch);
        for (Suggestion suggestion : suggestions) {
            suggestion.setStatus(SuggestionStatus.Accepted);
            this.update(suggestion, user);
        }
    }

    public RestUtil.PutResponse<Suggestion> rejectSuggestion(UriInfo uriInfo, Suggestion suggestion, String user) {
        suggestion.setStatus(SuggestionStatus.Rejected);
        this.update(suggestion, user);
        Suggestion updatedHref = SuggestionsResource.addHref(uriInfo, suggestion);
        return new RestUtil.PutResponse<Suggestion>(Response.Status.OK, updatedHref, EventType.SUGGESTION_REJECTED);
    }

    @Transaction
    public RestUtil.PutResponse<List<Suggestion>> rejectSuggestionList(UriInfo uriInfo, List<Suggestion> suggestions, String user) {
        for (Suggestion suggestion : suggestions) {
            suggestion.setStatus(SuggestionStatus.Rejected);
            this.update(suggestion, user);
            SuggestionsResource.addHref(uriInfo, suggestion);
        }
        return new RestUtil.PutResponse<List<Suggestion>>(Response.Status.OK, suggestions, EventType.SUGGESTION_REJECTED);
    }

    public void checkPermissionsForUpdateSuggestion(Suggestion suggestion, SecurityContext securityContext) {
        String userName = securityContext.getUserPrincipal().getName();
        User user = (User)Entity.getEntityByName("user", userName, "teams", Include.NON_DELETED);
        if (Boolean.FALSE.equals(user.getIsAdmin()) && !userName.equalsIgnoreCase(suggestion.getCreatedBy().getName())) {
            throw new AuthorizationException(CatalogExceptionMessage.suggestionOperationNotAllowed(userName, "Update"));
        }
    }

    public void checkPermissionsForAcceptOrRejectSuggestion(Suggestion suggestion, SuggestionStatus status, SecurityContext securityContext) {
        String userName = securityContext.getUserPrincipal().getName();
        User user = (User)Entity.getEntityByName("user", userName, "teams", Include.NON_DELETED);
        MessageParser.EntityLink about = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        EntityReference aboutRef = EntityUtil.validateEntityLink(about);
        List<EntityReference> ownerRefs = Entity.getOwners(aboutRef);
        List<String> ownerTeamNames = new ArrayList<String>();
        if (!CommonUtil.nullOrEmpty(ownerRefs)) {
            for (EntityReference ownerRef2 : ownerRefs) {
                try {
                    User owner = (User)Entity.getEntityByName("user", ownerRef2.getFullyQualifiedName(), "teams", Include.NON_DELETED);
                    ownerTeamNames = owner.getTeams().stream().map(EntityReference::getFullyQualifiedName).toList();
                }
                catch (EntityNotFoundException e) {
                    Team owner = (Team)Entity.getEntityByName("team", ownerRef2.getFullyQualifiedName(), "", Include.NON_DELETED);
                    ownerTeamNames.add(owner.getFullyQualifiedName());
                }
            }
        }
        List<String> userTeamNames = user.getTeams().stream().map(EntityReference::getFullyQualifiedName).toList();
        if (Boolean.FALSE.equals(user.getIsAdmin()) && !CommonUtil.nullOrEmpty(ownerRefs) && ownerRefs.stream().noneMatch(ownerRef -> ownerRef.getName().equals(userName)) && Collections.disjoint(userTeamNames, ownerTeamNames)) {
            throw new AuthorizationException(CatalogExceptionMessage.suggestionOperationNotAllowed(userName, status.value()));
        }
    }

    public void checkPermissionsForEditEntity(Suggestion suggestion, SuggestionType suggestionType, SecurityContext securityContext, Authorizer authorizer) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        EntityInterface entity = (EntityInterface)Entity.getEntity(entityLink, "", Include.NON_DELETED);
        authorizer.authorize(securityContext, new OperationContext(entityLink.getEntityType(), suggestionType == SuggestionType.SuggestTagLabel ? MetadataOperation.EDIT_TAGS : MetadataOperation.EDIT_DESCRIPTION), new ResourceContext(entityLink.getEntityType(), entity.getId(), null));
    }

    public int listCount(SuggestionFilter filter) {
        String mySqlCondition = filter.getCondition(false);
        String postgresCondition = filter.getCondition(false);
        return this.dao.suggestionDAO().listCount(mySqlCondition, postgresCondition);
    }

    public ResultList<Suggestion> listBefore(SuggestionFilter filter, int limit, String before) {
        int total = this.listCount(filter);
        String mySqlCondition = filter.getCondition(true);
        String postgresCondition = filter.getCondition(true);
        List<String> jsons = this.dao.suggestionDAO().listBefore(mySqlCondition, postgresCondition, limit + 1, RestUtil.decodeCursor(before));
        List<Suggestion> suggestions = this.getSuggestionList(jsons);
        String beforeCursor = null;
        if (suggestions.size() > limit) {
            suggestions.remove(0);
            beforeCursor = suggestions.get(0).getUpdatedAt().toString();
        }
        String afterCursor = !suggestions.isEmpty() ? suggestions.get(suggestions.size() - 1).getUpdatedAt().toString() : null;
        return new ResultList<Suggestion>(suggestions, beforeCursor, afterCursor, total);
    }

    public ResultList<Suggestion> listAfter(SuggestionFilter filter, int limit, String after) {
        String beforeCursor;
        int total = this.listCount(filter);
        String mySqlCondition = filter.getCondition(true);
        String postgresCondition = filter.getCondition(true);
        List<String> jsons = this.dao.suggestionDAO().listAfter(mySqlCondition, postgresCondition, limit + 1, RestUtil.decodeCursor(after));
        List<Suggestion> suggestions = this.getSuggestionList(jsons);
        String afterCursor = null;
        String string = beforeCursor = after == null ? null : suggestions.get(0).getUpdatedAt().toString();
        if (suggestions.size() > limit) {
            suggestions.remove(limit);
            afterCursor = suggestions.get(limit - 1).getUpdatedAt().toString();
        }
        return new ResultList<Suggestion>(suggestions, beforeCursor, afterCursor, total);
    }

    private List<Suggestion> getSuggestionList(List<String> jsons) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        for (String json : jsons) {
            Suggestion suggestion = JsonUtils.readValue(json, Suggestion.class);
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    public final List<Suggestion> listAll(SuggestionFilter filter) {
        ResultList<Suggestion> suggestionList = this.listAfter(filter, 0x7FFFFFFE, "");
        return suggestionList.getData();
    }

    public static class SuggestionWorkflow {
        protected final EntityInterface entity;

        SuggestionWorkflow(EntityInterface entity) {
            this.entity = entity;
        }

        public EntityInterface acceptSuggestion(Suggestion suggestion, EntityInterface entity) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
            if (entityLink.getFieldName() != null) {
                EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityLink.getEntityType());
                return repository.applySuggestion(entity, entityLink.getFullyQualifiedFieldValue(), suggestion);
            }
            if (suggestion.getType().equals((Object)SuggestionType.SuggestTagLabel)) {
                ArrayList tags = new ArrayList(entity.getTags());
                tags.addAll(suggestion.getTagLabels());
                entity.setTags(tags);
                return entity;
            }
            if (suggestion.getType().equals((Object)SuggestionType.SuggestDescription)) {
                entity.setDescription(suggestion.getDescription());
                return entity;
            }
            throw new SuggestionException("Invalid suggestion Type");
        }

        public EntityInterface getEntity() {
            return this.entity;
        }
    }

    public static enum PaginationType {
        BEFORE,
        AFTER;

    }
}

