/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.TeamHierarchy;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.api.BulkAssets;
import org.openmetadata.schema.type.api.BulkOperationResult;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvErrorType;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamRepository
extends EntityRepository<Team> {
    private static final Logger LOG = LoggerFactory.getLogger(TeamRepository.class);
    static final String PARENTS_FIELD = "parents";
    static final String TEAM_UPDATE_FIELDS = "profile,users,defaultRoles,parents,children,policies,teamType,email,domains";
    static final String TEAM_PATCH_FIELDS = "profile,users,defaultRoles,parents,children,policies,teamType,email,domains";
    private static final String DEFAULT_ROLES = "defaultRoles";
    private Team organization = null;

    public TeamRepository() {
        super("/v1/teams/", "team", Team.class, Entity.getCollectionDAO().teamDAO(), "profile,users,defaultRoles,parents,children,policies,teamType,email,domains", "profile,users,defaultRoles,parents,children,policies,teamType,email,domains");
        this.quoteFqn = true;
        this.supportsSearch = true;
    }

    @Override
    public void setFields(Team team, EntityUtil.Fields fields) {
        team.setUsers(fields.contains("users") ? this.getUsers(team) : team.getUsers());
        team.setOwns(fields.contains("owns") ? this.getOwns(team) : team.getOwns());
        team.setDefaultRoles(fields.contains(DEFAULT_ROLES) ? this.getDefaultRoles(team) : team.getDefaultRoles());
        team.setInheritedRoles(fields.contains(DEFAULT_ROLES) ? this.getInheritedRoles(team) : team.getInheritedRoles());
        team.setParents(fields.contains(PARENTS_FIELD) ? this.getParents(team) : team.getParents());
        team.setPolicies(fields.contains("policies") ? this.getPolicies(team) : team.getPolicies());
        team.setChildrenCount(fields.contains("childrenCount") ? this.getChildrenCount(team) : team.getChildrenCount());
        team.setUserCount(fields.contains("userCount") ? this.getUserCount(team.getId()) : team.getUserCount());
        team.setDomains((List)(fields.contains("domains") ? this.getDomains(team.getId()) : team.getDomains()));
    }

    @Override
    public void clearFields(Team team, EntityUtil.Fields fields) {
        team.setProfile(fields.contains("profile") ? team.getProfile() : null);
        team.setUsers(fields.contains("users") ? team.getUsers() : null);
        team.setOwns(fields.contains("owns") ? team.getOwns() : null);
        team.setDefaultRoles(fields.contains(DEFAULT_ROLES) ? team.getDefaultRoles() : null);
        team.setInheritedRoles(fields.contains(DEFAULT_ROLES) ? team.getInheritedRoles() : null);
        team.setParents(fields.contains(PARENTS_FIELD) ? team.getParents() : null);
        team.setPolicies(fields.contains("policies") ? team.getPolicies() : null);
        team.setChildrenCount(fields.contains("childrenCount") ? team.getChildrenCount() : null);
        team.withUserCount(fields.contains("userCount") ? team.getUserCount() : null);
    }

    private List<EntityReference> getDomains(UUID teamId) {
        return this.findFrom(teamId, "team", Relationship.HAS, "domain");
    }

    @Override
    protected void storeDomain(Team entity, EntityReference exclude) {
        for (EntityReference domainRef : CommonUtil.listOrEmpty((List)entity.getDomains())) {
            LOG.info("Adding domain {} for user {}:{}", new Object[]{domainRef.getFullyQualifiedName(), this.entityType, entity.getId()});
            this.addRelationship(domainRef.getId(), entity.getId(), "domain", this.entityType, Relationship.HAS);
        }
    }

    @Override
    public void restorePatchAttributes(Team original, Team updated) {
        super.restorePatchAttributes(original, updated);
        updated.withInheritedRoles(original.getInheritedRoles());
    }

    @Override
    public void prepare(Team team, boolean update) {
        this.populateParents(team);
        this.populateChildren(team);
        this.validateUsers(team.getUsers());
        this.validateRoles(team.getDefaultRoles());
        this.validatePolicies(team.getPolicies());
    }

    public BulkOperationResult bulkAddAssets(String domainName, BulkAssets request) {
        Team team = (Team)this.getByName(null, domainName, this.getFields("id"));
        this.validateAllRefUsers(request.getAssets());
        for (EntityReference asset : request.getAssets()) {
            if (Objects.equals(asset.getType(), "user")) continue;
            throw new IllegalArgumentException("Only users can be added to a Team");
        }
        return this.bulkAssetsOperation(team.getId(), "team", Relationship.HAS, request, true);
    }

    public BulkOperationResult bulkRemoveAssets(String domainName, BulkAssets request) {
        Team team = (Team)this.getByName(null, domainName, this.getFields("id"));
        this.validateAllRefUsers(request.getAssets());
        return this.bulkAssetsOperation(team.getId(), "team", Relationship.HAS, request, false);
    }

    private void validateAllRefUsers(List<EntityReference> refs) {
        for (EntityReference asset : refs) {
            if (Objects.equals(asset.getType(), "user")) continue;
            throw new IllegalArgumentException("Only users can be added to a Team");
        }
    }

    @Override
    public void storeEntity(Team team, boolean update) {
        List users = team.getUsers();
        List defaultRoles = team.getDefaultRoles();
        List parents = team.getParents();
        List policies = team.getPolicies();
        team.withUsers(null).withDefaultRoles(null).withParents(null).withPolicies(null).withInheritedRoles(null);
        this.store(team, update);
        team.withUsers(users).withDefaultRoles(defaultRoles).withParents(parents).withPolicies(policies);
    }

    @Override
    public void storeRelationships(Team team) {
        for (EntityReference user : CommonUtil.listOrEmpty((List)team.getUsers())) {
            this.addRelationship(team.getId(), user.getId(), "team", "user", Relationship.HAS);
        }
        for (EntityReference defaultRole : CommonUtil.listOrEmpty((List)team.getDefaultRoles())) {
            this.addRelationship(team.getId(), defaultRole.getId(), "team", "role", Relationship.HAS);
        }
        for (EntityReference parent : CommonUtil.listOrEmpty((List)team.getParents())) {
            if (parent.getId().equals(this.organization.getId())) continue;
            this.addRelationship(parent.getId(), team.getId(), "team", "team", Relationship.PARENT_OF);
        }
        for (EntityReference child : CommonUtil.listOrEmpty((List)team.getChildren())) {
            this.addRelationship(team.getId(), child.getId(), "team", "team", Relationship.PARENT_OF);
        }
        for (EntityReference policy : CommonUtil.listOrEmpty((List)team.getPolicies())) {
            this.addRelationship(team.getId(), policy.getId(), "team", "policy", Relationship.HAS);
        }
    }

    @Override
    public void setInheritedFields(Team team, EntityUtil.Fields fields) {
        if (fields.contains("domains")) {
            List<EntityReference> parents;
            TreeSet<EntityReference> combinedParent = new TreeSet<EntityReference>(EntityUtil.compareEntityReferenceById);
            List<EntityReference> list = parents = !fields.contains(PARENTS_FIELD) ? this.getParents(team) : team.getParents();
            if (!CommonUtil.nullOrEmpty(parents)) {
                for (EntityReference parentRef : parents) {
                    Team parentTeam = (Team)Entity.getEntity("team", parentRef.getId(), "domains", Include.ALL);
                    combinedParent.addAll(parentTeam.getDomains());
                }
            }
            team.setDomains(EntityUtil.mergedInheritedEntityRefs(team.getDomains(), combinedParent.stream().toList()));
        }
    }

    public TeamUpdater getUpdater(Team original, Team updated, EntityRepository.Operation operation) {
        return new TeamUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Team entity, String deletedBy) {
        if (entity.getId().equals(this.organization.getId())) {
            throw new IllegalArgumentException("Organization team type can't be deleted");
        }
    }

    @Override
    protected void cleanup(Team team) {
        for (EntityReference child : CommonUtil.listOrEmpty((List)team.getChildren())) {
            Team childTeam = (Team)this.find(child.getId(), Include.NON_DELETED);
            this.getParents(childTeam);
            if (childTeam.getParents().size() != 1) continue;
            this.addRelationship(this.organization.getId(), childTeam.getId(), "team", "team", Relationship.PARENT_OF);
            LOG.info("Moving parent of team " + childTeam.getId() + " to organization");
        }
        super.cleanup(team);
    }

    @Override
    public String exportToCsv(String parentTeam, String user) throws IOException {
        Team team = (Team)this.getByName(null, parentTeam, EntityUtil.Fields.EMPTY_FIELDS);
        return new TeamCsv(team, user).exportCsv();
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        Team team = (Team)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        TeamCsv teamCsv = new TeamCsv(team, user);
        return teamCsv.importCsv(csv, dryRun);
    }

    private List<EntityReference> getInheritedRoles(Team team) {
        return SubjectContext.getRolesForTeams(this.getParentsForInheritedRoles(team));
    }

    private TeamHierarchy getTeamHierarchy(Team team) {
        return new TeamHierarchy().withId(team.getId()).withTeamType(team.getTeamType()).withName(team.getName()).withDisplayName(team.getDisplayName()).withHref(team.getHref()).withFullyQualifiedName(team.getFullyQualifiedName()).withIsJoinable(team.getIsJoinable()).withChildren(null).withDescription(team.getDescription());
    }

    private TeamHierarchy deepCopy(TeamHierarchy team) {
        TeamHierarchy newTeam = new TeamHierarchy().withId(team.getId()).withTeamType(team.getTeamType()).withName(team.getName()).withDisplayName(team.getDisplayName()).withHref(team.getHref()).withFullyQualifiedName(team.getFullyQualifiedName()).withIsJoinable(team.getIsJoinable());
        if (team.getChildren() != null) {
            ArrayList<TeamHierarchy> children = new ArrayList<TeamHierarchy>();
            for (TeamHierarchy n : team.getChildren()) {
                children.add(this.deepCopy(n));
            }
            newTeam.withChildren(children);
        }
        return newTeam;
    }

    private TeamHierarchy mergeTrees(TeamHierarchy team1, TeamHierarchy team2) {
        List team1Children = team1.getChildren();
        List team2Children = team2.getChildren();
        if (team1Children != null && team2Children != null) {
            ArrayList toMerge = new ArrayList(team1Children);
            toMerge.retainAll(team2Children);
            for (TeamHierarchy n : toMerge) {
                this.mergeTrees(n, (TeamHierarchy)team2Children.get(team2Children.indexOf(n)));
            }
        }
        if (team2Children != null) {
            ArrayList toAdd = new ArrayList(team2Children);
            if (team1Children != null) {
                toAdd.removeAll(team1Children);
            } else {
                team1.setChildren(new ArrayList());
            }
            for (TeamHierarchy n : toAdd) {
                team1.getChildren().add(this.deepCopy(n));
            }
        }
        return team1;
    }

    public List<TeamHierarchy> listHierarchy(ListFilter filter, int limit, Boolean isJoinable) {
        EntityUtil.Fields fields = this.getFields(PARENTS_FIELD);
        HashMap map = new HashMap();
        ResultList resultList = this.listAfter(null, fields, filter, limit, null);
        List allTeams = resultList.getData();
        List<Team> joinableTeams = allTeams.stream().filter(Boolean.TRUE.equals(isJoinable) ? Team::getIsJoinable : t -> true).filter(t -> !t.getName().equals("Organization")).toList();
        joinableTeams.forEach(team -> {
            Team currentTeam = team;
            TeamHierarchy currentHierarchy = this.getTeamHierarchy((Team)team);
            while (currentTeam != null && !currentTeam.getParents().isEmpty() && !((EntityReference)currentTeam.getParents().get(0)).getName().equals("Organization")) {
                EntityReference parentRef = (EntityReference)currentTeam.getParents().get(0);
                Team parent = allTeams.stream().filter(t -> t.getId().equals(parentRef.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unexpected error occurred while building the teams hierarchy"));
                currentHierarchy = this.getTeamHierarchy(parent).withChildren(new ArrayList<TeamHierarchy>(List.of(currentHierarchy)));
                if (map.containsKey(parent.getId())) {
                    TeamHierarchy parentTeam = (TeamHierarchy)map.get(parent.getId());
                    currentHierarchy = this.mergeTrees(parentTeam, currentHierarchy);
                    currentTeam = allTeams.stream().filter(t -> t.getId().equals(parent.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unexpected error occurred while building the teams hierarchy"));
                    continue;
                }
                currentTeam = parent;
            }
            UUID currentId = currentHierarchy.getId();
            if (!map.containsKey(currentId)) {
                map.put(currentId, currentHierarchy);
            } else {
                map.put(currentId, this.mergeTrees((TeamHierarchy)map.get(currentId), currentHierarchy));
            }
        });
        return new ArrayList<TeamHierarchy>(map.values());
    }

    private List<EntityReference> getUsers(Team team) {
        return this.findTo(team.getId(), "team", Relationship.HAS, "user");
    }

    private List<CollectionDAO.EntityRelationshipRecord> getUsersRelationshipRecords(UUID teamId) {
        List<CollectionDAO.EntityRelationshipRecord> userRecord = this.findToRecords(teamId, "team", Relationship.HAS, "user");
        List<EntityReference> children = this.getChildren(teamId);
        for (EntityReference child : children) {
            userRecord.addAll(this.getUsersRelationshipRecords(child.getId()));
        }
        return userRecord;
    }

    private Integer getUserCount(UUID teamId) {
        ArrayList<String> userIds = new ArrayList<String>();
        List<CollectionDAO.EntityRelationshipRecord> userRecordList = this.getUsersRelationshipRecords(teamId);
        for (CollectionDAO.EntityRelationshipRecord userRecord : userRecordList) {
            userIds.add(userRecord.getId().toString());
        }
        HashSet userIdsSet = new HashSet(userIds);
        userIds.clear();
        userIds.addAll(userIdsSet);
        return userIds.size();
    }

    private List<EntityReference> getOwns(Team team) {
        return this.findTo(team.getId(), "team", Relationship.OWNS, null);
    }

    private List<EntityReference> getDefaultRoles(Team team) {
        return this.findTo(team.getId(), "team", Relationship.HAS, "role");
    }

    private List<EntityReference> getParents(Team team) {
        List<EntityReference> parents = this.findFrom(team.getId(), "team", Relationship.PARENT_OF, "team");
        if (this.organization != null && CommonUtil.listOrEmpty(parents).isEmpty() && !team.getId().equals(this.organization.getId())) {
            return new ArrayList<EntityReference>(List.of(this.organization.getEntityReference()));
        }
        return parents;
    }

    private List<EntityReference> getParentsForInheritedRoles(Team team) {
        List<EntityReference> parents = this.findFrom(team.getId(), "team", Relationship.PARENT_OF, "team").stream().filter(e -> e.getDeleted() == false).collect(Collectors.toList());
        if (this.organization != null && CommonUtil.listOrEmpty(parents).isEmpty() && !team.getId().equals(this.organization.getId())) {
            return new ArrayList<EntityReference>(List.of(this.organization.getEntityReference()));
        }
        return parents;
    }

    @Override
    protected List<EntityReference> getChildren(Team team) {
        return this.getChildren(team.getId());
    }

    @Override
    protected List<EntityReference> getChildren(UUID teamId) {
        if (teamId.equals(this.organization.getId())) {
            List<String> children = this.daoCollection.teamDAO().listTeamsUnderOrganization(teamId);
            return EntityUtil.populateEntityReferencesById(EntityUtil.strToIds(children), "team");
        }
        return this.findTo(teamId, "team", Relationship.PARENT_OF, "team");
    }

    private Integer getChildrenCount(Team team) {
        return !CommonUtil.nullOrEmpty((List)team.getChildren()) ? team.getChildren().size() : this.getChildren(team).size();
    }

    private List<EntityReference> getPolicies(Team team) {
        return this.findTo(team.getId(), "team", Relationship.HAS, "policy");
    }

    private void populateChildren(Team team) {
        List childrenRefs = team.getChildren();
        if (childrenRefs == null) {
            return;
        }
        List<Team> children = this.getTeams(childrenRefs);
        switch (team.getTeamType()) {
            case GROUP: {
                if (children.isEmpty()) break;
                throw new IllegalArgumentException("Team of type Group can't have children of type team. Only users are allowed as part of the team");
            }
            case DEPARTMENT: {
                this.validateChildren(team, children, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.GROUP);
                break;
            }
            case DIVISION: {
                this.validateChildren(team, children, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.GROUP);
                break;
            }
            case BUSINESS_UNIT: 
            case ORGANIZATION: {
                this.validateChildren(team, children, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.GROUP);
            }
        }
        this.populateTeamRefs(childrenRefs, children);
    }

    private void populateParents(Team team) {
        List parentRefs = CommonUtil.listOrEmpty((List)team.getParents());
        if (parentRefs.isEmpty() && !team.getName().equals("Organization")) {
            team.setParents(new ArrayList());
            team.getParents().add(this.organization.getEntityReference());
            return;
        }
        List<Team> parents = this.getTeams(parentRefs);
        switch (team.getTeamType()) {
            case GROUP: 
            case DEPARTMENT: {
                this.validateParents(team, parents, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case DIVISION: {
                this.validateSingleParent(team, parentRefs);
                this.validateParents(team, parents, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case BUSINESS_UNIT: {
                this.validateSingleParent(team, parentRefs);
                this.validateParents(team, parents, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case ORGANIZATION: {
                if (parentRefs.isEmpty()) break;
                throw new IllegalArgumentException("Team of type Organization can't have a parent team");
            }
        }
        this.populateTeamRefs(parentRefs, parents);
    }

    private void populateTeamRefs(List<EntityReference> teamRefs, List<Team> teams) {
        for (int i = 0; i < teams.size(); ++i) {
            EntityUtil.copy(teams.get(i).getEntityReference(), teamRefs.get(i));
        }
    }

    private List<Team> getTeams(List<EntityReference> teamRefs) {
        ArrayList<Team> teams = new ArrayList<Team>();
        for (EntityReference teamRef : teamRefs) {
            try {
                Team team = (Team)this.find(teamRef.getId(), Include.NON_DELETED);
                teams.add(team);
            }
            catch (EntityNotFoundException ex) {
                LOG.debug("Failed to populate team since it might be soft deleted.", (Throwable)((Object)ex));
                this.find(teamRef.getId(), Include.DELETED);
            }
        }
        return teams;
    }

    private void validateParents(Team team, List<Team> relatedTeams, CreateTeam.TeamType ... allowedTeamTypes) {
        List<CreateTeam.TeamType> allowed = Arrays.asList(allowedTeamTypes);
        for (Team relatedTeam : relatedTeams) {
            if (allowed.contains(relatedTeam.getTeamType())) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidParent(relatedTeam, team.getName(), team.getTeamType()));
        }
    }

    private void validateChildren(Team team, List<Team> children, CreateTeam.TeamType ... allowedTeamTypes) {
        List<CreateTeam.TeamType> allowed = Arrays.asList(allowedTeamTypes);
        for (Team child : children) {
            if (allowed.contains(child.getTeamType())) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidChild(team.getName(), team.getTeamType(), child));
        }
    }

    private void validateSingleParent(Team team, List<EntityReference> parentRefs) {
        if (CommonUtil.listOrEmpty(parentRefs).size() != 1) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidParentCount(1, team.getTeamType()));
        }
    }

    public void initOrganization() {
        this.organization = (Team)this.findByNameOrNull("Organization", Include.ALL);
        if (this.organization == null) {
            LOG.debug("Organization {} is not initialized", (Object)"Organization");
            try {
                EntityReference organizationPolicy = Entity.getEntityReferenceByName("policy", "OrganizationPolicy", Include.ALL);
                EntityReference dataConsumerRole = Entity.getEntityReferenceByName("role", "DataConsumer", Include.ALL);
                Team team = new Team().withId(UUID.randomUUID()).withName("Organization").withDisplayName("Organization").withDescription("Organization under which all the other team hierarchy is created").withTeamType(CreateTeam.TeamType.ORGANIZATION).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withPolicies(new ArrayList<EntityReference>(List.of(organizationPolicy))).withDefaultRoles(new ArrayList<EntityReference>(List.of(dataConsumerRole)));
                this.organization = this.create(null, team);
                LOG.info("Organization {}:{} is successfully initialized", (Object)"Organization", (Object)this.organization.getId());
            }
            catch (Exception e) {
                LOG.error("Failed to initialize organization", (Throwable)e);
                throw e;
            }
        } else {
            LOG.info("Organization is already initialized");
        }
    }

    public class TeamUpdater
    extends EntityRepository.EntityUpdater {
        public TeamUpdater(Team original, Team updated, EntityRepository.Operation operation) {
            super((EntityRepository)TeamRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            if (((Team)this.original).getTeamType() != ((Team)this.updated).getTeamType()) {
                if (CreateTeam.TeamType.GROUP.equals((Object)((Team)this.original).getTeamType())) {
                    throw new IllegalArgumentException("Team of type Group cannot be updated");
                }
                if (!((Team)this.original).getChildren().isEmpty() && CreateTeam.TeamType.GROUP.equals((Object)((Team)this.updated).getTeamType())) {
                    throw new IllegalArgumentException("A team with children cannot be updated to type Group");
                }
            }
            this.recordChange("profile", ((Team)this.original).getProfile(), ((Team)this.updated).getProfile(), true);
            this.recordChange("isJoinable", ((Team)this.original).getIsJoinable(), ((Team)this.updated).getIsJoinable());
            this.recordChange("teamType", ((Team)this.original).getTeamType(), ((Team)this.updated).getTeamType());
            if (CommonUtil.nullOrEmpty((String)((Team)this.updated).getEmail())) {
                ((Team)this.updated).setEmail(null);
            }
            this.recordChange("email", ((Team)this.original).getEmail(), ((Team)this.updated).getEmail());
            this.updateUsers((Team)this.original, (Team)this.updated);
            this.updateDefaultRoles((Team)this.original, (Team)this.updated);
            this.updateParents((Team)this.original, (Team)this.updated);
            this.updateChildren((Team)this.original, (Team)this.updated);
            this.updatePolicies((Team)this.original, (Team)this.updated);
        }

        private void updateUsers(Team origTeam, Team updatedTeam) {
            List origUsers = CommonUtil.listOrEmpty((List)origTeam.getUsers());
            List updatedUsers = CommonUtil.listOrEmpty((List)updatedTeam.getUsers());
            this.updateToRelationships("users", "team", origTeam.getId(), Relationship.HAS, "user", origUsers, updatedUsers, false);
        }

        private void updateDefaultRoles(Team origTeam, Team updatedTeam) {
            List origDefaultRoles = CommonUtil.listOrEmpty((List)origTeam.getDefaultRoles());
            List updatedDefaultRoles = CommonUtil.listOrEmpty((List)updatedTeam.getDefaultRoles());
            this.updateToRelationships(TeamRepository.DEFAULT_ROLES, "team", origTeam.getId(), Relationship.HAS, "role", origDefaultRoles, updatedDefaultRoles, false);
        }

        @Override
        protected void updateDomain() {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((List)((Team)this.original).getDomains()) && this.updatedByBot()) {
                ((Team)this.updated).setDomains(((Team)this.original).getDomains());
                return;
            }
            List<EntityReference> origDomains = EntityUtil.populateEntityReferences(CommonUtil.listOrEmptyMutable((List)((Team)this.original).getDomains()));
            List<EntityReference> updatedDomains = EntityUtil.populateEntityReferences(CommonUtil.listOrEmptyMutable((List)((Team)this.updated).getDomains()));
            TeamRepository.this.deleteTo(((Team)this.original).getId(), "team", Relationship.HAS, "domain");
            for (EntityReference domain : updatedDomains) {
                TeamRepository.this.addRelationship(domain.getId(), ((Team)this.original).getId(), "domain", "team", Relationship.HAS);
            }
            origDomains.sort(EntityUtil.compareEntityReference);
            updatedDomains.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("domains", origDomains, updatedDomains, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updateParents(Team original, Team updated) {
            List origParents = CommonUtil.listOrEmpty((List)original.getParents());
            List updatedParents = CommonUtil.listOrEmpty((List)updated.getParents());
            this.updateFromRelationships(TeamRepository.PARENTS_FIELD, "team", origParents, updatedParents, Relationship.PARENT_OF, "team", original.getId());
        }

        private void updateChildren(Team original, Team updated) {
            List origParents = CommonUtil.listOrEmpty((List)original.getChildren());
            List updatedParents = CommonUtil.listOrEmpty((List)updated.getChildren());
            this.updateToRelationships("children", "team", original.getId(), Relationship.PARENT_OF, "team", origParents, updatedParents, false);
        }

        private void updatePolicies(Team original, Team updated) {
            List origPolicies = CommonUtil.listOrEmpty((List)original.getPolicies());
            List updatedPolicies = CommonUtil.listOrEmpty((List)updated.getPolicies());
            this.updateToRelationships("policies", "team", original.getId(), Relationship.HAS, "policy", origPolicies, updatedPolicies, false);
        }
    }

    public static class TeamCsv
    extends EntityCsv<Team> {
        public static final CsvDocumentation DOCUMENTATION = TeamCsv.getCsvDocumentation("team");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final Team team;

        TeamCsv(Team team, String updatedBy) {
            super("team", HEADERS, updatedBy);
            this.team = team;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            Team team = new Team().withName(csvRecord.get(0)).withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withTeamType(CreateTeam.TeamType.fromValue((String)csvRecord.get(3))).withOwners(this.getOwners(printer, csvRecord, 5)).withIsJoinable(this.getBoolean(printer, csvRecord, 6)).withDefaultRoles(this.getEntityReferences(printer, csvRecord, 7, "role")).withPolicies(this.getEntityReferences(printer, csvRecord, 8, "policy"));
            this.getParents(printer, csvRecord, team);
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, team);
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, Team entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addField(recordList, entity.getTeamType().value());
            CsvUtil.addEntityReferences(recordList, entity.getParents());
            CsvUtil.addOwners(recordList, entity.getOwners());
            CsvUtil.addField(recordList, entity.getIsJoinable());
            CsvUtil.addEntityReferences(recordList, entity.getDefaultRoles());
            CsvUtil.addEntityReferences(recordList, entity.getPolicies());
            this.addRecord(csvFile, (List<String>)recordList);
        }

        private void getParents(CSVPrinter printer, CSVRecord csvRecord, Team importedTeam) throws IOException {
            if (!this.processRecord) {
                return;
            }
            List<EntityReference> parentRefs = this.getEntityReferences(printer, csvRecord, 4, "team");
            for (EntityReference parentRef : CommonUtil.listOrEmpty(parentRefs)) {
                if (parentRef.getName().equals(this.team.getName()) || this.dryRunCreatedEntities.get(parentRef.getName()) != null || SubjectContext.isInTeam(this.team.getName(), parentRef)) continue;
                this.importFailure(printer, TeamCsv.invalidTeam(4, this.team.getName(), importedTeam.getName(), parentRef.getName()), csvRecord);
                this.processRecord = false;
            }
            importedTeam.setParents(parentRefs);
        }

        public static String invalidTeam(int field, String team, String importedTeam, String parentName) {
            String error = String.format("Parent %s of imported team %s is not under %s team hierarchy", parentName, importedTeam, team);
            return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
        }

        private List<Team> listTeams(TeamRepository repository, String parentTeam, List<Team> teams, EntityUtil.Fields fields) {
            ListFilter filter = (ListFilter)new ListFilter(Include.NON_DELETED).addQueryParam("parentTeam", parentTeam);
            List list = repository.listAll(fields, filter);
            if (CommonUtil.nullOrEmpty(list)) {
                return teams;
            }
            teams.addAll(list);
            for (Team teamEntry : list) {
                this.listTeams(repository, teamEntry.getName(), teams, fields);
            }
            return teams;
        }

        public String exportCsv() throws IOException {
            TeamRepository repository = (TeamRepository)Entity.getEntityRepository("team");
            EntityUtil.Fields fields = repository.getFields("owners,defaultRoles,parents,policies");
            return this.exportCsv(this.listTeams(repository, this.team.getName(), new ArrayList<Team>(), fields));
        }
    }
}

