/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;
import org.openmetadata.schema.system.EntityError;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class WebAnalyticEventRepository
extends EntityRepository<WebAnalyticEvent> {
    public static final String COLLECTION_PATH = "/v1/analytics/web/events";
    private static final String WEB_ANALYTICS_EVENT_DATA_EXTENSION = "webAnalyticEvent.webAnalyticEventData";

    public WebAnalyticEventRepository() {
        super(COLLECTION_PATH, "webAnalyticEvent", WebAnalyticEvent.class, Entity.getCollectionDAO().webAnalyticEventDAO(), "", "");
    }

    @Override
    public void setFields(WebAnalyticEvent entity, EntityUtil.Fields fields) {
    }

    @Override
    public void clearFields(WebAnalyticEvent entity, EntityUtil.Fields fields) {
    }

    @Override
    public void prepare(WebAnalyticEvent entity, boolean update) {
    }

    @Override
    public void storeEntity(WebAnalyticEvent entity, boolean update) {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(WebAnalyticEvent entity) {
    }

    public Response addWebAnalyticEventData(WebAnalyticEventData webAnalyticEventData) {
        webAnalyticEventData.setEventId(UUID.randomUUID());
        this.storeTimeSeries(webAnalyticEventData.getEventType().value(), WEB_ANALYTICS_EVENT_DATA_EXTENSION, "webAnalyticEventData", JsonUtils.pojoToJson(webAnalyticEventData));
        return Response.ok((Object)webAnalyticEventData).build();
    }

    public void deleteWebAnalyticEventData(WebAnalyticEventType name, Long timestamp) {
        this.deleteExtensionBeforeTimestamp(name.value(), WEB_ANALYTICS_EVENT_DATA_EXTENSION, timestamp);
    }

    public ResultList<WebAnalyticEventData> getWebAnalyticEventData(String eventType, Long startTs, Long endTs) {
        List<WebAnalyticEventData> webAnalyticEventData = JsonUtils.readObjects(this.getResultsFromAndToTimestamps(eventType, WEB_ANALYTICS_EVENT_DATA_EXTENSION, startTs, endTs), WebAnalyticEventData.class);
        return new ResultList<WebAnalyticEventData>(webAnalyticEventData, String.valueOf(startTs), String.valueOf(endTs), webAnalyticEventData.size());
    }

    public int listWebAnalyticEventDataCount(String eventType, Long startTs, Long endTs, boolean latest) {
        CollectionDAO.EntityExtensionTimeSeriesDAO timeSeriesDao = this.daoCollection.entityExtensionTimeSeriesDao();
        ListFilter filter = new ListFilter(null);
        filter.addQueryParam("entityFQNHash", FullyQualifiedName.buildHash(eventType));
        return timeSeriesDao.listCount(filter, startTs, endTs, latest);
    }

    public ResultList<WebAnalyticEventData> listWebAnalyticEventDataWithOffset(String offset, String eventType, int limitParam, Long startTs, Long endTs, boolean latest, boolean skipErrors) {
        CollectionDAO.EntityExtensionTimeSeriesDAO timeSeriesDao = this.daoCollection.entityExtensionTimeSeriesDao();
        ListFilter filter = new ListFilter(null);
        filter.addQueryParam("entityFQNHash", FullyQualifiedName.buildHash(eventType));
        int total = timeSeriesDao.listCount(filter, startTs, endTs, latest);
        List<Object> webAnalyticEventData = new ArrayList<WebAnalyticEventData>();
        List<EntityError> errors = null;
        int offsetInt = this.getOffset(offset);
        String afterOffset = this.getAfterOffset(offsetInt, limitParam, total);
        String beforeOffset = this.getBeforeOffset(offsetInt, limitParam);
        if (limitParam > 0) {
            List<String> jsons = timeSeriesDao.listWithOffset(filter, limitParam, offsetInt, startTs, endTs, latest);
            Map<String, List<?>> entityListMap = this.getEntityList(jsons, skipErrors);
            webAnalyticEventData = entityListMap.get("entityList");
            if (skipErrors) {
                errors = entityListMap.get("errors");
            }
            return this.getWebAnalyticEventDataResultList(webAnalyticEventData, beforeOffset, afterOffset, total, errors);
        }
        return this.getWebAnalyticEventDataResultList(webAnalyticEventData, null, null, total);
    }

    private ResultList<WebAnalyticEventData> getWebAnalyticEventDataResultList(List<WebAnalyticEventData> entities, String beforeCursor, String afterCursor, int total, List<EntityError> errors) {
        if (errors == null) {
            return new ResultList<WebAnalyticEventData>(entities, beforeCursor, afterCursor, total);
        }
        return new ResultList<WebAnalyticEventData>(entities, errors, beforeCursor, afterCursor, total);
    }

    private ResultList<WebAnalyticEventData> getWebAnalyticEventDataResultList(List<WebAnalyticEventData> entities, String beforeCursor, String afterCursor, int total) {
        return this.getWebAnalyticEventDataResultList(entities, beforeCursor, afterCursor, total, null);
    }

    private String getAfterOffset(int offsetInt, int limit, int total) {
        int afterOffset = offsetInt + limit;
        return afterOffset >= total ? null : String.valueOf(afterOffset);
    }

    private String getBeforeOffset(int offsetInt, int limit) {
        int beforeOffsetInt = offsetInt - limit;
        if (beforeOffsetInt < 0) {
            beforeOffsetInt = 0;
        }
        return offsetInt == 0 ? null : String.valueOf(beforeOffsetInt);
    }

    private int getOffset(String offset) {
        return offset != null ? Integer.parseInt(RestUtil.decodeCursor(offset)) : 0;
    }

    private Map<String, List<?>> getEntityList(List<String> jsons, boolean skipErrors) {
        ArrayList<WebAnalyticEventData> entityList = new ArrayList<WebAnalyticEventData>();
        ArrayList<EntityError> errors = new ArrayList<EntityError>();
        HashMap resultList = new HashMap();
        for (String json : jsons) {
            try {
                WebAnalyticEventData recordEntity = JsonUtils.readValue(json, WebAnalyticEventData.class);
                entityList.add(recordEntity);
            }
            catch (Exception e) {
                if (!skipErrors) {
                    throw e;
                }
                errors.add(new EntityError().withMessage(e.getMessage()));
            }
        }
        resultList.put("entityList", entityList);
        resultList.put("errors", errors);
        return resultList;
    }
}

