/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.migration.QueryStatus;
import org.openmetadata.service.migration.api.MigrationProcess;
import org.openmetadata.service.migration.context.MigrationContext;
import org.openmetadata.service.migration.context.MigrationOps;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationProcessImpl
implements MigrationProcess {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationProcessImpl.class);
    protected MigrationDAO migrationDAO;
    protected CollectionDAO collectionDAO;
    protected Handle handle;
    protected PipelineServiceClientInterface pipelineServiceClient;
    private final MigrationFile migrationFile;
    public MigrationContext context;

    public MigrationProcessImpl(MigrationFile migrationFile) {
        this.migrationFile = migrationFile;
    }

    @Override
    public void initialize(Handle handle) {
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
        this.migrationDAO = (MigrationDAO)handle.attach(MigrationDAO.class);
        this.pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(this.migrationFile.pipelineServiceClientConfiguration);
    }

    @Override
    public List<MigrationOps> getMigrationOps() {
        return List.of();
    }

    @Override
    public String getDatabaseConnectionType() {
        return this.migrationFile.connectionType.label;
    }

    @Override
    public String getVersion() {
        return this.migrationFile.version;
    }

    @Override
    public String getMigrationsPath() {
        return this.migrationFile.getMigrationsFilePath();
    }

    @Override
    public String getSchemaChangesFilePath() {
        return this.migrationFile.getSchemaChangesFile();
    }

    @Override
    public String getPostDDLScriptFilePath() {
        return this.migrationFile.getPostDDLScriptFile();
    }

    @Override
    public Map<String, QueryStatus> runSchemaChanges(boolean isForceMigration) {
        return MigrationProcessImpl.performSqlExecutionAndUpdate(this.handle, this.migrationDAO, this.migrationFile.getSchemaChanges(), this.migrationFile.version, isForceMigration);
    }

    public static Map<String, QueryStatus> performSqlExecutionAndUpdate(Handle handle, MigrationDAO migrationDAO, List<String> queryList, String version, boolean isForceMigration) {
        HashMap<String, QueryStatus> queryStatusMap = new HashMap<String, QueryStatus>();
        if (!CommonUtil.nullOrEmpty(queryList)) {
            for (String sql : queryList) {
                try {
                    String previouslyRanSql = migrationDAO.getSqlQuery(EntityUtil.hash(sql), version);
                    if (previouslyRanSql == null || previouslyRanSql.isEmpty()) {
                        handle.execute(sql, new Object[0]);
                        migrationDAO.upsertServerMigrationSQL(version, sql, EntityUtil.hash(sql));
                    }
                    queryStatusMap.put(sql, new QueryStatus(QueryStatus.Status.SUCCESS, "Successfully Executed Query"));
                }
                catch (Exception e) {
                    String message = String.format("Failed to run sql: [%s] due to [%s]", sql, e);
                    queryStatusMap.put(sql, new QueryStatus(QueryStatus.Status.FAILURE, message));
                    if (isForceMigration) continue;
                    throw new RuntimeException(message, e);
                }
            }
        }
        return queryStatusMap;
    }

    @Override
    public void runDataMigration() {
    }

    @Override
    public Map<String, QueryStatus> runPostDDLScripts(boolean isForceMigration) {
        return MigrationProcessImpl.performSqlExecutionAndUpdate(this.handle, this.migrationDAO, this.migrationFile.getPostDDLScripts(), this.migrationFile.version, isForceMigration);
    }

    @Override
    public void close() {
        if (this.handle != null) {
            this.handle.close();
        }
    }

    public MigrationContext getContext() {
        return this.context;
    }
}

