/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.context;

import javax.validation.constraints.NotEmpty;
import org.jdbi.v3.core.Handle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationOps {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationOps.class);
    @NotEmpty
    private final String name;
    @NotEmpty
    private final String query;
    private Long result;

    public MigrationOps(String name, String query) {
        this.name = name;
        this.query = query;
    }

    public void compute(Handle handle) {
        try {
            this.result = (Long)handle.createQuery(this.query).mapTo(Long.class).one();
        }
        catch (Exception ex) {
            LOG.warn(String.format("Migration Op [%s] failed due to [%s]", this.name, ex));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public Long getResult() {
        return this.result;
    }

    public void setResult(Long result) {
        this.result = result;
    }
}

