/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v141;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final long MAX_SECONDS_TIMESTAMP = Integer.MAX_VALUE;

    public static void migrateAnnouncementsTimeFormat(Handle handle, boolean postgresDbFlag) {
        List<Thread> threads = MigrationUtil.fetchAnnouncementThreads(handle);
        threads.forEach(thread -> {
            Optional<AnnouncementDetails> announcementOpt = Optional.ofNullable(thread.getAnnouncement());
            boolean updated = announcementOpt.map(announcement -> {
                boolean startUpdated = Optional.ofNullable(announcement.getStartTime()).filter(MigrationUtil::isInSeconds).map(MigrationUtil::convertSecondsToMilliseconds).map(startTime -> {
                    announcement.setStartTime(startTime);
                    return true;
                }).orElse(false);
                boolean endUpdated = Optional.ofNullable(announcement.getEndTime()).filter(MigrationUtil::isInSeconds).map(MigrationUtil::convertSecondsToMilliseconds).map(endTime -> {
                    announcement.setEndTime(endTime);
                    return true;
                }).orElse(false);
                return startUpdated || endUpdated;
            }).orElse(false);
            if (updated) {
                if (postgresDbFlag) {
                    MigrationUtil.updateThreadPostgres(handle, thread);
                } else {
                    MigrationUtil.updateThreadMySql(handle, thread);
                }
            }
        });
    }

    private static List<Thread> fetchAnnouncementThreads(Handle handle) {
        String query = "SELECT json FROM thread_entity WHERE type = 'Announcement'";
        return handle.createQuery(query).map((rs, ctx) -> JsonUtils.readValue(rs.getString("json"), Thread.class)).list();
    }

    private static boolean isInSeconds(Long timestamp) {
        return timestamp != null && timestamp <= Integer.MAX_VALUE;
    }

    private static void updateThreadMySql(Handle handle, Thread thread) {
        String updateQuery = "UPDATE thread_entity SET json = :json WHERE id = :id";
        ((Update)((Update)handle.createUpdate(updateQuery).bind("json", JsonUtils.pojoToJson(thread))).bind("id", thread.getId().toString())).execute();
    }

    private static void updateThreadPostgres(Handle handle, Thread thread) {
        String updateQuery = "UPDATE thread_entity SET json = CAST(:json AS jsonb) WHERE id = :id";
        ((Update)((Update)handle.createUpdate(updateQuery).bind("json", JsonUtils.pojoToJson(thread))).bind("id", thread.getId().toString())).execute();
    }

    private static long convertSecondsToMilliseconds(long seconds) {
        return LocalDateTime.ofEpochSecond(seconds, 0, ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

