/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v150;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jdbi.v3.core.Handle;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.LineChart;
import org.openmetadata.schema.dataInsight.custom.SummaryCard;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.type.DataQualityDimensions;
import org.openmetadata.schema.type.Include;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.AppMarketPlaceRepository;
import org.openmetadata.service.jdbi3.AppRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataInsightSystemChartRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final String QUERY_AUTOMATOR = "SELECT json FROM ingestion_pipeline_entity where appType = 'Automator'";
    private static final String ADD_OWNER_ACTION = "AddOwnerAction";
    private static final String OWNER_KEY = "owner";
    static DataInsightSystemChartRepository dataInsightSystemChartRepository;

    public static void migrateAutomatorOwner(Handle handle, CollectionDAO collectionDAO) {
        try {
            handle.createQuery(QUERY_AUTOMATOR).mapToMap().forEach(row -> {
                try {
                    JsonObject json = JsonUtils.readJson(row.get("json").toString()).asJsonObject();
                    JsonObject sourceConfig = json.getJsonObject("sourceConfig");
                    JsonObject config = sourceConfig.getJsonObject("config");
                    JsonObject appConfig = config.getJsonObject("appConfig");
                    JsonArray actions = appConfig.getJsonArray("actions");
                    JsonArrayBuilder updatedActions = Json.createArrayBuilder();
                    actions.forEach(action -> {
                        JsonObject actionObj = (JsonObject)action;
                        if (ADD_OWNER_ACTION.equals(actionObj.getString("type")) && actionObj.containsKey((Object)OWNER_KEY)) {
                            JsonObject owner = actionObj.getJsonObject(OWNER_KEY);
                            JsonArrayBuilder owners = Json.createArrayBuilder();
                            owners.add((JsonValue)owner);
                            actionObj = Json.createObjectBuilder((JsonObject)actionObj).add("owners", owners).remove(OWNER_KEY).build();
                        }
                        updatedActions.add((JsonValue)actionObj);
                    });
                    JsonObjectBuilder updatedAppConfig = Json.createObjectBuilder((JsonObject)appConfig).add("actions", updatedActions);
                    JsonObjectBuilder updatedConfig = Json.createObjectBuilder((JsonObject)config).add("appConfig", updatedAppConfig);
                    JsonObjectBuilder updatedSourceConfig = Json.createObjectBuilder((JsonObject)sourceConfig).add("config", updatedConfig);
                    JsonObject finalJsonObject = Json.createObjectBuilder((JsonObject)json).add("sourceConfig", updatedSourceConfig).build();
                    IngestionPipeline ingestionPipeline = JsonUtils.readValue(finalJsonObject.toString(), IngestionPipeline.class);
                    collectionDAO.ingestionPipelineDAO().update((EntityInterface)ingestionPipeline);
                }
                catch (Exception ex) {
                    LOG.warn(String.format("Error updating automator [%s] due to [%s]", row, ex));
                }
            });
        }
        catch (Exception ex) {
            LOG.warn("Error running the automator migration ", (Throwable)ex);
        }
    }

    public static void deleteLegacyDataInsightPipelines(PipelineServiceClientInterface pipelineServiceClient) {
        String dataInsightsPipelineNameFqn = "OpenMetadata.OpenMetadata_dataInsight";
        Optional<Object> oDataInsightsPipeline = Optional.empty();
        try {
            oDataInsightsPipeline = Optional.ofNullable((IngestionPipeline)Entity.getEntityByName("ingestionPipeline", dataInsightsPipelineNameFqn, "*", Include.NON_DELETED));
        }
        catch (EntityNotFoundException ex) {
            LOG.debug("DataInsights Pipeline not found.");
        }
        if (oDataInsightsPipeline.isPresent()) {
            IngestionPipeline dataInsightsPipeline = (IngestionPipeline)oDataInsightsPipeline.get();
            IngestionPipelineRepository entityRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            entityRepository.setPipelineServiceClient(pipelineServiceClient);
            entityRepository.delete("admin", dataInsightsPipeline.getId(), true, true);
        }
    }

    public static void updateDataInsightsApplication() {
        AppRepository appRepository = (AppRepository)Entity.getEntityRepository("app");
        try {
            appRepository.deleteByName("admin", "DataInsightsApplication", true, true);
        }
        catch (EntityNotFoundException ex) {
            LOG.debug("DataInsights Application not found.");
        }
        AppMarketPlaceRepository marketPlaceRepository = (AppMarketPlaceRepository)Entity.getEntityRepository("appMarketPlaceDefinition");
        try {
            marketPlaceRepository.deleteByName("admin", "DataInsightsApplication", true, true);
        }
        catch (EntityNotFoundException ex) {
            LOG.debug("DataInsights Application Marketplace Definition not found.");
        }
    }

    public static void migratePolicies(Handle handle, CollectionDAO collectionDAO) {
        String DB_POLICY_QUERY = "SELECT json FROM policy_entity";
        try {
            handle.createQuery(DB_POLICY_QUERY).mapToMap().forEach(row -> {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode rootNode = objectMapper.readTree(row.get("json").toString());
                    ArrayNode rulesArray = (ArrayNode)rootNode.path("rules");
                    rulesArray.forEach(ruleNode -> {
                        ArrayNode operationsArray = (ArrayNode)ruleNode.get("operations");
                        for (int i = 0; i < operationsArray.size(); ++i) {
                            if (!"EditOwner".equals(operationsArray.get(i).asText())) continue;
                            operationsArray.set(i, (JsonNode)operationsArray.textNode("EditOwners"));
                        }
                    });
                    String updatedJsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
                    Policy policy = JsonUtils.readValue(updatedJsonString, Policy.class);
                    policy.setUpdatedBy("ingestion-bot");
                    policy.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
                    collectionDAO.policyDAO().update((EntityInterface)policy);
                }
                catch (Exception e) {
                    LOG.warn("Error migrating policies", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error running the policy migration ", (Throwable)e);
        }
    }

    public static void migrateTestCaseDimension(Handle handle, CollectionDAO collectionDAO) {
        String MYSQL_TEST_CASE_DIMENSION_QUERY = "SELECT json FROM test_definition WHERE JSON_CONTAINS(json -> '$.testPlatforms', '\"OpenMetadata\"')";
        String POSTGRES_TEST_CASE_DIMENSION_QUERY = "SELECT json FROM test_definition WHERE json -> 'testPlatforms' @> '\"OpenMetadata\"'";
        Map fqnToDimension = Map.ofEntries(Map.entry("columnValueMaxToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValueMeanToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValueMedianToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValueMinToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValueLengthsToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValuesSumToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValueStdDevToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValuesToBeBetween", DataQualityDimensions.ACCURACY), Map.entry("columnValuesToBeInSet", DataQualityDimensions.VALIDITY), Map.entry("columnValuesToBeNotInSet", DataQualityDimensions.VALIDITY), Map.entry("columnValuesToMatchRegex", DataQualityDimensions.VALIDITY), Map.entry("columnValuesToNotMatchRegex", DataQualityDimensions.VALIDITY), Map.entry("tableColumnCountToBeBetween", DataQualityDimensions.INTEGRITY), Map.entry("tableColumnCountToEqual", DataQualityDimensions.INTEGRITY), Map.entry("tableColumnNameToExist", DataQualityDimensions.INTEGRITY), Map.entry("tableColumnToMatchSet", DataQualityDimensions.INTEGRITY), Map.entry("tableRowCountToBeBetween", DataQualityDimensions.INTEGRITY), Map.entry("tableRowCountToEqual", DataQualityDimensions.INTEGRITY), Map.entry("tableRowInsertedCountToBeBetween", DataQualityDimensions.INTEGRITY), Map.entry("columnValuesToBeUnique", DataQualityDimensions.UNIQUENESS), Map.entry("columnValuesMissingCount", DataQualityDimensions.COMPLETENESS), Map.entry("columnValuesToBeNotNull", DataQualityDimensions.COMPLETENESS), Map.entry("tableCustomSQLQuery", DataQualityDimensions.SQL), Map.entry("tableDiff", DataQualityDimensions.CONSISTENCY));
        try {
            String query = POSTGRES_TEST_CASE_DIMENSION_QUERY;
            if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
                query = MYSQL_TEST_CASE_DIMENSION_QUERY;
            }
            handle.createQuery(query).mapToMap().forEach(row -> {
                try {
                    TestDefinition testCaseDefinition = JsonUtils.readValue(row.get("json").toString(), TestDefinition.class);
                    DataQualityDimensions dimension = (DataQualityDimensions)fqnToDimension.get(testCaseDefinition.getFullyQualifiedName());
                    if (dimension == null) {
                        LOG.warn("No dimension found for test case {}", (Object)testCaseDefinition.getFullyQualifiedName());
                        return;
                    }
                    testCaseDefinition.setDataQualityDimension(dimension);
                    collectionDAO.testDefinitionDAO().update((EntityInterface)testCaseDefinition);
                }
                catch (Exception e) {
                    LOG.warn("Error migrating test case dimension", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Error running the test case resolution migration ", (Throwable)e);
        }
    }

    private static void createChart(String chartName, Object chartObject) {
        DataInsightCustomChart chart = new DataInsightCustomChart().withId(UUID.randomUUID()).withName(chartName).withChartDetails(chartObject).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy("ingestion-bot").withDeleted(Boolean.valueOf(false)).withIsSystemChart(Boolean.valueOf(true));
        dataInsightSystemChartRepository.prepareInternal(chart, false);
        try {
            dataInsightSystemChartRepository.getDao().insert("fqnHash", (EntityInterface)chart, chart.getFullyQualifiedName());
        }
        catch (Exception ex) {
            LOG.warn(ex.toString());
            LOG.warn(String.format("Chart %s exists", chart));
        }
    }

    public static void createSystemDICharts() {
        dataInsightSystemChartRepository = new DataInsightSystemChartRepository();
        String exclude_tags_filter = "{\"query\":{\"bool\":{\"must\":[{\"bool\":{\"must_not\":{\"term\":{\"entityType.keyword\":\"tag\"}}}},{\"bool\":{\"must_not\":{\"term\":{\"entityType.keyword\":\"glossaryTerm\"}}}},{\"bool\":{\"must_not\":{\"term\":{\"entityType.keyword\":\"dataProduct\"}}}}]}}}";
        List<String> excludeList = List.of("tag", "glossaryTerm");
        MigrationUtil.createChart("total_data_assets", new LineChart().withFormula("count(k='id.keyword')").withGroupBy("entityType.keyword").withExcludeGroups(excludeList));
        MigrationUtil.createChart("percentage_of_data_asset_with_description", new LineChart().withFormula("(count(k='id.keyword',q='hasDescription: 1')/count(k='id.keyword'))*100").withGroupBy("entityType.keyword").withExcludeGroups(excludeList));
        MigrationUtil.createChart("percentage_of_data_asset_with_owner", new LineChart().withFormula("(count(k='id.keyword',q='owners.name.keyword: *')/count(k='id.keyword'))*100").withGroupBy("entityType.keyword").withExcludeGroups(excludeList));
        MigrationUtil.createChart("percentage_of_service_with_description", new LineChart().withFormula("(count(k='id.keyword',q='hasDescription: 1')/count(k='id.keyword'))*100").withGroupBy("service.name.keyword"));
        MigrationUtil.createChart("percentage_of_service_with_owner", new LineChart().withFormula("(count(k='id.keyword',q='owners.name.keyword: *')/count(k='id.keyword'))*100").withGroupBy("service.name.keyword"));
        MigrationUtil.createChart("total_data_assets_by_tier", new LineChart().withFormula("count(k='id.keyword')").withGroupBy("tier.keyword"));
        MigrationUtil.createChart("total_data_assets_summary_card", new SummaryCard().withFormula("count(k='id.keyword')").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("data_assets_with_description_summary_card", new SummaryCard().withFormula("(count(k='id.keyword',q='hasDescription: 1')/count(k='id.keyword'))*100").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("data_assets_with_owner_summary_card", new SummaryCard().withFormula("(count(k='id.keyword',q='owners.name.keyword: *')/count(k='id.keyword'))*100").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("total_data_assets_with_tier_summary_card", new SummaryCard().withFormula("(count(k='id.keyword',q='NOT tier.keyword:\"NoTier\"')/count(k='id.keyword'))*100").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("percentage_of_data_asset_with_description_kpi", new LineChart().withFormula("(count(k='id.keyword',q='hasDescription: 1')/count(k='id.keyword'))*100").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("percentage_of_data_asset_with_owner_kpi", new LineChart().withFormula("(count(k='id.keyword',q='owners.name.keyword: *')/count(k='id.keyword'))*100").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("number_of_data_asset_with_description_kpi", new LineChart().withFormula("count(k='id.keyword',q='hasDescription: 1')").withFilter(exclude_tags_filter));
        MigrationUtil.createChart("number_of_data_asset_with_owner_kpi", new LineChart().withFormula("count(k='id.keyword',q='owners.name.keyword: *')").withFilter(exclude_tags_filter));
    }
}

