/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.apis;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateAPICollection;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.APICollection;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.APICollectionRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/apiCollections")
@Tag(name="API Collections", description="A `API Collection` is an optional way of grouping API Endpoints that belong to a API Service.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="apiCollections")
public class APICollectionResource
extends EntityResource<APICollection, APICollectionRepository> {
    public static final String COLLECTION_PATH = "v1/apiCollections/";
    static final String FIELDS = "owners,apiEndpoints,tags,extension,domain,sourceHash";

    @Override
    public APICollection addHref(UriInfo uriInfo, APICollection apiCollection) {
        super.addHref(uriInfo, apiCollection);
        Entity.withHref(uriInfo, apiCollection.getService());
        return apiCollection;
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("apiEndpoints", MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_USAGE});
    }

    public APICollectionResource(Authorizer authorizer, Limits limits) {
        super("apiCollection", authorizer, limits);
    }

    @GET
    @Operation(operationId="listAPICollections", summary="List API Collections", description="Get a list of API Collections, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of API Collections", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollectionList.class))})})
    public ResultList<APICollection> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,apiEndpoints,tags,extension,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter APICollection by service name", schema=@Schema(type="string", example="Users API")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number APICollections returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of API Collections before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of API Collections after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllAPICollectionVersion", summary="List API Collection versions", description="Get a list of all the versions of a API Collection identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of API Collection versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the API Collection", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getAPICollectionByID", summary="Get a API Collection by Id", description="Get a API Collection by `Id`.", responses={@ApiResponse(responseCode="200", description="The API Collection", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollection.class))}), @ApiResponse(responseCode="404", description="APICollection for instance {id} is not found")})
    public APICollection get(@Context UriInfo uriInfo, @Parameter(description="Id of the APICollection", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,apiEndpoints,tags,extension,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (APICollection)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getAPICollectionByFQN", summary="Get a APICollection by fully qualified name", description="Get a APICollection by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The APICollection", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollection.class))}), @ApiResponse(responseCode="404", description="APICollection for instance {fqn} is not found")})
    public APICollection getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the APICollection", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,apiEndpoints,tags,extension,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (APICollection)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAPICollectionVersion", summary="Get a version of the APICollection", description="Get a version of the APICollection by given `Id`", responses={@ApiResponse(responseCode="200", description="database", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollection.class))}), @ApiResponse(responseCode="404", description="APICollection for instance {id} and version {version} is not found")})
    public APICollection getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APICollection", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="APICollection version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (APICollection)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createAPICollection", summary="Create a APICollection", description="Create a APICollection under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The API Collection", content={@Content(mediaType="application/json", schema=@Schema(implementation=Database.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPICollection create) {
        APICollection apiCollection = this.getAPICollection(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, apiCollection);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchAPICollection", summary="Update a API Collection by Id", description="Update an existing API Collection using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the API Collection", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchAPICollection", summary="Update a APICollection by name.", description="Update an existing APICollection using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the API Collection", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateAPICollection", summary="Create or update API Collection", description="Create a API Collection, if it does not exist or update an existing API Collection.", responses={@ApiResponse(responseCode="200", description="The updated API Collection", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollection.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPICollection create) {
        APICollection apiCollection = this.getAPICollection(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, apiCollection);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteAPICollection", summary="Delete a API Collection by Id", description="Delete a API Collection by `Id`. API Collection can only be deleted if it has no tables.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="API Collection for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the database", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForAPICollection", summary="Update Vote for a API Collection", description="Update vote for a API Collection", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="API Collection for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((APICollectionRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteAPICollectionByFQN", summary="Delete a API Collection by fully qualified name", description="Delete a API Collection by `fullyQualifiedName`. API Collection can only be deleted if it has no API Endpoints.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Database for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Fully qualified name of the database", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted API Collection.", description="Restore a soft deleted API Collection.", responses={@ApiResponse(responseCode="200", description="Successfully restored the API Collection. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=APICollection.class))})})
    public Response restoreDatabase(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private APICollection getAPICollection(CreateAPICollection create, String user) {
        return ((APICollectionRepository)this.repository).copy(new APICollection(), (CreateEntity)create, user).withService(this.getEntityReference("apiService", create.getService())).withEndpointURL(create.getEndpointURL()).withApiEndpoints(APICollectionResource.getEntityReferences("apiEndpoint", create.getApiEndpoints())).withSourceHash(create.getSourceHash());
    }

    public static class APICollectionList
    extends ResultList<APICollection> {
    }
}

