/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.apis;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateAPIEndpoint;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.APIEndpoint;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.APIEndpointRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/apiEndpoints")
@Tag(name="API Endpoint", description="A `API Endpoint` is a specific endpoint of an API that is part of an API Collection..")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="apiEndpoints")
public class APIEndpointResource
extends EntityResource<APIEndpoint, APIEndpointRepository> {
    public static final String COLLECTION_PATH = "v1/apiEndpoints/";
    static final String FIELDS = "owners,followers,tags,extension,domain,dataProducts,sourceHash";

    @Override
    public APIEndpoint addHref(UriInfo uriInfo, APIEndpoint apiEndpoint) {
        super.addHref(uriInfo, apiEndpoint);
        Entity.withHref(uriInfo, apiEndpoint.getApiCollection());
        Entity.withHref(uriInfo, apiEndpoint.getService());
        return apiEndpoint;
    }

    public APIEndpointResource(Authorizer authorizer, Limits limits) {
        super("apiEndpoint", authorizer, limits);
    }

    @GET
    @Operation(operationId="listAPIEndpoints", summary="List API Endpoints", description="Get a list of API Endpoints, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of API Endpoints", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpointList.class))})})
    public ResultList<APIEndpoint> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter APIEndpoints by service name", schema=@Schema(type="string", example="OpenMetadata API Service")) @QueryParam(value="service") String serviceParam, @Parameter(description="Filter APIEndpoints by apiCollection name", schema=@Schema(type="string", example="UsersAPI")) @QueryParam(value="apiCollection") String apiCollectionParam, @Parameter(description="Limit the number APIEndpoints returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of APIEndpoints before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of APIEndpoints after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)((ListFilter)new ListFilter(include).addQueryParam("service", serviceParam)).addQueryParam("apiCollection", apiCollectionParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllAPIEndpointVersion", summary="List API Endpoint versions", description="Get a list of all the versions of a APIEndpoint identified by `id`", responses={@ApiResponse(responseCode="200", description="List of APIEndpoint versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getEndpointById", summary="Get a APIEndpoint by id", description="Get a APIEndpoint by `id`.", responses={@ApiResponse(responseCode="200", description="The APIEndpoint", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpoint.class))}), @ApiResponse(responseCode="404", description="APIEndpoint for instance {id} is not found")})
    public APIEndpoint get(@Context UriInfo uriInfo, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (APIEndpoint)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getEndpointByFQN", summary="Get a Endpoint by fully qualified name.", description="Get a Endpoint by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The APIEndpoint", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpoint.class))}), @ApiResponse(responseCode="404", description="Endpoint for instance {fqn} is not found")})
    public APIEndpoint getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the Endpoint", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (APIEndpoint)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificEndpointVersion", summary="Get a version of the APIEndpoint", description="Get a version of the APIEndpoint by given `id`", responses={@ApiResponse(responseCode="200", description="APIEndpoint Version", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpoint.class))}), @ApiResponse(responseCode="404", description="APIEndpoint for instance {id} and version {version} is not found")})
    public APIEndpoint getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="APIEndpoint version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (APIEndpoint)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createAPIEndpoint", summary="Create a API Endpoint", description="Create a API Endpoint under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The API Endpoint", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpoint.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPIEndpoint create) {
        APIEndpoint apiEndpoint = this.getAPIEndpoint(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, apiEndpoint);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchAPIEndpoint", summary="Update a APIEndpoint", description="Update an existing APIEndpoint using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchAPIEndpoint", summary="Update a APIEndpoint using name.", description="Update an existing APIEndpoint using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the topic", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateAPIEndpoint", summary="Update topic", description="Create a API Endpoint, it it does not exist or update an existing API Endpoint.", responses={@ApiResponse(responseCode="200", description="The updated topic ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Topic.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPIEndpoint create) {
        APIEndpoint apiEndpoint = this.getAPIEndpoint(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, apiEndpoint);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollower", summary="Add a follower", description="Add a user identified by `userId` as followed of this APiEndpoint.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="APIEndpoint for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) {
        return ((APIEndpointRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(summary="Remove a follower", description="Remove the user identified `userId` as a follower of the APIEndpoint.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) {
        return ((APIEndpointRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, UUID.fromString(userId)).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForAPIEndpoint", summary="Update Vote for a APIEndpoint", description="Update vote for a APIEndpoint", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((APIEndpointRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteAPIEndpoint", summary="Delete a APIEndpoint by id", description="Delete a APIEndpoint by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="APIEndpoint for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the APIEndpoint", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteAPIEndpointByFQN", summary="Delete a APIEndpoint by fully qualified name", description="Delete a APIEndpoint by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="APIEndpoint for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the APIEndpoint", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted APIEndpoint", description="Restore a soft deleted APIEndpoint.", responses={@ApiResponse(responseCode="200", description="Successfully restored the APIEndpoint. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIEndpoint.class))})})
    public Response restoreTopic(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private APIEndpoint getAPIEndpoint(CreateAPIEndpoint create, String user) {
        return ((APIEndpointRepository)this.repository).copy(new APIEndpoint(), (CreateEntity)create, user).withApiCollection(this.getEntityReference("apiCollection", create.getApiCollection())).withRequestMethod(create.getRequestMethod()).withEndpointURL(create.getEndpointURL()).withRequestSchema(create.getRequestSchema()).withResponseSchema(create.getResponseSchema()).withSourceHash(create.getSourceHash());
    }

    public static class APIEndpointList
    extends ResultList<APIEndpoint> {
    }
}

