/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.automations;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.automations.CreateWorkflow;
import org.openmetadata.schema.entity.automations.TestServiceConnectionRequest;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.automations.WorkflowStatus;
import org.openmetadata.schema.entity.automations.WorkflowType;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.sdk.PipelineServiceClientInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.WorkflowRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/automations/workflows")
@Tag(name="Workflows", description="APIs related to creating and managing Automation workflows.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="Workflow")
public class WorkflowResource
extends EntityResource<Workflow, WorkflowRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowResource.class);
    public static final String COLLECTION_PATH = "/v1/automations/workflows";
    static final String FIELDS = "owners";
    private PipelineServiceClientInterface pipelineServiceClient;
    private OpenMetadataApplicationConfig openMetadataApplicationConfig;

    public WorkflowResource(Authorizer authorizer, Limits limits) {
        super("workflow", authorizer, limits);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        this.openMetadataApplicationConfig = config;
        this.pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(config.getPipelineServiceClientConfiguration());
    }

    @GET
    @Operation(operationId="listWorkflows", summary="List automations workflows", description="Get a list of automations workflows. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of automations workflows", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowList.class))})})
    public ResultList<Workflow> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number automations workflows returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of automations workflows before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of automations workflows after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include, @Parameter(description="Filter by workflowType.", schema=@Schema(implementation=WorkflowType.class)) @QueryParam(value="workflowType") String workflowType, @Parameter(description="Filter by status", schema=@Schema(implementation=WorkflowStatus.class)) @QueryParam(value="workflowStatus") String status) {
        ListFilter filter = new ListFilter(include);
        if (workflowType != null) {
            filter.addQueryParam("workflowType", workflowType);
        }
        if (status != null) {
            filter.addQueryParam("workflowStatus", status);
        }
        ResultList<Workflow> workflows = super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        workflows.setData(CommonUtil.listOrEmpty(workflows.getData()).stream().map(service -> this.decryptOrNullify(securityContext, (Workflow)service)).collect(Collectors.toList()));
        return workflows;
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllWorkflowVersion", summary="List Workflow versions", description="Get a list of all the versions of a Workflow identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of Workflow versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a Workflow by Id", description="Get a Workflow by `Id`.", responses={@ApiResponse(responseCode="200", description="The Workflow", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="404", description="Workflow for instance {id} is not found")})
    public Workflow get(@Context UriInfo uriInfo, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.decryptOrNullify(securityContext, (Workflow)this.getInternal(uriInfo, securityContext, id, fieldsParam, include));
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getWorkflowByName", summary="Get a Workflow by name", description="Get a Workflow by `name`.", responses={@ApiResponse(responseCode="200", description="The Workflow", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="404", description="Workflow for instance {name} is not found")})
    public Workflow getByName(@Context UriInfo uriInfo, @Parameter(description="Name of the Workflow", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.decryptOrNullify(securityContext, (Workflow)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include));
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificWorkflowVersion", summary="Get a version of the Workflow", description="Get a version of the Workflow by given `Id`", responses={@ApiResponse(responseCode="200", description="Workflow", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="404", description="Workflow for instance {id} and version {version} is not found")})
    public Workflow getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Workflow version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return this.decryptOrNullify(securityContext, (Workflow)super.getVersionInternal(securityContext, id, version));
    }

    @Override
    @POST
    @Operation(operationId="createWorkflow", summary="Create a Workflow", description="Create a Workflow.", responses={@ApiResponse(responseCode="200", description="The Workflow", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWorkflow create) {
        Workflow workflow = this.getWorkflow(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, this.unmask(workflow));
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @POST
    @Path(value="/trigger/{id}")
    @Operation(operationId="triggerWorkflow", summary="Trigger an workflow run", description="Trigger a workflow run by id.", responses={@ApiResponse(responseCode="200", description="Workflow trigger status code", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Workflow for instance {id} is not found")})
    public PipelineServiceClientResponse runAutomationsWorkflow(@Context UriInfo uriInfo, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext) {
        EntityUtil.Fields fields = this.getFields(FIELDS);
        Workflow workflow = (Workflow)((WorkflowRepository)this.repository).get(uriInfo, id, fields);
        workflow.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build());
        return this.pipelineServiceClient.runAutomationsWorkflow(workflow);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchWorkflow", summary="Update a Workflow", description="Update an existing Workflow using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        Response response = this.patchInternal(uriInfo, securityContext, id, patch);
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchWorkflow", summary="Update a Workflow by name.", description="Update an existing Workflow using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Workflow", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        Response response = this.patchInternal(uriInfo, securityContext, fqn, patch);
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateWorkflow", summary="Update Workflow", description="Create a Workflow, if it does not exist, or update an existing Workflow.", responses={@ApiResponse(responseCode="200", description="The updated Workflow ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWorkflow create) {
        Workflow workflow = this.getWorkflow(create, securityContext.getUserPrincipal().getName());
        workflow = this.unmask(workflow);
        Response response = this.createOrUpdate(uriInfo, securityContext, workflow);
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteWorkflow", summary="Delete a Workflow", description="Delete a Workflow by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Workflow for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the Workflow", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        Response response = this.delete(uriInfo, securityContext, id, false, hardDelete);
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteWorkflowByName", summary="Delete a Workflow", description="Delete a Workflow by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Workflow for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the Workflow", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        Response response = this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted Workflow", description="Restore a soft deleted Workflow.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Workflow. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Workflow.class))})})
    public Response restoreWorkflow(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        Response response = this.restoreEntity(uriInfo, securityContext, restore.getId());
        return Response.fromResponse((Response)response).entity((Object)this.decryptOrNullify(securityContext, (Workflow)response.getEntity())).build();
    }

    private Workflow getWorkflow(CreateWorkflow create, String user) {
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build();
        return ((WorkflowRepository)this.repository).copy(new Workflow(), (CreateEntity)create, user).withDescription(create.getDescription()).withRequest(create.getRequest()).withWorkflowType(create.getWorkflowType()).withDisplayName(create.getDisplayName()).withResponse(create.getResponse()).withStatus(create.getStatus()).withOpenMetadataServerConnection(openMetadataServerConnection).withName(create.getName());
    }

    private Workflow unmask(Workflow workflow) {
        ((WorkflowRepository)this.repository).setFullyQualifiedName(workflow);
        Workflow originalWorkflow = WorkflowType.TEST_CONNECTION.equals((Object)workflow.getWorkflowType()) ? this.buildFromOriginalServiceConnection(workflow) : (Workflow)((WorkflowRepository)this.repository).findByNameOrNull(workflow.getFullyQualifiedName(), Include.NON_DELETED);
        return EntityMaskerFactory.getEntityMasker().unmaskWorkflow(workflow, originalWorkflow);
    }

    private Workflow decryptOrNullify(SecurityContext securityContext, Workflow workflow) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        try {
            this.authorizer.authorize(securityContext, new OperationContext(this.entityType, MetadataOperation.VIEW_ALL), this.getResourceContextById(workflow.getId()));
        }
        catch (AuthorizationException e) {
            Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
            if (workflowConverted.getRequest() instanceof TestServiceConnectionRequest) {
                ((ServiceConnectionEntityInterface)((TestServiceConnectionRequest)workflowConverted.getRequest()).getConnection()).setConfig(null);
            }
            return workflowConverted;
        }
        Workflow workflowDecrypted = secretsManager.decryptWorkflow(workflow);
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig).build();
        workflowDecrypted.setOpenMetadataServerConnection(secretsManager.encryptOpenMetadataConnection(openMetadataServerConnection, false));
        if (this.authorizer.shouldMaskPasswords(securityContext)) {
            workflowDecrypted = EntityMaskerFactory.getEntityMasker().maskWorkflow(workflowDecrypted);
        }
        return workflowDecrypted;
    }

    private Workflow buildFromOriginalServiceConnection(Workflow workflow) {
        TestServiceConnectionRequest testServiceConnection;
        EntityRepository<? extends EntityInterface> serviceRepository;
        ServiceEntityInterface originalService;
        Object object;
        Workflow originalWorkflow = (Workflow)((WorkflowRepository)this.repository).findByNameOrNull(workflow.getFullyQualifiedName(), Include.NON_DELETED);
        if (originalWorkflow == null) {
            originalWorkflow = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
        }
        if ((object = originalWorkflow.getRequest()) instanceof TestServiceConnectionRequest && (originalService = (ServiceEntityInterface)(serviceRepository = Entity.getServiceEntityRepository((testServiceConnection = (TestServiceConnectionRequest)object).getServiceType())).findByNameOrNull(testServiceConnection.getServiceName(), Include.NON_DELETED)) != null && originalService.getConnection() != null) {
            testServiceConnection.setConnection((Object)originalService.getConnection());
            originalWorkflow.setRequest((Object)testServiceConnection);
        }
        return originalWorkflow;
    }

    public static class WorkflowList
    extends ResultList<Workflow> {
    }
}

