/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.datainsight.system;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.DataInsightSystemChartRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/analytics/dataInsights/system/charts")
@Tag(name="Data Insights System Chats", description="APIs related to Data Insights system charts.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="analytics")
public class DataInsightSystemChartResource
extends EntityResource<DataInsightCustomChart, DataInsightSystemChartRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightSystemChartResource.class);
    public static final String COLLECTION_PATH = "/v1/analytics/dataInsights/system/charts";

    public DataInsightSystemChartResource(Authorizer authorizer, Limits limit) {
        super("dataInsightCustomChart", authorizer, limit);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List diCharts = ((DataInsightSystemChartRepository)this.repository).getEntitiesFromSeedData(".*json/data/dataInsight/custom/.*\\.json$");
        for (DataInsightCustomChart diChart : diCharts) {
            ((DataInsightSystemChartRepository)this.repository).initializeEntity(diChart);
        }
    }

    @GET
    @Path(value="/name/{fqn}/data")
    @Operation(operationId="getDataInsightChartData", summary="Get data insight chart data", description="Get data insight chart data", responses={@ApiResponse(responseCode="200", description="The data insight chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response getDataByChartName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="FQN of Data Insight Chart", required=true, schema=@Schema(type="String", example="demo_chart")) @PathParam(value="fqn") String fqn, @Parameter(description="Events starting from this unix timestamp in milliseconds", required=true, schema=@Schema(type="long", example="1426349294842")) @QueryParam(value="start") long start, @Parameter(description="Events ending from this unix timestamp in milliseconds", required=true, schema=@Schema(type="long", example="1426349294842")) @QueryParam(value="end") long end, @Parameter(description="Any additional filter to fetch the data", schema=@Schema(type="string", example="{\"query\":{...}}")) @QueryParam(value="filter") String filter) throws IOException {
        DataInsightCustomChart diChart = (DataInsightCustomChart)this.getByNameInternal(uriInfo, securityContext, fqn, null, null);
        DataInsightCustomChartResultList resultList = ((DataInsightSystemChartRepository)this.repository).getPreviewData(diChart, start, end, filter);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)resultList).build();
    }

    @GET
    @Path(value="/listChartData")
    @Operation(operationId="getDataInsightChartData", summary="Get data insight chart data", description="Get data insight chart data", responses={@ApiResponse(responseCode="200", description="The data insight chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataInsightChart.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response listChartData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="List of chart names separated by `,`", required=true, schema=@Schema(type="String", example="chart1,chart2")) @QueryParam(value="chartNames") String chartNames, @Parameter(description="Events starting from this unix timestamp in milliseconds", required=true, schema=@Schema(type="long", example="1426349294842")) @QueryParam(value="start") long start, @Parameter(description="Events ending from this unix timestamp in milliseconds", required=true, schema=@Schema(type="long", example="1426349294842")) @QueryParam(value="end") long end, @Parameter(description="Any additional filter to fetch the data", schema=@Schema(type="string", example="{\"query\":{...}}")) @QueryParam(value="filter") String filter) throws IOException {
        Map<String, DataInsightCustomChartResultList> resultList = ((DataInsightSystemChartRepository)this.repository).listChartData(chartNames, start, end, filter);
        return Response.status((Response.Status)Response.Status.OK).entity(resultList).build();
    }
}

