/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.docstore;

import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.email.EmailTemplate;
import org.openmetadata.schema.email.TemplateValidationResponse;
import org.openmetadata.schema.entities.docStore.CreateDocument;
import org.openmetadata.schema.entities.docStore.Document;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.jdbi3.DocumentRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/docStore")
@Tag(name="Document Store", description="A `Document` is an generic entity in OpenMetadata.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="knowledgePanel", order=2)
public class DocStoreResource
extends EntityResource<Document, DocumentRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(DocStoreResource.class);
    public static final String COLLECTION_PATH = "/v1/docStore";

    @Override
    public Document addHref(UriInfo uriInfo, Document doc) {
        super.addHref(uriInfo, doc);
        return doc;
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("data", MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.EDIT_ALL});
    }

    public DocStoreResource(Authorizer authorizer, Limits limits) {
        super("document", authorizer, limits);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        ((DocumentRepository)this.repository).initSeedDataFromResources();
    }

    @GET
    @Valid
    @Operation(operationId="listDocuments", summary="List Documents", description="Get a list of Documents. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of personas", content={@Content(mediaType="application/json", schema=@Schema(implementation=DocumentList.class))})})
    public ResultList<Document> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Limit the number of personas returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Filter docs by entityType", schema=@Schema(type="string", example="KnowledgePanel")) @QueryParam(value="entityType") String entityType, @Parameter(description="Filter docs by fqnPrefix", schema=@Schema(type="string", example="fqnPrefix")) @QueryParam(value="fqnPrefix") String fqnPrefix, @Parameter(description="Returns list of personas before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of personas after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) {
        ListFilter filter = new ListFilter(Include.ALL);
        if (entityType != null) {
            filter.addQueryParam("entityType", entityType);
        }
        if (fqnPrefix != null) {
            filter.addQueryParam("fqnPrefix", fqnPrefix);
        }
        return super.listInternal(uriInfo, securityContext, "", filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDocumentVersion", summary="List Document versions", description="Get a list of all the versions of a Document identified by `id`", responses={@ApiResponse(responseCode="200", description="List of persona versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Document", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(summary="Get a Document by id", description="Get a Document by `id`.", responses={@ApiResponse(responseCode="200", description="The Document", content={@Content(mediaType="application/json", schema=@Schema(implementation=Document.class))}), @ApiResponse(responseCode="404", description="Document for instance {id} is not found")})
    public Document get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Document", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Document)this.getInternal(uriInfo, securityContext, id, "", include);
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getDocumentByFQN", summary="Get a Document by name", description="Get a Document by `name`.", responses={@ApiResponse(responseCode="200", description="The Document", content={@Content(mediaType="application/json", schema=@Schema(implementation=Document.class))}), @ApiResponse(responseCode="404", description="Document for instance {name} is not found")})
    public Document getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Document", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Document)this.getByNameInternal(uriInfo, securityContext, name, "", include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDocumentVersion", summary="Get a version of the Document", description="Get a version of the Document by given `id`", responses={@ApiResponse(responseCode="200", description="KnowledgePanel", content={@Content(mediaType="application/json", schema=@Schema(implementation=Document.class))}), @ApiResponse(responseCode="404", description="Document for instance {id} and version {version} is not found")})
    public Document getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Document", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Document version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Document)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDocument", summary="Create a Document", description="Create a new Document.", responses={@ApiResponse(responseCode="200", description="The Knowledge Panel.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Document.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDocument cd) {
        Document doc = this.getDocument(cd, securityContext);
        return this.create(uriInfo, securityContext, doc);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDocument", summary="Update Document", description="Create or Update a Document.", responses={@ApiResponse(responseCode="200", description="The Document.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Document.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDocument cd) {
        Document doc = this.getDocument(cd, securityContext);
        return this.createOrUpdate(uriInfo, securityContext, doc);
    }

    @PUT
    @Path(value="/validateTemplate/{templateName}")
    @Operation(operationId="validateEmailTemplate", summary="Validate Email Template", description="Validates is the give content is a valid Email Template.", responses={@ApiResponse(responseCode="200", description="The Template Validation Response.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TemplateValidationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public TemplateValidationResponse validateEmailTemplate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Template name for the email template to be validated", schema=@Schema(type="string")) @PathParam(value="templateName") String templateName, @Valid EmailTemplate emailTemplate) {
        this.authorizer.authorizeAdmin(securityContext);
        return ((DocumentRepository)this.repository).validateEmailTemplate(templateName, emailTemplate.getTemplate());
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchDocument", summary="Update a Document.", description="Update an existing Document with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Document", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchDocument", summary="Update a Document by name.", description="Update an existing Document with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Document", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDocument", summary="Delete a Document by id", description="Delete a Document by given `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Document for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Document", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, true);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteDocumentByName", summary="Delete a Document by name", description="Delete a Document by given `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Knowledge Panel for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Document", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, true);
    }

    @POST
    @Path(value="/resetEmailTemplate")
    @Produces(value={"application/json"})
    @Operation(summary="Reset seed data of EmailTemplate type", description="Deletes seed data of the EmailTemplate type from the document store and reinitializes it from resources.", responses={@ApiResponse(responseCode="200", description="Seed Data init successfully", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="400", description="Seed Data init failed", content={@Content(mediaType="application/json", schema=@Schema(type="string"))})})
    public Response resetEmailTemplate(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        try {
            ((DocumentRepository)this.repository).deleteEmailTemplates();
            ((DocumentRepository)this.repository).initSeedDataFromResources();
            return Response.ok((Object)"Seed Data init successfully").build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Seed Data init failed: " + e.getMessage())).build();
        }
    }

    private Document getDocument(CreateDocument cd, SecurityContext securityContext) {
        if (cd.getEntityType().equals("EmailTemplate")) {
            this.authorizer.authorizeAdmin(securityContext);
            String content = JsonUtils.convertValue((Object)cd.getData(), EmailTemplate.class).getTemplate();
            TemplateValidationResponse validationResp = ((DocumentRepository)this.repository).validateEmailTemplate(cd.getName(), content);
            if (Boolean.FALSE.equals(validationResp.getIsValid())) {
                throw new CustomExceptionMessage(Response.status((int)400).entity((Object)validationResp).build(), validationResp.getMessage());
            }
        }
        return ((DocumentRepository)this.repository).copy(new Document(), (CreateEntity)cd, securityContext.getUserPrincipal().getName()).withFullyQualifiedName(cd.getFullyQualifiedName()).withData(cd.getData()).withEntityType(cd.getEntityType());
    }

    public static class DocumentList
    extends ResultList<Document> {
    }
}

