/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.kpi;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.dataInsight.kpi.CreateKpiRequest;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.KpiRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/kpi")
@Tag(name="KPIs", description="A `KPI` defines a metric and a target.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="kpi")
public class KpiResource
extends EntityResource<Kpi, KpiRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(KpiResource.class);
    public static final String COLLECTION_PATH = "/v1/kpi";
    static final String FIELDS = "owners,dataInsightChart,kpiResult";

    @Override
    public Kpi addHref(UriInfo uriInfo, Kpi kpi) {
        super.addHref(uriInfo, kpi);
        Entity.withHref(uriInfo, kpi.getDataInsightChart());
        return kpi;
    }

    public KpiResource(Authorizer authorizer, Limits limits) {
        super("kpi", authorizer, limits);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("dataInsightChart,kpiResult", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Operation(operationId="listKpis", summary="List KPIs", description="Get a list of KPIs. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of KPIs", content={@Content(mediaType="application/json", schema=@Schema(implementation=KpiList.class))})})
    public ResultList<Kpi> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,dataInsightChart,kpiResult")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number of KIPs returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tests before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tests after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllKpiVersion", summary="List KPI versions", description="Get a list of all the versions of a KPI identified by `id`", responses={@ApiResponse(responseCode="200", description="List of KPI versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the KPI", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a KPI by Id", description="Get a KPI by `Id`.", responses={@ApiResponse(responseCode="200", description="The KPI", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))}), @ApiResponse(responseCode="404", description="KPI for instance {id} is not found")})
    public Kpi get(@Context UriInfo uriInfo, @Parameter(description="Id of the KPI", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,dataInsightChart,kpiResult")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Kpi)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getKpiByName", summary="Get a KPI by name", description="Get a KPI by `name`.", responses={@ApiResponse(responseCode="200", description="The KPI", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))}), @ApiResponse(responseCode="404", description="Kpi for instance {name} is not found")})
    public Kpi getByName(@Context UriInfo uriInfo, @Parameter(description="Name of the KPI", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,dataInsightChart,kpiResult")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Kpi)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificKpiVersion", summary="Get a version of the KPI", description="Get a version of the KPI by given `id`", responses={@ApiResponse(responseCode="200", description="KPI", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))}), @ApiResponse(responseCode="404", description="KPI for instance {id} and version {version} is not found")})
    public Kpi getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the KPI", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="KPI version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Kpi)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createKpi", summary="Create a KPI", description="Create a KPI.", responses={@ApiResponse(responseCode="200", description="The KPI", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateKpiRequest create) {
        Kpi kpi = this.getKpi(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, kpi);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchKpi", summary="Update a KPI", description="Update an existing KPI using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchKpi(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the KPI", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchKpi", summary="Update a KPI by name.", description="Update an existing KPI using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchKpi(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the KPI", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateKpi", summary="Update KPI", description="Create a KPI, it it does not exist or update an existing KPI.", responses={@ApiResponse(responseCode="200", description="The updated KPI Objective ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateKpiRequest create) {
        Kpi kpi = this.getKpi(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, kpi);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteKpiByName", summary="Delete a KPI by name", description="Delete a KPI by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="KPI for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the KPI", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteKpi", summary="Delete a KPI by Id", description="Delete a KPI by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="KPI for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the KPI", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted KPI", description="Restore a soft deleted KPI.", responses={@ApiResponse(responseCode="200", description="Successfully restored the KPI. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Kpi.class))})})
    public Response restoreKpi(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/{name}/kpiResult")
    @Operation(operationId="listKpiResults", summary="List of KPI results", description="Get a list of all the KPI results for the given KPI id, optionally filtered by  `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of KPI results", content={@Content(mediaType="application/json", schema=@Schema(implementation=KpiResultList.class))})})
    public DataInsightCustomChartResultList listKpiResults(@Context SecurityContext securityContext, @Parameter(description="Name of the KPI", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Filter KPI results after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter KPI results before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs, @Parameter(description="Order the result ", schema=@Schema(type="string")) @Valid @QueryParam(value="orderBy") @DefaultValue(value="DESC") EntityTimeSeriesDAO.OrderBy orderBy) throws IOException {
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        return ((KpiRepository)this.repository).getKpiResults(name, startTs, endTs, orderBy);
    }

    @GET
    @Path(value="/{name}/latestKpiResult")
    @Operation(operationId="getLatestKpiResults", summary="Get a latest KPI Result", description="Get Latest KPI Result for the given KPI", responses={@ApiResponse(responseCode="200", description="Latest KPI Result", content={@Content(mediaType="application/json", schema=@Schema(implementation=KpiResultList.class))})})
    public KpiResult listKpiResults(@Context SecurityContext securityContext, @Parameter(description="Name of the KPI", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return ((KpiRepository)this.repository).getKpiResult(name);
    }

    private Kpi getKpi(CreateKpiRequest create, String user) {
        return ((KpiRepository)this.repository).copy(new Kpi(), (CreateEntity)create, user).withStartDate(create.getStartDate()).withEndDate(create.getEndDate()).withTargetValue(create.getTargetValue()).withDataInsightChart(this.getEntityReference("dataInsightCustomChart", create.getDataInsightChart().value())).withMetricType(create.getMetricType());
    }

    public static class KpiResultList
    extends ResultList<KpiResult> {
    }

    public static class KpiList
    extends ResultList<Kpi> {
    }
}

