/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.metrics;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MetricsRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/metrics")
@Tag(name="Metrics (beta)", description="`Metrics` are measurements computed from data such as `Monthly Active Users`. Some of the metrics that measures used to determine performance against an objective are called KPIs or Key Performance Indicators, such as `User Retention`.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="metrics")
public class MetricsResource
extends EntityResource<Metrics, MetricsRepository> {
    public static final String COLLECTION_PATH = "/v1/metrics/";
    static final String FIELDS = "owners,usageSummary,domain";

    public MetricsResource(Authorizer authorizer, Limits limits) {
        super("metrics", authorizer, limits);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("usageSummary", MetadataOperation.VIEW_USAGE);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_USAGE});
    }

    @GET
    @Operation(operationId="listMetrics", summary="List metrics", description="Get a list of metrics. Use `fields` parameter to get only necessary fields.", responses={@ApiResponse(responseCode="200", description="List of metrics", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetricsList.class))})})
    public ResultList<Metrics> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,usageSummary,domain")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of metrics before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of metrics after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) {
        ListFilter filter = new ListFilter();
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getMetricByID", summary="Get a metric by Id", description="Get a metric by `Id`.", responses={@ApiResponse(responseCode="200", description="The metrics", content={@Content(mediaType="application/json", schema=@Schema(implementation=Metrics.class))}), @ApiResponse(responseCode="404", description="Metrics for instance {id} is not found")})
    public Metrics get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the metric", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,usageSummary,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Metrics)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @Override
    @POST
    @Operation(operationId="createMetric", summary="Create a metric", description="Create a new metric.", responses={@ApiResponse(responseCode="200", description="The metric", content={@Content(mediaType="application/json", schema=@Schema(implementation=Metrics.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid Metrics metrics) {
        this.addToMetrics(securityContext, metrics);
        return super.create(uriInfo, securityContext, metrics);
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((MetricsRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateMetric", summary="Create or update a metric", description="Create a new metric, if it does not exist or update an existing metric.", responses={@ApiResponse(responseCode="200", description="The metric", content={@Content(mediaType="application/json", schema=@Schema(implementation=Metrics.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid Metrics metrics) {
        this.addToMetrics(securityContext, metrics);
        return super.createOrUpdate(uriInfo, securityContext, metrics);
    }

    private void addToMetrics(SecurityContext securityContext, Metrics metrics) {
        metrics.withId(UUID.randomUUID()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    public static class MetricsList
    extends ResultList<Metrics> {
    }
}

