/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.pipelines;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreatePipeline;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.PipelineStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.PipelineRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.dqtests.TestCaseResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/pipelines")
@Tag(name="Pipelines", description="A `Pipeline` enables the flow of data from source to destination through a series of processing steps. ETL is a type of pipeline where the series of steps Extract, Transform and Load the data.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="pipelines")
public class PipelineResource
extends EntityResource<Pipeline, PipelineRepository> {
    public static final String COLLECTION_PATH = "v1/pipelines/";
    static final String FIELDS = "owners,tasks,pipelineStatus,followers,tags,extension,scheduleInterval,domain,sourceHash";

    @Override
    public Pipeline addHref(UriInfo uriInfo, Pipeline pipeline) {
        super.addHref(uriInfo, pipeline);
        Entity.withHref(uriInfo, pipeline.getService());
        return pipeline;
    }

    public PipelineResource(Authorizer authorizer, Limits limits) {
        super("pipeline", authorizer, limits);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("tasks,pipelineStatus", MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.EDIT_LINEAGE, MetadataOperation.EDIT_STATUS});
    }

    @GET
    @Valid
    @Operation(operationId="listPipelines", summary="List pipelines", description="Get a list of pipelines, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of pipelines", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineList.class))})})
    public ResultList<Pipeline> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,tasks,pipelineStatus,followers,tags,extension,scheduleInterval,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter pipelines by service name", schema=@Schema(type="string", example="airflow")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number pipelines returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of pipelines before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of pipelines after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = (ListFilter)new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllPipelineVersion", summary="List pipeline versions", description="Get a list of all the versions of a pipeline identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of pipeline versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getPipelineWithID", summary="Get a pipeline by Id", description="Get a pipeline by `Id`.", responses={@ApiResponse(responseCode="200", description="The pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="404", description="Pipeline for instance {id} is not found")})
    public Pipeline get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,tasks,pipelineStatus,followers,tags,extension,scheduleInterval,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Pipeline)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getPipelineByFQN", summary="Get a pipeline by fully qualified name", description="Get a pipeline by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="404", description="Pipeline for instance {fqn} is not found")})
    public Pipeline getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,tasks,pipelineStatus,followers,tags,extension,scheduleInterval,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Pipeline)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificPipelineVersion", summary="Get a version of the pipeline", description="Get a version of the pipeline by given `Id`", responses={@ApiResponse(responseCode="200", description="pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="404", description="Pipeline for instance {id} and version {version} is not found")})
    public Pipeline getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Pipeline version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Pipeline)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createPipeline", summary="Create a pipeline", description="Create a new pipeline.", responses={@ApiResponse(responseCode="200", description="The pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePipeline create) {
        Pipeline pipeline = this.getPipeline(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, pipeline);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchPipeline", summary="Update a pipeline", description="Update an existing pipeline using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchPipeline", summary="Update a pipeline by name.", description="Update an existing pipeline using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdatePipeline", summary="Create or update a pipeline", description="Create a new pipeline, if it does not exist or update an existing pipeline.", responses={@ApiResponse(responseCode="200", description="The pipeline", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePipeline create) {
        Pipeline pipeline = this.getPipeline(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, pipeline);
    }

    @PUT
    @Path(value="/{fqn}/status")
    @Operation(operationId="addStatusData", summary="Add status data", description="Add status data to the pipeline.", responses={@ApiResponse(responseCode="200", description="The pipeline with a the new status", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response addPipelineStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Valid PipelineStatus pipelineStatus) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_STATUS);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        return ((PipelineRepository)this.repository).addPipelineStatus(uriInfo, fqn, pipelineStatus).toResponse();
    }

    @GET
    @Path(value="/{fqn}/status")
    @Operation(operationId="listPipelineStatuses", summary="List pipeline status", description="Get a list of pipeline status.parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of pipeline statuses.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResource.TestCaseList.class))})})
    public ResultList<PipelineStatus> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter pipeline statues after the given start timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter pipeline statues before the given end timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="endTs") Long endTs) {
        return ((PipelineRepository)this.repository).getPipelineStatuses(fqn, startTs, endTs);
    }

    @DELETE
    @Path(value="/{fqn}/status/{timestamp}")
    @Operation(operationId="DeletePipelineStatus", summary="Delete pipeline status", description="Delete pipeline status for a pipeline.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the PipelineStatus", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))})})
    public Pipeline deletePipelineStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Timestamp of the pipeline status", schema=@Schema(type="long")) @PathParam(value="timestamp") Long timestamp) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_STATUS);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        Pipeline pipeline = ((PipelineRepository)this.repository).deletePipelineStatus(fqn, timestamp);
        return this.addHref(uriInfo, pipeline);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollower", summary="Add a follower", description="Add a user identified by `userId` as follower of this pipeline", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="Pipeline for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="string")) UUID userId) {
        return ((PipelineRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollower", summary="Remove a follower", description="Remove the user identified `userId` as a follower of the pipeline.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="UUID")) @PathParam(value="userId") UUID userId) {
        return ((PipelineRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((PipelineRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deletePipeline", summary="Delete a pipeline by Id", description="Delete a pipeline by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Pipeline for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Id of the pipeline", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deletePipelineByFQN", summary="Delete a pipeline by fully qualified name", description="Delete a pipeline by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Pipeline for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Fully qualified name of the pipeline", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted pipeline", description="Restore a soft deleted pipeline.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Pipeline ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pipeline.class))})})
    public Response restorePipeline(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Pipeline getPipeline(CreatePipeline create, String user) {
        return ((PipelineRepository)this.repository).copy(new Pipeline(), (CreateEntity)create, user).withService(this.getEntityReference("pipelineService", create.getService())).withTasks(create.getTasks()).withSourceUrl(create.getSourceUrl()).withConcurrency(create.getConcurrency()).withStartDate(create.getStartDate()).withPipelineLocation(create.getPipelineLocation()).withScheduleInterval(create.getScheduleInterval()).withSourceHash(create.getSourceHash());
    }

    public static class PipelineStatusList
    extends ResultList<PipelineStatus> {
    }

    public static class PipelineList
    extends ResultList<Pipeline> {
    }
}

