/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.reports;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ReportRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/reports")
@Tag(name="Reports (beta)", description="`Reports` are static information computed from data periodically that includes data in text, table, and visual form.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="reports")
public class ReportResource
extends EntityResource<Report, ReportRepository> {
    public static final String COLLECTION_PATH = "/v1/reports/";
    static final String FIELDS = "owners,usageSummary";

    public ReportResource(Authorizer authorizer, Limits limits) {
        super("report", authorizer, limits);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("usageSummary", MetadataOperation.VIEW_USAGE);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_USAGE});
    }

    @GET
    @Operation(operationId="listReports", summary="List reports", description="Get a list of reports. Use `fields` parameter to get only necessary fields.", responses={@ApiResponse(responseCode="200", description="List of reports", content={@Content(mediaType="application/json", schema=@Schema(implementation=ReportList.class))})})
    public ResultList<Report> list(@Context UriInfo uriInfo, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,usageSummary")) @QueryParam(value="fields") String fieldsParam) {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ListFilter filter = new ListFilter();
        return ((ReportRepository)this.repository).listAfter(uriInfo, fields, filter, 10000, null);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getReportByID", summary="Get a report by Id", description="Get a report by `Id`.", responses={@ApiResponse(responseCode="200", description="The report", content={@Content(mediaType="application/json", schema=@Schema(implementation=Report.class))}), @ApiResponse(responseCode="404", description="Report for instance {id} is not found")})
    public Report get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the report", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,usageSummary")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Report)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @Override
    @POST
    @Operation(operationId="getReportByFQN", summary="Create a report", description="Create a new report.", responses={@ApiResponse(responseCode="200", description="The report", content={@Content(mediaType="application/json", schema=@Schema(implementation=Report.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid Report report) {
        this.addToReport(securityContext, report);
        return super.create(uriInfo, securityContext, report);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateReport", summary="Create or update a report", description="Create a new report, it it does not exist or update an existing report.", responses={@ApiResponse(responseCode="200", description="The report", content={@Content(mediaType="application/json", schema=@Schema(implementation=Report.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid Report report) {
        this.addToReport(securityContext, report);
        return super.createOrUpdate(uriInfo, securityContext, report);
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((ReportRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    private void addToReport(SecurityContext securityContext, Report report) {
        report.withId(UUID.randomUUID()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    public static class ReportList
    extends ResultList<Report> {
    }
}

