/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.search;

import es.org.elasticsearch.action.search.SearchResponse;
import es.org.elasticsearch.search.suggest.Suggest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.DefaultAuthorizer;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/search")
@Tag(name="Search", description="APIs related to search and suggest.")
@Produces(value={"application/json"})
@Collection(name="elasticsearch")
public class SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private final Authorizer authorizer;
    private final SearchRepository searchRepository;
    public static final String ELASTIC_SEARCH_ENTITY_FQN_STREAM = "eventPublisher:ElasticSearch:STREAM";

    public SearchResource(Authorizer authorizer) {
        this.authorizer = authorizer;
        this.searchRepository = Entity.getSearchRepository();
    }

    @GET
    @Path(value="/query")
    @Operation(operationId="searchEntitiesWithQuery", summary="Search entities", description="Search entities using query test. Use query params `from` and `size` for pagination. Use `sort_field` to sort the results in `sort_order`.", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response search(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by columnNames pass q=columnNames:address , for searching deleted entities, use q=deleted:true <br/> 4. For searching by tag names pass q=tags.tagFQN:user.email <br/>5. When user selects a filter pass q=query_text AND q=tags.tagFQN:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags.tagFQN:user.email AND tags.tagFQN:user.address <br/> 7. Search by service version and type q=service.type:databaseService AND version:0.1 <br/> 8. Search Tables with Specific Constraints q=tableConstraints.constraintType.keyword:PRIMARY_KEY AND NOT tier.tagFQN:Tier.Tier1 <br/> 9. Search with owners q=owner.displayName.keyword:owner_name <br/> NOTE: logic operators such as AND, OR and NOT must be in uppercase ", required=true) @DefaultValue(value="*") @QueryParam(value="q") String query, @Parameter(description="ElasticSearch Index name, defaults to table_search_index") @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Filter documents by deleted param. By default deleted is false") @DefaultValue(value="false") @QueryParam(value="deleted") @Deprecated(forRemoval=true) boolean deleted, @Parameter(description="From field to paginate the results, defaults to 0") @DefaultValue(value="0") @QueryParam(value="from") int from, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="When paginating, specify the search_after values. Use it ass search_after=<val1>,<val2>,...") @QueryParam(value="search_after") String searchAfter, @Parameter(description="Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp") @DefaultValue(value="_score") @QueryParam(value="sort_field") String sortFieldParam, @Parameter(description="Sort order asc for ascending or desc for descending, defaults to desc") @DefaultValue(value="desc") @QueryParam(value="sort_order") String sortOrder, @Parameter(description="Track Total Hits") @DefaultValue(value="false") @QueryParam(value="track_total_hits") boolean trackTotalHits, @Parameter(description="Elasticsearch query that will be combined with the query_string query generator from the `query` argument") @QueryParam(value="query_filter") String queryFilter, @Parameter(description="Elasticsearch query that will be used as a post_filter") @QueryParam(value="post_filter") String postFilter, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields, @Parameter(description="Fetch search results in hierarchical order of children elements. By default hierarchy is not fetched. Currently only supported for glossary_term_search_index.") @DefaultValue(value="false") @QueryParam(value="getHierarchy") boolean getHierarchy) throws IOException {
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        ArrayList<EntityReference> domains = new ArrayList();
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        if (!subjectContext.isAdmin()) {
            domains = subjectContext.getUserDomains();
        }
        SearchRequest request = new SearchRequest.ElasticSearchRequestBuilder(query, size, Entity.getSearchRepository().getIndexOrAliasName(index)).from(from).queryFilter(queryFilter).postFilter(postFilter).fetchSource(fetchSource).trackTotalHits(trackTotalHits).sortFieldParam(sortFieldParam).deleted(deleted).sortOrder(sortOrder).includeSourceFields(includeSourceFields).getHierarchy(getHierarchy).domains(domains).applyDomainFilter(!subjectContext.isAdmin() && subjectContext.hasAnyRole("DomainOnlyAccessRole")).searchAfter(searchAfter).build();
        return this.searchRepository.search(request);
    }

    @GET
    @Path(value="/get/{index}/doc/{id}")
    @Operation(operationId="searchEntityInEsIndexWithId", summary="Search entities in ES index with Id", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response searchEntityInEsIndexWithId(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="document Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Index Name", schema=@Schema(type="string")) @PathParam(value="index") String indexName) throws IOException {
        return this.searchRepository.getDocument(indexName, id);
    }

    @GET
    @Path(value="/fieldQuery")
    @Operation(operationId="searchEntitiesWithSpecificFieldAndValue", summary="Search entities", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response searchByField(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="field name") @QueryParam(value="fieldName") String fieldName, @Parameter(description="field value") @QueryParam(value="fieldValue") String fieldValue, @Parameter(description="Search Index name, defaults to table_search_index") @DefaultValue(value="table_search_index") @QueryParam(value="index") String index) throws IOException {
        return this.searchRepository.searchByField(fieldName, fieldValue, index);
    }

    @GET
    @Path(value="/sourceUrl")
    @Operation(operationId="searchEntitiesWithSourceUrl", summary="Search entities", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response searchBySourceUrl(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="source url") @QueryParam(value="sourceUrl") String sourceUrl) throws IOException {
        return this.searchRepository.searchBySourceUrl(sourceUrl);
    }

    @GET
    @Path(value="/suggest")
    @Operation(operationId="getSuggestedEntities", summary="Suggest entities", description="Get suggested entities used for auto-completion.", responses={@ApiResponse(responseCode="200", description="Table Suggestion API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response suggest(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Suggest API can be used to auto-fill the entities name while use is typing search text <br/> 1. To get suggest results pass q=us or q=user etc.. <br/> 2. Do not add any wild-cards such as * like in search api <br/> 3. suggest api is a prefix suggestion <br/>", required=true) @QueryParam(value="q") String query, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in object containing valid suggestions. Defaults to 'suggest`. All indices has a `suggest` field, only some indices have other `suggest_*` fields.") @DefaultValue(value="suggest") @QueryParam(value="field") String fieldName, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields, @DefaultValue(value="false") @QueryParam(value="deleted") boolean deleted) throws IOException {
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        SearchRequest request = new SearchRequest.ElasticSearchRequestBuilder(query, size, index).fieldName(fieldName).deleted(deleted).fetchSource(fetchSource).includeSourceFields(includeSourceFields).build();
        return this.searchRepository.suggest(request);
    }

    @GET
    @Path(value="/aggregate")
    @Operation(operationId="getAggregateFields", summary="Get aggregated fields", description="Get aggregated fields from entities.", responses={@ApiResponse(responseCode="200", description="Table Aggregate API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response aggregate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in an entity.") @QueryParam(value="field") String fieldName, @Parameter(description="value for searching in aggregation") @DefaultValue(value="") @QueryParam(value="value") String value, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by columnNames pass q=columnNames:address, for searching deleted entities, use q=deleted:true <br/>4. For searching by tag names pass q=tags.tagFQN:user.email <br/>5. When user selects a filter pass q=query_text AND tags.tagFQN:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags.tagFQN:user.email AND tags.tagFQN:user.address <br/>NOTE: logic operators such as AND, OR and NOT must be in uppercase ", required=true) @DefaultValue(value="*") @QueryParam(value="q") String query, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @DefaultValue(value="false") @QueryParam(value="deleted") String deleted) throws IOException {
        return this.searchRepository.aggregate(index, fieldName, value, query);
    }

    @GET
    @Path(value="/reindex/stream/status")
    @Operation(operationId="getStreamJobStatus", summary="Get Stream Job Latest Status", description="Stream Job Status", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Status not found")})
    public Response reindexAllJobLastStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        String jobRecord = Entity.getCollectionDAO().entityExtensionTimeSeriesDao().getLatestExtension(ELASTIC_SEARCH_ENTITY_FQN_STREAM, "service.eventPublisher");
        if (jobRecord != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.readValue(jobRecord, EventPublisherJob.class)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No Last Run.").build();
    }
}

