/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services;

import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.SecretsUtil;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

public abstract class ServiceEntityResource<T extends ServiceEntityInterface, R extends ServiceEntityRepository<T, S>, S extends ServiceConnectionEntityInterface>
extends EntityResource<T, R> {
    private final ServiceEntityRepository<T, S> serviceEntityRepository;
    private final ServiceType serviceType;

    protected ServiceEntityResource(String entityType, Authorizer authorizer, Limits limits, ServiceType serviceType) {
        super(entityType, authorizer, limits);
        this.serviceType = serviceType;
        this.serviceEntityRepository = (ServiceEntityRepository)Entity.getServiceEntityRepository(serviceType);
    }

    protected T decryptOrNullify(SecurityContext securityContext, T service) {
        if (service.getConnection() != null) {
            service.getConnection().setConfig(this.retrieveServiceConnectionConfig(service, this.authorizer.shouldMaskPasswords(securityContext)));
        }
        return service;
    }

    private Object retrieveServiceConnectionConfig(T service, boolean maskPassword) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        Object config = secretsManager.decryptServiceConnectionConfig(service.getConnection().getConfig(), this.extractServiceType(service), this.serviceType);
        if (maskPassword) {
            config = EntityMaskerFactory.getEntityMasker().maskServiceConnectionConfig(config, this.extractServiceType(service), this.serviceType);
        }
        return config;
    }

    protected ResultList<T> decryptOrNullify(SecurityContext securityContext, ResultList<T> services) {
        CommonUtil.listOrEmpty(services.getData()).forEach(service -> this.decryptOrNullify(securityContext, service));
        return services;
    }

    protected T unmask(T service) {
        ((ServiceEntityRepository)this.repository).setFullyQualifiedName(service);
        ServiceEntityInterface originalService = (ServiceEntityInterface)((ServiceEntityRepository)this.repository).findByNameOrNull(service.getFullyQualifiedName(), Include.NON_DELETED);
        String connectionType = this.extractServiceType(service);
        try {
            if (originalService != null && originalService.getConnection() != null) {
                Object serviceConnectionConfig = EntityMaskerFactory.getEntityMasker().unmaskServiceConnectionConfig(service.getConnection().getConfig(), originalService.getConnection().getConfig(), connectionType, this.serviceType);
                service.getConnection().setConfig(serviceConnectionConfig);
            }
            return service;
        }
        catch (Exception e) {
            String message = SecretsUtil.buildExceptionMessageConnectionMask(e.getMessage(), connectionType, false);
            if (message != null) {
                throw new InvalidServiceConnectionException(message);
            }
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to unmask connection instance of %s", connectionType));
        }
    }

    protected abstract T nullifyConnection(T var1);

    protected abstract String extractServiceType(T var1);

    protected ResultList<T> listInternal(UriInfo uriInfo, SecurityContext securityContext, String fieldsParam, Include include, String domain, int limitParam, String before, String after) {
        ListFilter filter = new ListFilter(include);
        if (!CommonUtil.nullOrEmpty((String)domain)) {
            EntityReference domainReference = Entity.getEntityReferenceByName("domain", domain, Include.NON_DELETED);
            filter.addQueryParam("domainId", String.format("'%s'", domainReference.getId()));
        }
        ResultList services = this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, services));
    }

    public ServiceEntityRepository<T, S> getServiceEntityRepository() {
        return this.serviceEntityRepository;
    }
}

