/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.apiservices;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateAPIService;
import org.openmetadata.schema.entity.services.APIService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.type.APIServiceConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.APIServiceRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/services/apiServices")
@Tag(name="API Services", description="APIs related `API Service` entities, such as REST or MicroService.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="apiServices")
public class APIServiceResource
extends ServiceEntityResource<APIService, APIServiceRepository, APIServiceConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(APIServiceResource.class);
    public static final String COLLECTION_PATH = "v1/services/apiServices/";
    static final String FIELDS = "pipelines,owners,tags,domain";

    @Override
    public APIService addHref(UriInfo uriInfo, APIService service) {
        super.addHref(uriInfo, service);
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public APIServiceResource(Authorizer authorizer, Limits limits) {
        super("apiService", authorizer, limits, ServiceType.API);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("pipelines", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Operation(operationId="listAPIServices", summary="List API services", description="Get a list of API services.", responses={@ApiResponse(responseCode="200", description="List of API service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIServiceList.class))})})
    public ResultList<APIService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owners,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter services by domain", schema=@Schema(type="string", example="Marketing")) @QueryParam(value="domain") String domain, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of API services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of API services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.listInternal(uriInfo, securityContext, fieldsParam, include, domain, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getAPIServiceByID", summary="Get an API service", description="Get an API service by `id`.", responses={@ApiResponse(responseCode="200", description="API service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))}), @ApiResponse(responseCode="404", description="API service for instance {id} is not found")})
    public APIService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owners,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        APIService apiService = (APIService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, apiService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getAPIServiceByFQN", summary="Get API service by name", description="Get a API service by the service `name`.", responses={@ApiResponse(responseCode="200", description="API service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))}), @ApiResponse(responseCode="404", description="API service for instance {id} is not found")})
    public APIService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owners,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        APIService apiService = (APIService)this.getByNameInternal(uriInfo, securityContext, EntityInterfaceUtil.quoteName((String)name), fieldsParam, include);
        return this.decryptOrNullify(securityContext, apiService);
    }

    @PUT
    @Path(value="/{id}/testConnectionResult")
    @Operation(operationId="addTestConnectionResult", summary="Add test connection result", description="Add test connection result to the service.", responses={@ApiResponse(responseCode="200", description="Successfully updated the service", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))})})
    public APIService addTestConnectionResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TestConnectionResult testConnectionResult) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        APIService service = (APIService)((APIServiceRepository)this.repository).addTestConnectionResult(id, testConnectionResult);
        return this.decryptOrNullify(securityContext, service);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllAPIServiceVersion", summary="List API service versions", description="Get a list of all the versions of an API service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of API service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="API service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                APIService apiService = JsonUtils.readValue((String)json, APIService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, apiService));
            }
            catch (Exception e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAPIServiceVersion", summary="Get a version of the API service", description="Get a version of the API service by given `id`", responses={@ApiResponse(responseCode="200", description="API service", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))}), @ApiResponse(responseCode="404", description="API service for instance {id} and version {version} is not found")})
    public APIService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="API service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="API service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        APIService apiService = (APIService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, apiService);
    }

    @Override
    @POST
    @Operation(operationId="createAPIService", summary="Create API service", description="Create a new API service.", responses={@ApiResponse(responseCode="200", description="API service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPIService create) {
        APIService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (APIService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateAPIService", summary="Update API service", description="Update an existing or create a new API service.", responses={@ApiResponse(responseCode="200", description="Object store service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAPIService update) {
        APIService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, this.unmask(service));
        this.decryptOrNullify(securityContext, (APIService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchAPIService", summary="Update an API service", description="Update an existing API service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchAPIService", summary="Update an API service using name.", description="Update an existing API service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteAPIService", summary="Delete an API service", description="Delete an API services.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="API service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the API service", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteAPIServiceByFQN", summary="Delete an APIService by fully qualified name", description="Delete an APIService by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="APIService for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the APIService", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, EntityInterfaceUtil.quoteName((String)fqn), recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted API Service.", description="Restore a soft deleted API Service.", responses={@ApiResponse(responseCode="200", description="Successfully restored the API Service.", content={@Content(mediaType="application/json", schema=@Schema(implementation=APIService.class))})})
    public Response restoreAPIService(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private APIService getService(CreateAPIService create, String user) {
        return ((APIServiceRepository)this.repository).copy(new APIService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected APIService nullifyConnection(APIService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(APIService service) {
        return service.getServiceType().value();
    }

    public static class APIServiceList
    extends ResultList<APIService> {
    }
}

