/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.dashboard;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateDashboardService;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.type.DashboardConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.jdbi3.DashboardServiceRepository;
import org.openmetadata.service.limits.Limits;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/dashboardServices")
@Tag(name="Dashboard Services")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="dashboardServices")
public class DashboardServiceResource
extends ServiceEntityResource<DashboardService, DashboardServiceRepository, DashboardConnection> {
    public static final String COLLECTION_PATH = "v1/services/dashboardServices";
    static final String FIELDS = "owners,domain";

    public DashboardServiceResource(Authorizer authorizer, Limits limits) {
        super("dashboardService", authorizer, limits, ServiceType.DASHBOARD);
    }

    @GET
    @Operation(operationId="listDashboardsService", summary="List dashboard services", description="Get a list of dashboard services.", responses={@ApiResponse(responseCode="200", description="List of dashboard service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardServiceList.class))})})
    public ResultList<DashboardService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @QueryParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter services by domain", schema=@Schema(type="string", example="Marketing")) @QueryParam(value="domain") String domain, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of dashboard services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of dashboard services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.listInternal(uriInfo, securityContext, fieldsParam, include, domain, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDashboardServiceByID", summary="Get a dashboard service by Id", description="Get a dashboard service by `Id`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {id} is not found")})
    public DashboardService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        DashboardService dashboardService = (DashboardService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getDashboardServiceByFQN", summary="Get dashboard service by name", description="Get a dashboard service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {name} is not found")})
    public DashboardService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the dashboard service", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owners,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        DashboardService dashboardService = (DashboardService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @PUT
    @Path(value="/{id}/testConnectionResult")
    @Operation(operationId="addTestConnectionResult", summary="Add test connection result", description="Add test connection result to the service.", responses={@ApiResponse(responseCode="200", description="Successfully updated the service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))})})
    public DashboardService addTestConnectionResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TestConnectionResult testConnectionResult) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        DashboardService service = (DashboardService)((DashboardServiceRepository)this.repository).addTestConnectionResult(id, testConnectionResult);
        return this.decryptOrNullify(securityContext, service);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDashboardServiceVersion", summary="List dashboard service versions", description="Get a list of all the versions of a dashboard service identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of dashboard service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                DashboardService dashboardService = JsonUtils.readValue((String)json, DashboardService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, dashboardService));
            }
            catch (Exception e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDashboardServiceVersion", summary="Get a version of the dashboard service", description="Get a version of the dashboard service by given `Id`", responses={@ApiResponse(responseCode="200", description="dashboard service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {id} and version {version} is not found")})
    public DashboardService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="dashboard service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        DashboardService dashboardService = (DashboardService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @Override
    @POST
    @Operation(operationId="createDashboardService", summary="Create a dashboard service", description="Create a new dashboard service.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardService create) {
        DashboardService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (DashboardService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDashboardService", summary="Update a dashboard service", description="Update an existing dashboard service identified by `Id`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardService update) {
        DashboardService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, this.unmask(service));
        this.decryptOrNullify(securityContext, (DashboardService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDashboardService", summary="Update a dashboard service", description="Update an existing dashboard service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PATCH
    @Path(value="/name/{fqn}")
    @Operation(operationId="patchDashboardService", summary="Update a dashboard service using name.", description="Update an existing dashboard service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the dashboard service", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, fqn, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDashboardService", summary="Delete a dashboard service by Id", description="Delete a Dashboard services. If dashboard (and charts) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DashboardService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteDashboardServiceByName", summary="Delete a dashboard service by name", description="Delete a Dashboard services by `name`. If dashboard (and charts) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DashboardService service for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Name of the dashboard service", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted dashboard service", description="Restore a soft deleted dashboard service.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Chart ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))})})
    public Response restoreDashboardService(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private DashboardService getService(CreateDashboardService create, String user) {
        return ((DashboardServiceRepository)this.repository).copy(new DashboardService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected DashboardService nullifyConnection(DashboardService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(DashboardService service) {
        return service.getServiceType().value();
    }

    public static class DashboardServiceList
    extends ResultList<DashboardService> {
    }
}

