/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.APICollection;
import org.openmetadata.schema.entity.data.APIEndpoint;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.entity.services.APIService;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.service.search.indexes.APICollectionIndex;
import org.openmetadata.service.search.indexes.APIEndpointIndex;
import org.openmetadata.service.search.indexes.APIServiceIndex;
import org.openmetadata.service.search.indexes.AggregatedCostAnalysisReportDataIndex;
import org.openmetadata.service.search.indexes.ChartIndex;
import org.openmetadata.service.search.indexes.ClassificationIndex;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DashboardServiceIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.DatabaseIndex;
import org.openmetadata.service.search.indexes.DatabaseSchemaIndex;
import org.openmetadata.service.search.indexes.DatabaseServiceIndex;
import org.openmetadata.service.search.indexes.DomainIndex;
import org.openmetadata.service.search.indexes.EntityReportDataIndex;
import org.openmetadata.service.search.indexes.GlossaryIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.IngestionPipelineIndex;
import org.openmetadata.service.search.indexes.MessagingServiceIndex;
import org.openmetadata.service.search.indexes.MetadataServiceIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.MlModelServiceIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.PipelineServiceIndex;
import org.openmetadata.service.search.indexes.QueryIndex;
import org.openmetadata.service.search.indexes.RawCostAnalysisReportDataIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.SearchServiceIndex;
import org.openmetadata.service.search.indexes.StorageServiceIndex;
import org.openmetadata.service.search.indexes.StoredProcedureIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TeamIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.TestCaseResolutionStatusIndex;
import org.openmetadata.service.search.indexes.TestSuiteIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.search.indexes.WebAnalyticEntityViewReportDataIndex;
import org.openmetadata.service.search.indexes.WebAnalyticUserActivityReportDataIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexFactory.class);

    public SearchIndex buildIndex(String entityType, Object entity) {
        return switch (entityType) {
            case "table" -> new TableIndex((Table)entity);
            case "dashboard" -> new DashboardIndex((Dashboard)entity);
            case "topic" -> new TopicIndex((Topic)entity);
            case "pipeline" -> new PipelineIndex((Pipeline)entity);
            case "ingestionPipeline" -> new IngestionPipelineIndex((IngestionPipeline)entity);
            case "user" -> new UserIndex((User)entity);
            case "team" -> new TeamIndex((Team)entity);
            case "glossary" -> new GlossaryIndex((Glossary)entity);
            case "glossaryTerm" -> new GlossaryTermIndex((GlossaryTerm)entity);
            case "mlmodel" -> new MlModelIndex((MlModel)entity);
            case "tag" -> new TagIndex((Tag)entity);
            case "classification" -> new ClassificationIndex((Classification)entity);
            case "query" -> new QueryIndex((Query)entity);
            case "container" -> new ContainerIndex((Container)entity);
            case "database" -> new DatabaseIndex((Database)entity);
            case "databaseSchema" -> new DatabaseSchemaIndex((DatabaseSchema)entity);
            case "testCase" -> new TestCaseIndex((TestCase)entity);
            case "testSuite" -> new TestSuiteIndex((TestSuite)entity);
            case "chart" -> new ChartIndex((Chart)entity);
            case "dashboardDataModel" -> new DashboardDataModelIndex((DashboardDataModel)entity);
            case "apiCollection" -> new APICollectionIndex((APICollection)entity);
            case "apiEndpoint" -> new APIEndpointIndex((APIEndpoint)entity);
            case "dashboardService" -> new DashboardServiceIndex((DashboardService)entity);
            case "databaseService" -> new DatabaseServiceIndex((DatabaseService)entity);
            case "messagingService" -> new MessagingServiceIndex((MessagingService)entity);
            case "mlmodelService" -> new MlModelServiceIndex((MlModelService)entity);
            case "searchService" -> new SearchServiceIndex((SearchService)entity);
            case "apiService" -> new APIServiceIndex((APIService)entity);
            case "searchIndex" -> new SearchEntityIndex((org.openmetadata.schema.entity.data.SearchIndex)entity);
            case "pipelineService" -> new PipelineServiceIndex((PipelineService)entity);
            case "storageService" -> new StorageServiceIndex((StorageService)entity);
            case "domain" -> new DomainIndex((Domain)entity);
            case "storedProcedure" -> new StoredProcedureIndex((StoredProcedure)entity);
            case "dataProduct" -> new DataProductIndex((DataProduct)entity);
            case "metadataService" -> new MetadataServiceIndex((MetadataService)entity);
            case "entityReportData" -> new EntityReportDataIndex((ReportData)entity);
            case "webAnalyticEntityViewReportData" -> new WebAnalyticEntityViewReportDataIndex((ReportData)entity);
            case "webAnalyticUserActivityReportData" -> new WebAnalyticUserActivityReportDataIndex((ReportData)entity);
            case "rawCostAnalysisReportData" -> new RawCostAnalysisReportDataIndex((ReportData)entity);
            case "aggregatedCostAnalysisReportData" -> new AggregatedCostAnalysisReportDataIndex((ReportData)entity);
            case "testCaseResolutionStatus" -> new TestCaseResolutionStatusIndex((TestCaseResolutionStatus)entity);
            default -> this.buildExternalIndexes(entityType, entity);
        };
    }

    protected SearchIndex buildExternalIndexes(String entityType, Object entity) {
        throw new IllegalArgumentException(String.format("Entity Type [%s] is not valid for Index Factory, Entity: %s", entityType, entity));
    }
}

