/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openmetadata.schema.tests.DataQualityReport;
import org.openmetadata.schema.tests.Datum;
import org.openmetadata.schema.tests.type.DataQualityReportMetadata;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.search.SearchClient;

public final class SearchIndexUtils {
    private SearchIndexUtils() {
    }

    public static List<String> parseFollowers(List<EntityReference> followersRef) {
        if (followersRef == null) {
            return Collections.emptyList();
        }
        return followersRef.stream().map(item -> item.getId().toString()).toList();
    }

    public static List<String> parseOwners(List<EntityReference> ownersRef) {
        if (ownersRef == null) {
            return Collections.emptyList();
        }
        return ownersRef.stream().map(item -> item.getId().toString()).toList();
    }

    public static void removeNonIndexableFields(Map<String, Object> doc, Set<String> fields) {
        for (String key : fields) {
            if (key.contains(".")) {
                SearchIndexUtils.removeFieldByPath(doc, key);
                continue;
            }
            doc.remove(key);
        }
    }

    public static void removeFieldByPath(Map<String, Object> jsonMap, String path) {
        Map currentMap = jsonMap;
        String[] pathElements = path.split("\\.");
        String key = pathElements[0];
        Object value = currentMap.get(key);
        if (!(value instanceof Map)) {
            if (value instanceof List) {
                List list = (List)value;
                for (Map item : list) {
                    SearchIndexUtils.removeFieldByPath(item, Arrays.stream(pathElements, 1, pathElements.length).collect(Collectors.joining(".")));
                }
                return;
            }
            return;
        }
        currentMap = (Map)value;
        String lastKey = pathElements[pathElements.length - 1];
        currentMap.remove(lastKey);
    }

    private static void handleLeafTermsAggregation(JsonObject aggregationResults, List<Datum> reportData, Map<String, String> nodeData) {
        Optional<String> docCount = Optional.ofNullable(((JsonValue)aggregationResults.get((Object)"doc_count")).toString());
        docCount.ifPresentOrElse(s -> nodeData.put("document_count", (String)s), () -> nodeData.put("document_count", null));
        Datum datum = new Datum();
        for (Map.Entry<String, String> entry : nodeData.entrySet()) {
            datum.withAdditionalProperty(entry.getKey(), entry.getValue());
        }
        reportData.add(datum);
    }

    private static void handleLeafMetricsAggregation(JsonObject aggregationResults, List<Datum> reportData, Map<String, String> nodeData, String metric) {
        Optional<String> val = Optional.ofNullable(aggregationResults.getString("value_as_string"));
        val.ifPresentOrElse(s -> nodeData.put(metric, (String)s), () -> nodeData.put(metric, null));
        Datum datum = new Datum();
        for (Map.Entry<String, String> entry : nodeData.entrySet()) {
            datum.withAdditionalProperty(entry.getKey(), entry.getValue());
        }
        reportData.add(datum);
    }

    private static DataQualityReportMetadata getAggregationMetadata(List<List<Map<String, String>>> aggregationMapList) {
        DataQualityReportMetadata metadata = new DataQualityReportMetadata();
        ArrayList<String> dimensions = new ArrayList<String>();
        ArrayList<String> metrics = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (List<Map<String, String>> aggregationsMap : aggregationMapList) {
            for (int j = 0; j < aggregationsMap.size(); ++j) {
                boolean isLeaf;
                Map<String, String> aggregationMap = aggregationsMap.get(j);
                String aggType = aggregationMap.get("aggType");
                String field = aggregationMap.get("field");
                boolean bl = isLeaf = j == aggregationsMap.size() - 1;
                if (isLeaf) {
                    if (!aggType.contains("term")) {
                        metrics.add(field);
                    } else {
                        dimensions.add(field);
                        metrics.add("document_count");
                    }
                } else {
                    dimensions.add(field);
                }
                String formattedAggType = aggType.contains("term") ? "s%s".formatted(aggType) : aggType;
                keys.add("%s#%s".formatted(formattedAggType, aggregationMap.get("bucketName")));
            }
        }
        metadata.withKeys(keys).withDimensions(dimensions).withMetrics(metrics);
        return metadata;
    }

    private static void traverseAggregationResults(JsonObject aggregationResults, List<Datum> reportData, Map<String, String> nodeData, List<String> keys, String metric, List<String> dimensions) {
        if (keys.isEmpty()) {
            SearchIndexUtils.handleLeafTermsAggregation(aggregationResults, reportData, nodeData);
            return;
        }
        String currentKey = keys.get(0);
        Optional<JsonObject> aggregation = Optional.ofNullable(SearchClient.getAggregationObject(aggregationResults, currentKey));
        aggregation.ifPresent(agg -> {
            Optional<JsonArray> buckets = Optional.ofNullable(SearchClient.getAggregationBuckets(agg));
            if (buckets.isEmpty()) {
                SearchIndexUtils.handleLeafMetricsAggregation(agg, reportData, nodeData, metric);
            } else {
                buckets.get().forEach(bucket -> {
                    JsonObject bucketObject = (JsonObject)bucket;
                    Optional<String> bucketKey = Optional.of(bucketObject.getString("key"));
                    bucketKey.ifPresentOrElse(s -> nodeData.put((String)dimensions.get(0), (String)s), () -> nodeData.put((String)dimensions.get(0), null));
                    SearchIndexUtils.traverseAggregationResults(bucketObject, reportData, nodeData, keys.subList(1, keys.size()), metric, dimensions.subList(1, dimensions.size()));
                });
            }
        });
    }

    public static DataQualityReport parseAggregationResults(Optional<JsonObject> aggregationResults, List<List<Map<String, String>>> aggregationMapList) {
        DataQualityReportMetadata metadata = SearchIndexUtils.getAggregationMetadata(aggregationMapList);
        ArrayList reportData = new ArrayList();
        aggregationResults.ifPresent(jsonObject -> SearchIndexUtils.traverseAggregationResults(jsonObject, reportData, new HashMap<String, String>(), metadata.getKeys(), (String)metadata.getMetrics().get(0), metadata.getDimensions()));
        DataQualityReport report = new DataQualityReport();
        return report.withMetadata(metadata).withData(reportData);
    }

    public static Map<String, Object> buildAggregationString(String aggregation) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        StringBuilder aggregationString = new StringBuilder();
        String[] siblings = aggregation.split(";");
        ArrayList aggregationsMapList = new ArrayList();
        for (String sibling : siblings) {
            ArrayList aggregationsMap = new ArrayList();
            String[] nested = sibling.split(",");
            for (int i = 0; i < nested.length; ++i) {
                HashMap<String, String> aggregationMap = new HashMap<String, String>();
                String[] parts = nested[i].split(":");
                for (int j = 0; j < parts.length; ++j) {
                    String part = parts[j];
                    String[] kvPairs = part.split("=");
                    if (kvPairs[0].equals("field")) {
                        aggregationString.append("\"").append(kvPairs[0]).append("\":\"").append(kvPairs[1]).append("\"");
                        aggregationString.append("}");
                    } else {
                        aggregationString.append("\"").append(kvPairs[1]).append("\":{");
                    }
                    aggregationMap.put(kvPairs[0], kvPairs[1]);
                }
                if (i < nested.length - 1) {
                    aggregationString.append(",\"aggs\":{");
                }
                aggregationsMap.add(aggregationMap);
            }
            aggregationString.append("}".repeat((nested.length - 1) * 2 + 1));
            aggregationsMapList.add(aggregationsMap);
        }
        metadata.put("aggregationStr", aggregationString.toString());
        metadata.put("aggregationMapList", aggregationsMapList);
        return metadata;
    }

    public static List<TagLabel> parseTags(List<TagLabel> tags) {
        if (tags == null) {
            return Collections.emptyList();
        }
        return tags;
    }
}

