/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticsearch.dataInsightAggregators;

import es.org.elasticsearch.action.search.SearchRequest;
import es.org.elasticsearch.action.search.SearchResponse;
import es.org.elasticsearch.index.query.QueryBuilder;
import es.org.elasticsearch.index.query.RangeQueryBuilder;
import es.org.elasticsearch.search.aggregations.AggregationBuilder;
import es.org.elasticsearch.search.aggregations.AggregationBuilders;
import es.org.elasticsearch.search.aggregations.Aggregations;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import es.org.elasticsearch.search.builder.SearchSourceBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResult;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.custom.FormulaHolder;
import org.openmetadata.schema.dataInsight.custom.SummaryCard;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchDynamicChartAggregatorInterface;
import org.openmetadata.service.util.JsonUtils;

public class ElasticSearchSummaryCardAggregator
implements ElasticSearchDynamicChartAggregatorInterface {
    @Override
    public SearchRequest prepareSearchRequest(@NotNull DataInsightCustomChart diChart, long start, long end, List<FormulaHolder> formulas) throws IOException {
        SummaryCard summaryCard = JsonUtils.convertValue(diChart.getChartDetails(), SummaryCard.class);
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"1").field("@timestamp")).calendarInterval(DateHistogramInterval.DAY);
        this.populateDateHistogram(summaryCard.getFunction(), summaryCard.getFormula(), summaryCard.getField(), summaryCard.getFilter(), dateHistogramAggregationBuilder, formulas);
        RangeQueryBuilder queryFilter = new RangeQueryBuilder("@timestamp").gte((Object)start).lte((Object)end);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)dateHistogramAggregationBuilder);
        searchSourceBuilder.query((QueryBuilder)queryFilter);
        searchSourceBuilder.size(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{"di-data-assets-*"});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Override
    public DataInsightCustomChartResultList processSearchResponse(@NotNull DataInsightCustomChart diChart, SearchResponse searchResponse, List<FormulaHolder> formulas) {
        DataInsightCustomChartResultList resultList = new DataInsightCustomChartResultList();
        SummaryCard summaryCard = JsonUtils.convertValue(diChart.getChartDetails(), SummaryCard.class);
        List aggregationList = Optional.ofNullable(searchResponse.getAggregations()).orElse(new Aggregations(new ArrayList())).asList();
        List<DataInsightCustomChartResult> results = this.processAggregations(aggregationList, summaryCard.getFormula(), null, formulas);
        ArrayList<DataInsightCustomChartResult> finalResults = new ArrayList<DataInsightCustomChartResult>();
        for (int i = results.size() - 1; i >= 0; --i) {
            if (results.get(i).getCount() == null) continue;
            finalResults.add(results.get(i));
            resultList.setResults(finalResults);
            return resultList;
        }
        resultList.setResults(results);
        return resultList;
    }
}

