/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.APIEndpoint;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.FlattenSchemaField;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.FullyQualifiedName;

public class APIEndpointIndex
implements SearchIndex {
    final Set<String> excludeAPIEndpointFields = Set.of("sampleData");
    final APIEndpoint apiEndpoint;

    public APIEndpointIndex(APIEndpoint apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.apiEndpoint.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.apiEndpoint.getName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.apiEndpoint;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludeAPIEndpointFields;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<FlattenSchemaField> flattenFields;
        ArrayList<SearchSuggest> fieldSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        HashSet<List<TagLabel>> tagsWithChildren = new HashSet<List<TagLabel>>();
        ArrayList<String> fieldsWithChildrenName = new ArrayList<String>();
        serviceSuggest.add(SearchSuggest.builder().input(this.apiEndpoint.getService().getName()).weight(5).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.apiEndpoint.getApiCollection().getName()).weight(5).build());
        if (this.apiEndpoint.getResponseSchema() != null && this.apiEndpoint.getResponseSchema().getSchemaFields() != null && !this.apiEndpoint.getResponseSchema().getSchemaFields().isEmpty()) {
            flattenFields = new ArrayList<FlattenSchemaField>();
            this.parseSchemaFields(this.apiEndpoint.getResponseSchema().getSchemaFields(), flattenFields, null);
            for (FlattenSchemaField field : flattenFields) {
                fieldSuggest.add(SearchSuggest.builder().input(field.getName()).weight(5).build());
                fieldsWithChildrenName.add(field.getName());
                if (field.getTags() == null) continue;
                tagsWithChildren.add(field.getTags());
            }
            doc.put("response_field_names", fieldsWithChildrenName);
        }
        if (this.apiEndpoint.getRequestSchema() != null && this.apiEndpoint.getRequestSchema().getSchemaFields() != null && !this.apiEndpoint.getRequestSchema().getSchemaFields().isEmpty()) {
            flattenFields = new ArrayList();
            this.parseSchemaFields(this.apiEndpoint.getResponseSchema().getSchemaFields(), flattenFields, null);
            for (FlattenSchemaField field : flattenFields) {
                fieldSuggest.add(SearchSuggest.builder().input(field.getName()).weight(5).build());
                fieldsWithChildrenName.add(field.getName());
                if (field.getTags() == null) continue;
                tagsWithChildren.add(field.getTags());
            }
            doc.put("request_field_names", fieldsWithChildrenName);
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("apiEndpoint", (EntityInterface)this.apiEndpoint));
        tagsWithChildren.add(parseTags.getTags());
        List flattenedTagList = tagsWithChildren.stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.apiEndpoint, "apiEndpoint");
        doc.putAll(commonAttributes);
        doc.put("lineage", SearchIndex.getLineageData(this.apiEndpoint.getEntityReference()));
        doc.put("requestSchema", this.apiEndpoint.getRequestSchema() != null ? this.apiEndpoint.getRequestSchema() : null);
        doc.put("responseSchema", this.apiEndpoint.getResponseSchema() != null ? this.apiEndpoint.getResponseSchema() : null);
        doc.put("service", this.getEntityWithDisplayName(this.apiEndpoint.getService()));
        return doc;
    }

    private void parseSchemaFields(List<Field> fields, List<FlattenSchemaField> flattenSchemaFields, String parentSchemaField) {
        Optional<String> optParentField = Optional.ofNullable(parentSchemaField).filter(Predicate.not(String::isEmpty));
        List<TagLabel> tags = new ArrayList();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (optParentField.isPresent()) {
                fieldName = FullyQualifiedName.add(optParentField.get(), fieldName);
            }
            if (field.getTags() != null) {
                tags = field.getTags();
            }
            FlattenSchemaField flattenSchemaField = FlattenSchemaField.builder().name(fieldName).description(field.getDescription()).build();
            if (!tags.isEmpty()) {
                flattenSchemaField.setTags(tags);
            }
            flattenSchemaFields.add(flattenSchemaField);
            if (field.getChildren() == null) continue;
            this.parseSchemaFields(field.getChildren(), flattenSchemaFields, field.getName());
        }
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("messageSchema.schemaFields.name", Float.valueOf(7.0f));
        fields.put("responseSchema.schemaFields.name.keyword", Float.valueOf(5.0f));
        fields.put("responseSchema.schemaFields.description", Float.valueOf(1.0f));
        fields.put("responseSchema.schemaFields.children.name", Float.valueOf(7.0f));
        fields.put("responseSchema.schemaFields.children.keyword", Float.valueOf(5.0f));
        return fields;
    }
}

