/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class GlossaryIndex
implements SearchIndex {
    final Glossary glossary;

    public GlossaryIndex(Glossary glossary) {
        this.glossary = glossary;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossary.getName()).weight(5).build());
        if (this.glossary.getDisplayName() != null && !this.glossary.getDisplayName().isEmpty()) {
            suggest.add(SearchSuggest.builder().input(this.glossary.getDisplayName()).weight(10).build());
        }
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.glossary;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.glossary, "glossary");
        doc.putAll(commonAttributes);
        return doc;
    }
}

