/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record TestSuiteIndex(TestSuite testSuite) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.testSuite;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testSuite.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testSuite.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testSuite.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "testSuite");
        doc.put("owners", this.getEntitiesWithDisplayName(this.testSuite.getOwners()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.testSuite.getFollowers()));
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("testSuite", (EntityInterface)this.testSuite));
        doc.put("tags", parseTags.getTags());
        this.setParentRelationships(doc, this.testSuite);
        return doc;
    }

    private void setParentRelationships(Map<String, Object> doc, TestSuite testSuite) {
        EntityReference entityReference = testSuite.getExecutableEntityReference();
        if (entityReference == null) {
            return;
        }
        TestSuiteIndex.addTestSuiteParentEntityRelations(entityReference, doc);
    }

    protected static void addTestSuiteParentEntityRelations(EntityReference testSuiteRef, Map<String, Object> doc) {
        if (testSuiteRef.getType().equals("table")) {
            Table table = (Table)Entity.getEntity(testSuiteRef, "", Include.ALL);
            doc.put("table", table.getEntityReference());
            doc.put("database", table.getDatabase());
            doc.put("databaseSchema", table.getDatabaseSchema());
            doc.put("service", table.getService());
        }
    }
}

