/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.custom.FormulaHolder;
import org.openmetadata.schema.entity.data.EntityHierarchy__1;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.tests.DataQualityReport;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.sdk.exception.SearchException;
import org.openmetadata.sdk.exception.SearchIndexNotFoundException;
import org.openmetadata.service.Entity;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.exception.CatalogGenericExceptionMapper;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.search.EntityBuilderConstant;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.SearchSortFilter;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.DomainIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.QueryIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.StoredProcedureIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.TestCaseResolutionStatusIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.search.opensearch.OpenSearchEntitiesProcessor;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchAggregatedUnusedAssetsCountAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchAggregatedUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchAggregatedUsedvsUnusedAssetsCountAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchAggregatedUsedvsUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchDailyActiveUsersAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchDynamicChartAggregatorFactory;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchDynamicChartAggregatorInterface;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchMostActiveUsersAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchMostViewedEntitiesAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchPageViewsByEntitiesAggregator;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchUnusedAssetsAggregator;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.OpenSearchException;
import os.org.opensearch.OpenSearchStatusException;
import os.org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import os.org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import os.org.opensearch.action.bulk.BulkItemResponse;
import os.org.opensearch.action.bulk.BulkRequest;
import os.org.opensearch.action.bulk.BulkResponse;
import os.org.opensearch.action.delete.DeleteRequest;
import os.org.opensearch.action.get.GetRequest;
import os.org.opensearch.action.get.GetResponse;
import os.org.opensearch.action.search.SearchResponse;
import os.org.opensearch.action.support.WriteRequest;
import os.org.opensearch.action.support.master.AcknowledgedResponse;
import os.org.opensearch.action.update.UpdateRequest;
import os.org.opensearch.client.RequestOptions;
import os.org.opensearch.client.RestClient;
import os.org.opensearch.client.RestClientBuilder;
import os.org.opensearch.client.RestHighLevelClient;
import os.org.opensearch.client.indices.CreateIndexRequest;
import os.org.opensearch.client.indices.CreateIndexResponse;
import os.org.opensearch.client.indices.GetIndexRequest;
import os.org.opensearch.client.indices.GetMappingsRequest;
import os.org.opensearch.client.indices.GetMappingsResponse;
import os.org.opensearch.client.indices.PutMappingRequest;
import os.org.opensearch.cluster.metadata.MappingMetadata;
import os.org.opensearch.common.lucene.search.function.CombineFunction;
import os.org.opensearch.common.lucene.search.function.FieldValueFactorFunction;
import os.org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import os.org.opensearch.common.settings.Settings;
import os.org.opensearch.common.unit.Fuzziness;
import os.org.opensearch.common.unit.TimeValue;
import os.org.opensearch.common.xcontent.DeprecationHandler;
import os.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import os.org.opensearch.common.xcontent.NamedXContentRegistry;
import os.org.opensearch.common.xcontent.XContentParser;
import os.org.opensearch.common.xcontent.XContentType;
import os.org.opensearch.index.IndexNotFoundException;
import os.org.opensearch.index.query.BoolQueryBuilder;
import os.org.opensearch.index.query.MatchQueryBuilder;
import os.org.opensearch.index.query.MultiMatchQueryBuilder;
import os.org.opensearch.index.query.Operator;
import os.org.opensearch.index.query.QueryBuilder;
import os.org.opensearch.index.query.QueryBuilders;
import os.org.opensearch.index.query.QueryStringQueryBuilder;
import os.org.opensearch.index.query.RangeQueryBuilder;
import os.org.opensearch.index.query.ScriptQueryBuilder;
import os.org.opensearch.index.query.TermQueryBuilder;
import os.org.opensearch.index.query.TermsQueryBuilder;
import os.org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import os.org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import os.org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import os.org.opensearch.index.reindex.DeleteByQueryRequest;
import os.org.opensearch.index.reindex.UpdateByQueryRequest;
import os.org.opensearch.rest.RestStatus;
import os.org.opensearch.script.Script;
import os.org.opensearch.script.ScriptType;
import os.org.opensearch.search.SearchHit;
import os.org.opensearch.search.SearchHits;
import os.org.opensearch.search.SearchModule;
import os.org.opensearch.search.aggregations.AggregationBuilder;
import os.org.opensearch.search.aggregations.AggregationBuilders;
import os.org.opensearch.search.aggregations.BucketOrder;
import os.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import os.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import os.org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import os.org.opensearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import os.org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import os.org.opensearch.search.aggregations.bucket.terms.Terms;
import os.org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import os.org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import os.org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import os.org.opensearch.search.builder.SearchSourceBuilder;
import os.org.opensearch.search.fetch.subphase.FetchSourceContext;
import os.org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import os.org.opensearch.search.sort.FieldSortBuilder;
import os.org.opensearch.search.sort.NestedSortBuilder;
import os.org.opensearch.search.sort.SortBuilder;
import os.org.opensearch.search.sort.SortBuilders;
import os.org.opensearch.search.sort.SortMode;
import os.org.opensearch.search.sort.SortOrder;
import os.org.opensearch.search.suggest.Suggest;
import os.org.opensearch.search.suggest.SuggestBuilder;
import os.org.opensearch.search.suggest.SuggestBuilders;
import os.org.opensearch.search.suggest.SuggestionBuilder;
import os.org.opensearch.search.suggest.completion.CompletionSuggestionBuilder;
import os.org.opensearch.search.suggest.completion.context.CategoryQueryContext;

public class OpenSearchClient
implements SearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClient.class);
    protected final RestHighLevelClient client;
    public static final NamedXContentRegistry X_CONTENT_REGISTRY;
    private final boolean isClientAvailable;
    private final String clusterAlias;
    private static final Set<String> FIELDS_TO_REMOVE;

    public OpenSearchClient(ElasticSearchConfiguration config) {
        this.client = this.createOpenSearchClient(config);
        this.clusterAlias = config != null ? config.getClusterAlias() : "";
        this.isClientAvailable = this.client != null;
    }

    @Override
    public boolean isClientAvailable() {
        return this.isClientAvailable;
    }

    @Override
    public boolean indexExists(String indexName) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{indexName});
            gRequest.local(false);
            return this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to check if index %s exists due to", indexName), (Throwable)e);
            return false;
        }
    }

    @Override
    public void createIndex(IndexMapping indexMapping, String indexMappingContent) {
        if (Boolean.TRUE.equals(this.isClientAvailable)) {
            try {
                CreateIndexRequest request = new CreateIndexRequest(indexMapping.getIndexName(this.clusterAlias));
                request.source(indexMappingContent, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.debug("{} Created {}", (Object)indexMapping.getIndexName(this.clusterAlias), (Object)createIndexResponse.isAcknowledged());
                this.createAliases(indexMapping);
            }
            catch (Exception e) {
                LOG.error("Failed to create Open Search indexes due to", (Throwable)e);
            }
        } else {
            LOG.error("Failed to create Open Search index as client is not property configured, Please check your OpenMetadata configuration");
        }
    }

    @Override
    public void createAliases(IndexMapping indexMapping) {
        try {
            HashSet<String> aliases = new HashSet<String>(indexMapping.getParentAliases(this.clusterAlias));
            aliases.add(indexMapping.getAlias(this.clusterAlias));
            IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(indexMapping.getIndexName(this.clusterAlias)).aliases(aliases.toArray(new String[0]));
            IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
            aliasesRequest.addAliasAction(aliasAction);
            this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to create alias for %s due to", indexMapping.getIndexName(this.clusterAlias)), (Throwable)e);
        }
    }

    @Override
    public void updateIndex(IndexMapping indexMapping, String indexMappingContent) {
        try {
            PutMappingRequest request = new PutMappingRequest(new String[]{indexMapping.getIndexName(this.clusterAlias)});
            JsonNode readProperties = JsonUtils.readTree(indexMappingContent).get("mappings");
            request.source(JsonUtils.getMap(readProperties));
            AcknowledgedResponse putMappingResponse = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
            LOG.debug("{} Updated {}", (Object)indexMapping.getIndexMappingFile(), (Object)putMappingResponse.isAcknowledged());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to Update Open Search index %s", indexMapping.getIndexName(this.clusterAlias)));
        }
    }

    @Override
    public void deleteIndex(IndexMapping indexMapping) {
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(indexMapping.getIndexName(this.clusterAlias));
            AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
            LOG.debug("{} Deleted {}", (Object)indexMapping.getIndexName(this.clusterAlias), (Object)deleteIndexResponse.isAcknowledged());
        }
        catch (Exception e) {
            LOG.error("Failed to delete Open Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public Response search(SearchRequest request) throws IOException {
        QueryBuilder filter;
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.getSearchSourceBuilder(request.getIndex(), request.getQuery(), request.getFrom(), request.getSize());
        if (request.isApplyDomainFilter()) {
            if (!CommonUtil.nullOrEmpty(request.getDomains())) {
                TermsQueryBuilder domainFilter = QueryBuilders.termsQuery((String)"domain.fullyQualifiedName", request.getDomains());
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter((QueryBuilder)domainFilter));
            } else {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"domain.fullyQualifiedName")));
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getQueryFilter()) && !request.getQueryFilter().equals("{}")) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getQueryFilter());
                filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getPostFilter())) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getPostFilter());
                filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexOrAliasName("all")) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexOrAliasName("dataAsset"))) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.isDeleted())));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")));
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("domain").getIndexName(this.clusterAlias)) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("dataProduct").getIndexName(this.clusterAlias)) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("query").getIndexName(this.clusterAlias)) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexOrAliasName("knowledge_page_search_index")) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("rawCostAnalysisReportData").getIndexName(this.clusterAlias)) || request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("aggregatedCostAnalysisReportData").getIndexName(this.clusterAlias))) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()));
        } else {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.isDeleted())));
        }
        if (!CommonUtil.nullOrEmpty((String)request.getSortFieldParam()) && !request.isGetHierarchy()) {
            FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)new FieldSortBuilder(request.getSortFieldParam()).order(SortOrder.fromString((String)request.getSortOrder()));
            if (!request.getSortFieldParam().equalsIgnoreCase("_score")) {
                fieldSortBuilder.unmappedType("integer");
            }
            searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
        }
        if (request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("glossaryTerm").getIndexName(this.clusterAlias))) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()));
            if (request.isGetHierarchy()) {
                BoolQueryBuilder baseQuery = QueryBuilders.boolQuery().should(searchSourceBuilder.query()).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"fullyQualifiedName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"name", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"displayName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"glossary.fullyQualifiedName", (Object)request.getQuery())).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"glossary.displayName", (Object)request.getQuery())).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")).minimumShouldMatch(1);
                searchSourceBuilder.query((QueryBuilder)baseQuery);
                SearchResponse searchResponse = this.client.search(new os.org.opensearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT);
                BoolQueryBuilder parentTermQueryBuilder = QueryBuilders.boolQuery();
                Terms parentTerms = (Terms)searchResponse.getAggregations().get("fqnParts_agg");
                if (!parentTerms.getBuckets().isEmpty() && !request.getQuery().equals("*")) {
                    parentTerms.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).forEach(parentTerm -> parentTermQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"fullyQualifiedName", (Object)parentTerm)));
                    searchSourceBuilder.query((QueryBuilder)parentTermQueryBuilder.minimumShouldMatch(1).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")));
                }
                searchSourceBuilder.sort(SortBuilders.fieldSort((String)"fullyQualifiedName").order(SortOrder.ASC));
            }
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(request.isFetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        if (request.isTrackTotalHits()) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(EntityBuilderConstant.MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        try {
            SearchResponse searchResponse = this.client.search(new os.org.opensearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT);
            if (!request.isGetHierarchy()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)searchResponse.toString()).build();
            }
            List<?> response = this.buildSearchHierarchy(request, searchResponse);
            return Response.status((Response.Status)Response.Status.OK).entity(response).build();
        }
        catch (IndexNotFoundException e) {
            throw new SearchIndexNotFoundException(String.format("Failed to to find index %s", request.getIndex()));
        }
    }

    @Override
    public Response getDocByID(String indexName, String entityId) throws IOException {
        try {
            GetRequest request = new GetRequest(Entity.getSearchRepository().getIndexOrAliasName(indexName), entityId);
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            if (response.isExists()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)response.toString()).build();
            }
        }
        catch (OpenSearchException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new SearchIndexNotFoundException(String.format("Failed to to find doc with id %s", entityId));
            }
            throw new SearchException(String.format("Search failed due to %s", e.getMessage()));
        }
        return CatalogGenericExceptionMapper.getResponse(Response.Status.NOT_FOUND, "Document not found.");
    }

    public List<?> buildSearchHierarchy(SearchRequest request, SearchResponse searchResponse) {
        List<Object> response = new ArrayList();
        if (request.getIndex().equalsIgnoreCase(Entity.getSearchRepository().getIndexMapping("glossaryTerm").getIndexName(this.clusterAlias))) {
            response = this.buildGlossaryTermSearchHierarchy(searchResponse);
        }
        return response;
    }

    public List<EntityHierarchy__1> buildGlossaryTermSearchHierarchy(SearchResponse searchResponse) {
        LinkedHashMap<String, Object> termMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, EntityHierarchy__1> rootTerms = new LinkedHashMap<String, EntityHierarchy__1>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            EntityHierarchy__1 glossaryInfo;
            String jsonSource = hit.getSourceAsString();
            EntityHierarchy__1 term2 = JsonUtils.readValue(jsonSource, EntityHierarchy__1.class);
            EntityHierarchy__1 entityHierarchy__1 = glossaryInfo = JsonUtils.readTree(jsonSource).path("glossary").isMissingNode() ? null : JsonUtils.convertValue((Object)JsonUtils.readTree(jsonSource).path("glossary"), EntityHierarchy__1.class);
            if (glossaryInfo != null) {
                rootTerms.putIfAbsent(glossaryInfo.getFullyQualifiedName(), glossaryInfo);
            }
            term2.setChildren(new ArrayList());
            termMap.putIfAbsent(term2.getFullyQualifiedName(), term2);
        }
        termMap.putAll(rootTerms);
        termMap.values().forEach(term -> {
            String parentFQN = FullyQualifiedName.getParentFQN(term.getFullyQualifiedName());
            String termFQN = term.getFullyQualifiedName();
            if (parentFQN != null && termMap.containsKey(parentFQN)) {
                EntityHierarchy__1 parentTerm = (EntityHierarchy__1)termMap.get(parentFQN);
                List children = parentTerm.getChildren();
                children.removeIf(child -> child.getFullyQualifiedName().equals(term.getFullyQualifiedName()));
                children.add(term);
                parentTerm.setChildren(children);
            } else if (rootTerms.containsKey(termFQN)) {
                EntityHierarchy__1 rootTerm = (EntityHierarchy__1)rootTerms.get(termFQN);
                rootTerm.setChildren(term.getChildren());
            }
        });
        return new ArrayList<EntityHierarchy__1>(rootTerms.values());
    }

    @Override
    public SearchClient.SearchResultListMapper listWithOffset(String filter, int limit, int offset, String index, SearchSortFilter searchSortFilter, String q) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (!CommonUtil.nullOrEmpty((String)q)) {
            searchSourceBuilder = OpenSearchClient.getSearchSourceBuilder(index, q, offset, limit);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (!filter.isEmpty()) {
            try {
                XContentParser queryParser = this.createXContentParser(filter);
                XContentParser sourceParser = this.createXContentParser(filter);
                QueryBuilder queryFromXContent = SearchSourceBuilder.fromXContent((XContentParser)queryParser).query();
                FetchSourceContext sourceFromXContent = SearchSourceBuilder.fromXContent((XContentParser)sourceParser).fetchSource();
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                boolQuery = CommonUtil.nullOrEmpty((String)q) ? boolQuery.filter(queryFromXContent) : boolQuery.must(searchSourceBuilder.query()).filter(queryFromXContent);
                searchSourceBuilder.query((QueryBuilder)boolQuery);
                searchSourceBuilder.fetchSource(sourceFromXContent);
            }
            catch (Exception e) {
                throw new IOException("Failed to parse query filter: %s", e);
            }
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        searchSourceBuilder.from(offset);
        searchSourceBuilder.size(limit);
        if (searchSortFilter.isSorted().booleanValue()) {
            FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)searchSortFilter.getSortField()).order(SortOrder.fromString((String)searchSortFilter.getSortType()));
            if (searchSortFilter.isNested().booleanValue()) {
                NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(searchSortFilter.getSortNestedPath());
                fieldSortBuilder.setNestedSort(nestedSortBuilder);
                fieldSortBuilder.sortMode(SortMode.valueOf((String)searchSortFilter.getSortNestedMode().toUpperCase()));
            }
            searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
        }
        try {
            SearchResponse response = this.client.search(new os.org.opensearch.action.search.SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT);
            SearchHits searchHits = response.getHits();
            SearchHit[] hits = searchHits.getHits();
            Arrays.stream(hits).forEach(hit -> results.add(hit.getSourceAsMap()));
            return new SearchClient.SearchResultListMapper(results, searchHits.getTotalHits().value);
        }
        catch (OpenSearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                throw new SearchIndexNotFoundException(String.format("Failed to to find index %s", index));
            }
            throw new SearchException(String.format("Search failed due to %s", e.getDetailedMessage()));
        }
    }

    @Override
    public Response searchBySourceUrl(String sourceUrl) throws IOException {
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"sourceUrl", (String)sourceUrl)));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Map<String, Object> searchLineageInternal(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        if (entityType.equalsIgnoreCase("pipeline") || entityType.equalsIgnoreCase("storedProcedure")) {
            return this.searchPipelineLineage(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted);
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        HashSet<Map<String, Object>> edges = new HashSet<Map<String, Object>>();
        HashSet<Map<String, Object>> nodes = new HashSet<Map<String, Object>>();
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"fullyQualifiedName", (String)fqn)));
        searchRequest.source(searchSourceBuilder.size(1000));
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            responseMap.put("entity", tempMap);
        }
        this.getLineage(fqn, downstreamDepth, edges, nodes, queryFilter, "lineage.fromEntity.fqnHash.keyword", deleted);
        this.getLineage(fqn, upstreamDepth, edges, nodes, queryFilter, "lineage.toEntity.fqnHash.keyword", deleted);
        responseMap.put("edges", edges);
        responseMap.put("nodes", nodes);
        return responseMap;
    }

    @Override
    public Response searchLineage(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        Map<String, Object> responseMap = this.searchLineageInternal(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, entityType);
        return Response.status((Response.Status)Response.Status.OK).entity(responseMap).build();
    }

    private void getLineage(String fqn, int depth, Set<Map<String, Object>> edges, Set<Map<String, Object>> nodes, String queryFilter, String direction, boolean deleted) throws IOException {
        if (depth <= 0) {
            return;
        }
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)direction, (String)FullyQualifiedName.buildHash(fqn))));
        if (CommonUtil.nullOrEmpty((Object)deleted)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)direction, (String)FullyQualifiedName.buildHash(fqn))).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)deleted)));
        }
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchRequest.source(searchSourceBuilder.size(1000));
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            List lineage = (List)hit.getSourceAsMap().get("lineage");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            nodes.add(tempMap);
            for (Map lin : lineage) {
                HashMap fromEntity = (HashMap)lin.get("fromEntity");
                HashMap toEntity = (HashMap)lin.get("toEntity");
                if (direction.equalsIgnoreCase("lineage.fromEntity.fqnHash.keyword")) {
                    if (edges.contains(lin) || !((String)fromEntity.get("fqn")).equals(fqn)) continue;
                    edges.add(lin);
                    this.getLineage((String)toEntity.get("fqn"), depth - 1, edges, nodes, queryFilter, direction, deleted);
                    continue;
                }
                if (edges.contains(lin) || !((String)toEntity.get("fqn")).equals(fqn)) continue;
                edges.add(lin);
                this.getLineage((String)fromEntity.get("fqn"), depth - 1, edges, nodes, queryFilter, direction, deleted);
            }
        }
    }

    private Map<String, Object> searchPipelineLineage(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted) throws IOException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        HashSet<Map<String, Object>> edges = new HashSet<Map<String, Object>>();
        HashSet<Map<String, Object>> nodes = new HashSet<Map<String, Object>>();
        responseMap.put("entity", null);
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"lineage.pipeline.fullyQualifiedName.keyword", (String)fqn)));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        if (CommonUtil.nullOrEmpty((Object)deleted)) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)boolQueryBuilder).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)deleted)));
        }
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (QueryBuilder hit : searchResponse.getHits().getHits()) {
            List lineage = (List)hit.getSourceAsMap().get("lineage");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
            tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
            nodes.add(tempMap);
            for (Map lin : lineage) {
                HashMap fromEntity = (HashMap)lin.get("fromEntity");
                HashMap toEntity = (HashMap)lin.get("toEntity");
                HashMap pipeline = (HashMap)lin.get("pipeline");
                if (pipeline == null || !((String)pipeline.get("fullyQualifiedName")).equalsIgnoreCase(fqn)) continue;
                edges.add(lin);
                this.getLineage((String)fromEntity.get("fqn"), upstreamDepth, edges, nodes, queryFilter, "lineage.toEntity.fqn.keyword", deleted);
                this.getLineage((String)toEntity.get("fqn"), downstreamDepth, edges, nodes, queryFilter, "lineage.fromEntity.fqn.keyword", deleted);
            }
        }
        this.getLineage(fqn, downstreamDepth, edges, nodes, queryFilter, "lineage.fromEntity.fqn.keyword", deleted);
        this.getLineage(fqn, upstreamDepth, edges, nodes, queryFilter, "lineage.toEntity.fqn.keyword", deleted);
        if (edges.isEmpty()) {
            os.org.opensearch.action.search.SearchRequest searchRequestForEntity = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName("all")});
            SearchSourceBuilder searchSourceBuilderForEntity = new SearchSourceBuilder();
            searchSourceBuilderForEntity.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"fullyQualifiedName", (String)fqn)));
            searchRequestForEntity.source(searchSourceBuilderForEntity.size(1000));
            SearchResponse searchResponseForEntity = this.client.search(searchRequestForEntity, RequestOptions.DEFAULT);
            for (SearchHit hit : searchResponseForEntity.getHits().getHits()) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>(JsonUtils.getMap(hit.getSourceAsMap()));
                tempMap.keySet().removeAll(FIELDS_TO_REMOVE);
                responseMap.put("entity", tempMap);
            }
        }
        responseMap.put("edges", edges);
        responseMap.put("nodes", nodes);
        return responseMap;
    }

    private static FunctionScoreQueryBuilder boostScore(QueryStringQueryBuilder queryBuilder, String query) {
        FunctionScoreQueryBuilder.FilterFunctionBuilder exactMatchBoost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.termQuery((String)"displayName.keyword", (String)query), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)10.0f));
        FunctionScoreQueryBuilder.FilterFunctionBuilder nameBoost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"displayName.keyword")).must((QueryBuilder)QueryBuilders.matchQuery((String)"name.keyword", (Object)query)), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)8.0f));
        FunctionScoreQueryBuilder.FilterFunctionBuilder tier1Boost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.termQuery((String)"tier.tagFQN", (String)"Tier1"), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)5.0f));
        FunctionScoreQueryBuilder.FilterFunctionBuilder tier2Boost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.termQuery((String)"tier.tagFQN", (String)"Tier2"), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)3.0f));
        FunctionScoreQueryBuilder.FilterFunctionBuilder tier3Boost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.termQuery((String)"tier.tagFQN", (String)"Tier3"), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)1.0f));
        FunctionScoreQueryBuilder.FilterFunctionBuilder weeklyStatsBoost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.rangeQuery((String)"usageSummary.weeklyStats.count").gt((Object)0), (ScoreFunctionBuilder)ScoreFunctionBuilders.fieldValueFactorFunction((String)"usageSummary.weeklyStats.count").factor(1.5f).modifier(FieldValueFactorFunction.Modifier.SQRT).missing(1.0));
        FunctionScoreQueryBuilder.FilterFunctionBuilder totalVotesBoost = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.rangeQuery((String)"totalVotes").gt((Object)0), (ScoreFunctionBuilder)ScoreFunctionBuilders.fieldValueFactorFunction((String)"totalVotes").factor(2.0f).modifier(FieldValueFactorFunction.Modifier.LN1P).missing(0.0));
        return QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{nameBoost, exactMatchBoost, tier1Boost, tier2Boost, tier3Boost, weeklyStatsBoost, totalVotesBoost}).scoreMode(FunctionScoreQuery.ScoreMode.SUM).boostMode(CombineFunction.SUM);
    }

    private static HighlightBuilder buildHighlights(List<String> fields) {
        List<String> defaultFields = List.of("displayName", "name", "description", "displayName.ngram", "name.ngram");
        defaultFields = Stream.concat(defaultFields.stream(), fields.stream()).toList();
        HighlightBuilder hb = new HighlightBuilder();
        for (String field : defaultFields) {
            HighlightBuilder.Field highlightField = new HighlightBuilder.Field(field);
            highlightField.highlighterType("unified");
            hb.field(highlightField);
        }
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return hb;
    }

    @Override
    public Response searchByField(String fieldName, String fieldValue, String index) throws IOException {
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)fieldValue));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(filter);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()).includeExclude(new IncludeExclude(value.toLowerCase(), null)).order(BucketOrder.key((boolean)true))).query((QueryBuilder)boolQueryBuilder).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    public static List<AggregationBuilder> buildAggregation(JsonObject aggregations) {
        ArrayList<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>();
        for (String key : aggregations.keySet()) {
            JsonObject aggregation = aggregations.getJsonObject(key);
            Set keySet = aggregation.keySet();
            Iterator iterator = keySet.iterator();
            block11: while (iterator.hasNext()) {
                String aggregationType;
                switch (aggregationType = (String)iterator.next()) {
                    case "terms": {
                        JsonObject termAggregation = aggregation.getJsonObject(aggregationType);
                        TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(termAggregation.getString("field"));
                        aggregationBuilders.add((AggregationBuilder)termsAggregationBuilder);
                        break;
                    }
                    case "nested": {
                        JsonObject nestedAggregation = aggregation.getJsonObject("nested");
                        NestedAggregationBuilder nestedAggregationBuilder = AggregationBuilders.nested((String)nestedAggregation.getString("path"), (String)nestedAggregation.getString("path"));
                        JsonObject nestedAggregations = aggregation.getJsonObject("aggs");
                        List<AggregationBuilder> nestedAggregationBuilders = OpenSearchClient.buildAggregation(nestedAggregations);
                        for (AggregationBuilder nestedAggregationBuilder1 : nestedAggregationBuilders) {
                            nestedAggregationBuilder.subAggregation(nestedAggregationBuilder1);
                        }
                        aggregationBuilders.add((AggregationBuilder)nestedAggregationBuilder);
                        break;
                    }
                    case "aggs": {
                        if (keySet.contains("nested")) break;
                        JsonObject subAggregation = aggregation.getJsonObject("aggs");
                        if (CommonUtil.nullOrEmpty(aggregationBuilders)) break;
                        AggregationBuilder aggregationBuilder = (AggregationBuilder)aggregationBuilders.get(aggregationBuilders.size() - 1);
                        List<AggregationBuilder> subAggregationBuilders = OpenSearchClient.buildAggregation(subAggregation);
                        for (AggregationBuilder subAggregationBuilder : subAggregationBuilders) {
                            aggregationBuilder.subAggregation(subAggregationBuilder);
                        }
                        continue block11;
                    }
                }
            }
        }
        return aggregationBuilders;
    }

    @Override
    public DataQualityReport genericAggregation(String query, String index, Map<String, Object> aggregationMetadata) throws IOException {
        String aggregationStr = (String)aggregationMetadata.get("aggregationStr");
        JsonObject aggregationObj = JsonUtils.readJson("{%s}".formatted(aggregationStr)).asJsonObject();
        List<AggregationBuilder> aggregationBuilder = OpenSearchClient.buildAggregation(aggregationObj);
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (query != null) {
            XContentParser queryParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
            QueryBuilder parsedQuery = SearchSourceBuilder.fromXContent((XContentParser)queryParser).query();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(parsedQuery);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        searchSourceBuilder.size(0).timeout(new TimeValue(30L, TimeUnit.SECONDS));
        for (AggregationBuilder aggregation : aggregationBuilder) {
            searchSourceBuilder.aggregation(aggregation);
        }
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        JsonObject jsonResponse = JsonUtils.readJson(response).asJsonObject();
        Optional<JsonObject> aggregationResults = Optional.ofNullable(jsonResponse.getJsonObject("aggregations"));
        return SearchIndexUtils.parseAggregationResults(aggregationResults, (List)aggregationMetadata.get("aggregationMapList"));
    }

    @Override
    public JsonObject aggregate(String query, String index, JsonObject aggregationJson) throws IOException {
        JsonObject aggregations = aggregationJson.getJsonObject("aggregations");
        if (aggregations == null) {
            return null;
        }
        List<AggregationBuilder> aggregationBuilder = OpenSearchClient.buildAggregation(aggregations);
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(index)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (query != null) {
            XContentParser queryParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
            QueryBuilder parsedQuery = SearchSourceBuilder.fromXContent((XContentParser)queryParser).query();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(parsedQuery);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        searchSourceBuilder.size(0).timeout(new TimeValue(30L, TimeUnit.SECONDS));
        for (AggregationBuilder aggregation : aggregationBuilder) {
            searchSourceBuilder.aggregation(aggregation);
        }
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        JsonObject jsonResponse = JsonUtils.readJson(response).asJsonObject();
        return jsonResponse.getJsonObject("aggregations");
    }

    public void updateSearch(UpdateRequest updateRequest) {
        if (updateRequest != null) {
            updateRequest.docAsUpsert(true);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public Response suggest(SearchRequest request) throws IOException {
        String fieldName = request.getFieldName();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(request.getQuery(), Fuzziness.AUTO).size(request.getSize())).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(String.valueOf(request.isDeleted())).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(request.isFetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(request.getIndex())}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private static SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, PipelineIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("tasks.name", "tasks.description"));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tasks.displayName.keyword").field("tasks.displayName.keyword"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, MlModelIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("mlFeatures.name", "mlFeatures.description"));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, TopicIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("messageSchema.schemaFields.description", "messageSchema.schemaFields.children.name"));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name.keyword").field("messageSchema.schemaFields.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fieldNames").field("fieldNames"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, DashboardIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("charts.name", "charts.description"));
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModels.displayName.keyword").field("dataModels.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"project.keyword").field("project.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"charts.displayName.keyword").field("charts.displayName.keyword"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildSearchAcrossIndexesBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, SearchIndex.getAllFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        queryBuilder.boostMode(CombineFunction.SUM);
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"database.name.keyword").field("database.name.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.name.keyword").field("databaseSchema.name.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildGenericDataAssetSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, SearchIndex.getDefaultFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, TableIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("columns.name", "columns.description", "columns.children.name"));
        queryBuilder.boostMode(CombineFunction.SUM);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.displayName.keyword").field("database.displayName.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.displayName.keyword").field("databaseSchema.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tableType").field("tableType"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildUserOrTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(UserIndex.getFields()).fuzziness(Fuzziness.AUTO);
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, GlossaryTermIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("synonyms"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"glossary.name.keyword").field("glossary.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"fqnParts_agg").field("fqnParts")).size(1000));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"status").field("status"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, TagIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"classification.name.keyword").field("classification.name.keyword"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildContainerSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, ContainerIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("dataModel.columns.name", "dataModel.columns.description", "dataModel.columns.name.description"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModel.columns.name.keyword").field("dataModel.columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildQuerySearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, QueryIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildTestCaseSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, TestCaseIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(List.of("testSuite.name", "testSuite.description"));
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildStoredProcedureSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, StoredProcedureIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardDataModelsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, DashboardDataModelIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModelType").field("dataModelType")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"project.keyword").field("project.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildCostAnalysisReportDataSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildDomainsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, DomainIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildSearchEntitySearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, SearchEntityIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fields.name.keyword").field("fields.name.keyword"));
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTestCaseResolutionStatusSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, TestCaseResolutionStatusIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static QueryStringQueryBuilder buildSearchQueryBuilder(String query, Map<String, Float> fields) {
        return QueryBuilders.queryStringQuery((String)query).fields(fields).type(MultiMatchQueryBuilder.Type.MOST_FIELDS).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO).fuzzyPrefixLength(3).tieBreaker(0.5f);
    }

    private static SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(SearchIndex.getAllFields()).fuzziness(Fuzziness.AUTO);
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.displayName.keyword").field("service.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("entityType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"owners.displayName.keyword").field("owners.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"domain.displayName.keyword").field("domain.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"index_count").field("_index")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()));
        return builder;
    }

    private static SearchSourceBuilder buildServiceSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = OpenSearchClient.buildSearchQueryBuilder(query, SearchIndex.getDefaultFields());
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        return OpenSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildDataProductSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = OpenSearchClient.buildSearchQueryBuilder(query, DataProductIndex.getFields());
        FunctionScoreQueryBuilder queryBuilder = OpenSearchClient.boostScore(queryStringBuilder, query);
        HighlightBuilder hb = OpenSearchClient.buildHighlights(new ArrayList<String>());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return OpenSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    @Override
    public ElasticSearchConfiguration.SearchType getSearchType() {
        return ElasticSearchConfiguration.SearchType.OPENSEARCH;
    }

    @Override
    public void createEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            this.updateSearch(updateRequest);
        }
    }

    @Override
    public void createTimeSeriesEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            this.updateSearch(updateRequest);
        }
    }

    @Override
    public void deleteByScript(String indexName, String scriptTxt, Map<String, Object> params) {
        if (this.isClientAvailable) {
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, params);
            ScriptQueryBuilder scriptQuery = new ScriptQueryBuilder(script);
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            deleteByQueryRequest.setQuery((QueryBuilder)scriptQuery);
            this.deleteEntityFromOpenSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void deleteEntity(String indexName, String docId) {
        if (this.isClientAvailable) {
            DeleteRequest deleteRequest = new DeleteRequest(indexName, docId);
            this.deleteEntityFromOpenSearch(deleteRequest);
        }
    }

    @Override
    public void deleteEntityByFields(List<String> indexName, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(indexName.toArray(new String[indexName.size()]));
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            deleteByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromOpenSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreEntity(String indexName, String docId, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateRequest.script(script);
            this.updateSearch(updateRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreChildren(List<String> indexName, String scriptTxt, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(indexName.toArray(new String[indexName.size()]));
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            updateByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateByQueryRequest.setScript(script);
            this.updateOpenSearchByQuery(updateByQueryRequest);
        }
    }

    @Override
    public void updateEntity(String indexName, String docId, Map<String, Object> doc, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, JsonUtils.getMap(doc));
            updateRequest.scriptedUpsert(true);
            updateRequest.script(script);
            this.updateOpenSearch(updateRequest);
        }
    }

    @Override
    public void reindexAcrossIndices(String matchingKey, EntityReference sourceRef) {
        if (this.isClientAvailable) {
            this.getAsyncExecutor().submit(() -> {
                try {
                    int from = 0;
                    boolean hasMoreResults = true;
                    while (hasMoreResults) {
                        List<EntityReference> entities = ReindexingUtil.findReferenceInElasticSearchAcrossAllIndexes(matchingKey, ReindexingUtil.escapeDoubleQuotes(sourceRef.getFullyQualifiedName()), from);
                        this.processEntitiesForReindex(entities);
                        from += entities.size();
                        hasMoreResults = !entities.isEmpty();
                    }
                }
                catch (Exception ex) {
                    LOG.error("Reindexing Across Entities Failed", (Throwable)ex);
                }
            });
        }
    }

    private void processEntitiesForReindex(List<EntityReference> references) throws IOException {
        if (!references.isEmpty()) {
            BulkRequest bulkRequests = new BulkRequest();
            for (EntityReference entityRef : references) {
                UpdateRequest request = OpenSearchEntitiesProcessor.getUpdateRequest(entityRef.getType(), (EntityInterface)Entity.getEntity(entityRef, "*", Include.ALL));
                bulkRequests.add(request);
            }
            if (this.isClientAvailable) {
                this.client.bulk(bulkRequests, RequestOptions.DEFAULT);
            }
        }
    }

    private void updateChildren(UpdateByQueryRequest updateByQueryRequest, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder((String)fieldAndValue.getKey(), fieldAndValue.getValue()).operator(Operator.AND));
        Script script = new Script(ScriptType.INLINE, "painless", (String)updates.getKey(), JsonUtils.getMap(updates.getValue() == null ? new HashMap() : updates.getValue()));
        updateByQueryRequest.setScript(script);
        this.updateOpenSearchByQuery(updateByQueryRequest);
    }

    @Override
    public void updateChildren(String indexName, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(indexName)});
            this.updateChildren(updateByQueryRequest, fieldAndValue, updates);
        }
    }

    @Override
    public void updateChildren(List<String> indexName, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(indexName.toArray(new String[indexName.size()]));
            this.updateChildren(updateByQueryRequest, fieldAndValue, updates);
        }
    }

    @Override
    public void updateLineage(String indexName, Pair<String, String> fieldAndValue, Map<String, Object> lineagaData) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder((String)fieldAndValue.getKey(), fieldAndValue.getValue()).operator(Operator.AND));
            Map<String, Map<String, Object>> params = Collections.singletonMap("lineageData", lineagaData);
            Script script = new Script(ScriptType.INLINE, "painless", "boolean docIdExists = false; for (int i = 0; i < ctx._source.lineage.size(); i++) { if (ctx._source.lineage[i].doc_id.equalsIgnoreCase(params.lineageData.doc_id)) { ctx._source.lineage[i] = params.lineageData; docIdExists = true; break;}}if (!docIdExists) {ctx._source.lineage.add(params.lineageData);}", params);
            updateByQueryRequest.setScript(script);
            this.updateOpenSearchByQuery(updateByQueryRequest);
        }
    }

    private void updateOpenSearchByQuery(UpdateByQueryRequest updateByQueryRequest) {
        if (updateByQueryRequest != null && this.isClientAvailable) {
            updateByQueryRequest.setRefresh(true);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateByQueryRequest);
            this.client.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        }
    }

    public void updateOpenSearch(UpdateRequest updateRequest) {
        if (updateRequest != null && this.isClientAvailable) {
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void deleteByQuery(String index, String query) throws IOException {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{index});
        XContentParser parser = this.createXContentParser(query);
        parser.nextToken();
        deleteRequest.setQuery((QueryBuilder)RangeQueryBuilder.fromXContent((XContentParser)parser));
        this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
    }

    private void deleteEntityFromOpenSearch(DeleteRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    private void deleteEntityFromOpenSearchByQuery(DeleteByQueryRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            deleteRequest.setRefresh(true);
            this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close open search", (Throwable)e);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest data, RequestOptions options) throws IOException {
        return this.client.bulk(data, RequestOptions.DEFAULT);
    }

    @Override
    public int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    @Override
    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) throws IOException, ParseException {
        os.org.opensearch.action.search.SearchRequest searchRequest = OpenSearchClient.buildSearchRequest(startTs, endTs, tier, team, dataInsightChartName, size, from, queryFilter, dataReportIndex);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)OpenSearchClient.processDataInsightChartResult(searchResponse, dataInsightChartName)).build();
    }

    private static DataInsightChartResult processDataInsightChartResult(SearchResponse searchResponse, DataInsightChartResult.DataInsightChartType dataInsightChartName) throws ParseException {
        DataInsightAggregatorInterface processor = OpenSearchClient.createDataAggregator(searchResponse, dataInsightChartName);
        return processor.process(dataInsightChartName);
    }

    private static DataInsightAggregatorInterface createDataAggregator(SearchResponse aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws IllegalArgumentException {
        return switch (dataInsightChartType) {
            default -> throw new IncompatibleClassChangeError();
            case DataInsightChartResult.DataInsightChartType.DAILY_ACTIVE_USERS -> new OpenSearchDailyActiveUsersAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.PAGE_VIEWS_BY_ENTITIES -> new OpenSearchPageViewsByEntitiesAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.MOST_ACTIVE_USERS -> new OpenSearchMostActiveUsersAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.MOST_VIEWED_ENTITIES -> new OpenSearchMostViewedEntitiesAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.UNUSED_ASSETS -> new OpenSearchUnusedAssetsAggregator(aggregations.getHits());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_SIZE -> new OpenSearchAggregatedUnusedAssetsSizeAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_COUNT -> new OpenSearchAggregatedUnusedAssetsCountAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT -> new OpenSearchAggregatedUsedvsUnusedAssetsCountAggregator(aggregations.getAggregations());
            case DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE -> new OpenSearchAggregatedUsedvsUnusedAssetsSizeAggregator(aggregations.getAggregations());
        };
    }

    private static os.org.opensearch.action.search.SearchRequest buildSearchRequest(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) {
        SearchSourceBuilder searchSourceBuilder = OpenSearchClient.buildQueryFilter(startTs, endTs, tier, team, queryFilter, dataInsightChartName.value());
        if (!dataInsightChartName.toString().equalsIgnoreCase(DataInsightChartResult.DataInsightChartType.UNUSED_ASSETS.toString())) {
            AggregationBuilder aggregationBuilder = OpenSearchClient.buildQueryAggregation(dataInsightChartName);
            searchSourceBuilder.aggregation(aggregationBuilder);
            searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        } else {
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.from(from.intValue());
            searchSourceBuilder.size(size.intValue());
            searchSourceBuilder.sort("data.lifeCycle.accessed.timestamp", SortOrder.DESC);
        }
        os.org.opensearch.action.search.SearchRequest searchRequest = new os.org.opensearch.action.search.SearchRequest(new String[]{Entity.getSearchRepository().getIndexOrAliasName(dataReportIndex)});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String queryFilter, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && DataInsightChartRepository.SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.team", teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && DataInsightChartRepository.SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.entityTier", tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        if (!DataInsightChartRepository.SUPPORTS_NULL_DATE_RANGE.contains(dataInsightChartName)) {
            if (startTs == null || endTs == null) {
                throw new IllegalArgumentException(String.format("Start and End date are required for chart type %s ", dataInsightChartName));
            }
            RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTs).lte((Object)endTs);
            searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        }
        searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        return searchSourceBuilder;
    }

    @Override
    public List<Map<String, String>> fetchDIChartFields() throws IOException {
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{"di-data-assets-*"});
        GetMappingsResponse response = this.client.indices().getMapping(request, RequestOptions.DEFAULT);
        for (Map.Entry entry : response.mappings().entrySet()) {
            Map indexFields = ((MappingMetadata)entry.getValue()).sourceAsMap();
            this.getFieldNames((Map)indexFields.get("properties"), "", fields);
        }
        return fields;
    }

    void getFieldNames(@NotNull Map<String, Object> fields, String prefix, List<Map<String, String>> fieldList) {
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            String postfix = "";
            String type = (String)((Map)entry.getValue()).get("type");
            if (type != null && type.equals("text")) {
                postfix = ".keyword";
            }
            String fieldName = prefix + entry.getKey() + postfix;
            String fieldNameOriginal = WordUtils.capitalize((String)(prefix + entry.getKey()).replace(".", " "));
            if (!(entry.getValue() instanceof Map)) continue;
            Map subFields = (Map)entry.getValue();
            if (subFields.containsKey("properties")) {
                this.getFieldNames((Map)subFields.get("properties"), fieldName + ".", fieldList);
                continue;
            }
            if (!fieldList.stream().noneMatch(e -> ((String)e.get("name")).equals(fieldName))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", fieldName);
            map.put("displayName", fieldNameOriginal);
            map.put("type", type);
            fieldList.add(map);
        }
    }

    @Override
    public DataInsightCustomChartResultList buildDIChart(@NotNull DataInsightCustomChart diChart, long start, long end) throws IOException {
        OpenSearchDynamicChartAggregatorInterface aggregator = OpenSearchDynamicChartAggregatorFactory.getAggregator(diChart);
        if (aggregator != null) {
            ArrayList<FormulaHolder> formulas = new ArrayList<FormulaHolder>();
            os.org.opensearch.action.search.SearchRequest searchRequest = aggregator.prepareSearchRequest(diChart, start, end, formulas);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            return aggregator.processSearchResponse(diChart, searchResponse, formulas);
        }
        return null;
    }

    private static AggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"timestamp").field("timestamp")).calendarInterval(DateHistogramInterval.DAY);
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"entityCount").field("data.entityCount");
        switch (dataInsightChartName) {
            case AGGREGATED_UNUSED_ASSETS_SIZE: 
            case AGGREGATED_UNUSED_ASSETS_COUNT: {
                boolean isSize = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_SIZE);
                String fieldType = isSize ? "size" : "count";
                String totalField = isSize ? "totalSize" : "totalCount";
                SumAggregationBuilder threeDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)"threeDays").field(String.format("data.unusedDataAssets.%s.threeDays", fieldType));
                SumAggregationBuilder sevenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)"sevenDays").field(String.format("data.unusedDataAssets.%s.sevenDays", fieldType));
                SumAggregationBuilder fourteenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)"fourteenDays").field(String.format("data.unusedDataAssets.%s.fourteenDays", fieldType));
                SumAggregationBuilder thirtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)"thirtyDays").field(String.format("data.unusedDataAssets.%s.thirtyDays", fieldType));
                SumAggregationBuilder sixtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)"sixtyDays").field(String.format("data.unusedDataAssets.%s.sixtyDays", fieldType));
                SumAggregationBuilder totalUnused = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUnused").field(String.format("data.unusedDataAssets.%s", totalField));
                SumAggregationBuilder totalUsed = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUsed").field(String.format("data.unusedDataAssets.%s", totalField));
                return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)threeDaysAgg)).subAggregation((AggregationBuilder)sevenDaysAgg)).subAggregation((AggregationBuilder)fourteenDaysAgg)).subAggregation((AggregationBuilder)thirtyDaysAgg)).subAggregation((AggregationBuilder)sixtyDaysAgg)).subAggregation((AggregationBuilder)totalUnused)).subAggregation((AggregationBuilder)totalUsed);
            }
            case AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT: 
            case AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE: {
                boolean isSizeReport = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE);
                String totalFieldString = isSizeReport ? "totalSize" : "totalCount";
                SumAggregationBuilder totalUnusedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUnused").field(String.format("data.unusedDataAssets.%s", totalFieldString));
                SumAggregationBuilder totalUsedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUsed").field(String.format("data.frequentlyUsedDataAssets.%s", totalFieldString));
                return ((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)totalUnusedAssets)).subAggregation((AggregationBuilder)totalUsedAssets);
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityFqn").field("data.entityFqn")).size(10).order(BucketOrder.aggregation((String)"pageViews", (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owners").field("data.owner");
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType");
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityHref").field("data.entityHref");
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"userName").field("data.userName")).size(10).order(BucketOrder.aggregation((String)"sessions", (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"team").field("data.team");
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessions").field("data.totalSessions");
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.totalPageView");
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastSession").field("data.lastSession");
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessionDuration").field("data.totalSessionDuration");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }

    public RestHighLevelClient createOpenSearchClient(ElasticSearchConfiguration esConfig) {
        if (esConfig != null) {
            try {
                RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
                if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                    SSLContext sslContext = this.createElasticSearchSSLContext(esConfig);
                    restClientBuilder.setHttpClientConfigCallback(arg_0 -> OpenSearchClient.lambda$createOpenSearchClient$8((CredentialsProvider)credentialsProvider, sslContext, arg_0));
                }
                restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
                return new RestHighLevelClient(restClientBuilder);
            }
            catch (Exception e) {
                LOG.error("Failed to create open search client ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static SearchSourceBuilder getSearchSourceBuilder(String index, String q, int from, int size) {
        return switch (Entity.getSearchRepository().getIndexNameWithoutAlias(index)) {
            case "topic_search_index", "topic" -> OpenSearchClient.buildTopicSearchBuilder(q, from, size);
            case "dashboard_search_index", "dashboard" -> OpenSearchClient.buildDashboardSearchBuilder(q, from, size);
            case "pipeline_search_index", "pipeline" -> OpenSearchClient.buildPipelineSearchBuilder(q, from, size);
            case "mlmodel_search_index", "mlmodel" -> OpenSearchClient.buildMlModelSearchBuilder(q, from, size);
            case "table_search_index", "table" -> OpenSearchClient.buildTableSearchBuilder(q, from, size);
            case "database_schema_search_index", "databaseSchema", "database_search_index", "database" -> OpenSearchClient.buildGenericDataAssetSearchBuilder(q, from, size);
            case "user_search_index", "user", "team_search_index", "team" -> OpenSearchClient.buildUserOrTeamSearchBuilder(q, from, size);
            case "glossary_term_search_index", "glossaryTerm" -> OpenSearchClient.buildGlossaryTermSearchBuilder(q, from, size);
            case "tag_search_index", "tag" -> OpenSearchClient.buildTagSearchBuilder(q, from, size);
            case "container_search_index", "container" -> OpenSearchClient.buildContainerSearchBuilder(q, from, size);
            case "query_search_index", "query" -> OpenSearchClient.buildQuerySearchBuilder(q, from, size);
            case "test_case_search_index", "testCase", "test_suite_search_index", "testSuite" -> OpenSearchClient.buildTestCaseSearch(q, from, size);
            case "stored_procedure_search_index", "storedProcedure" -> OpenSearchClient.buildStoredProcedureSearch(q, from, size);
            case "dashboard_data_model_search_index", "dashboardDataModel" -> OpenSearchClient.buildDashboardDataModelsSearch(q, from, size);
            case "domain_search_index", "domain" -> OpenSearchClient.buildDomainsSearch(q, from, size);
            case "search_entity_search_index", "searchIndex" -> OpenSearchClient.buildSearchEntitySearch(q, from, size);
            case "raw_cost_analysis_report_data_index", "aggregated_cost_analysis_report_data_index" -> OpenSearchClient.buildCostAnalysisReportDataSearch(q, from, size);
            case "data_product_search_index" -> OpenSearchClient.buildDataProductSearch(q, from, size);
            case "test_case_resolution_status_search_index" -> OpenSearchClient.buildTestCaseResolutionStatusSearch(q, from, size);
            case "mlmodel_service_search_index", "database_service_search_index", "messaging_service_index", "dashboard_service_index", "pipeline_service_index", "storage_service_index", "search_service_index", "metadata_service_index" -> OpenSearchClient.buildServiceSearchBuilder(q, from, size);
            case "all", "dataAsset" -> OpenSearchClient.buildSearchAcrossIndexesBuilder(q, from, size);
            default -> OpenSearchClient.buildAggregateSearchBuilder(q, from, size);
        };
    }

    private XContentParser createXContentParser(String query) throws IOException {
        try {
            return XContentType.JSON.xContent().createParser(X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        }
        catch (IOException e) {
            LOG.error("Failed to create XContentParser", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Object getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createOpenSearchClient$8(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        return httpAsyncClientBuilder;
    }

    static {
        FIELDS_TO_REMOVE = Set.of("suggest", "service_suggest", "column_suggest", "schema_suggest", "database_suggest", "lifeCycle", "fqnParts", "chart_suggest", "field_suggest");
        SearchModule searchModule = new SearchModule(Settings.EMPTY, List.of());
        X_CONTENT_REGISTRY = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

