/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch.dataInsightAggregator;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResult;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.custom.FormulaHolder;
import org.openmetadata.schema.dataInsight.custom.Function;
import org.openmetadata.service.search.opensearch.OpenSearchClient;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.springframework.expression.Expression;
import os.org.opensearch.action.search.SearchRequest;
import os.org.opensearch.action.search.SearchResponse;
import os.org.opensearch.common.xcontent.DeprecationHandler;
import os.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import os.org.opensearch.common.xcontent.XContentParser;
import os.org.opensearch.common.xcontent.XContentType;
import os.org.opensearch.index.query.QueryBuilder;
import os.org.opensearch.index.query.QueryBuilders;
import os.org.opensearch.search.aggregations.Aggregation;
import os.org.opensearch.search.aggregations.AggregationBuilder;
import os.org.opensearch.search.aggregations.AggregationBuilders;
import os.org.opensearch.search.aggregations.bucket.filter.ParsedFilter;
import os.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import os.org.opensearch.search.aggregations.bucket.histogram.Histogram;
import os.org.opensearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import os.org.opensearch.search.aggregations.metrics.ParsedCardinality;
import os.org.opensearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import os.org.opensearch.search.aggregations.metrics.ParsedValueCount;
import os.org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import os.org.opensearch.search.builder.SearchSourceBuilder;

public interface OpenSearchDynamicChartAggregatorInterface {
    public static final long MILLISECONDS_IN_DAY = 86400000L;

    private static ValuesSourceAggregationBuilder getSubAggregationsByFunction(Function function, String field, int index) {
        switch (function) {
            case COUNT: {
                return AggregationBuilders.count((String)(field + index)).field(field);
            }
            case SUM: {
                return AggregationBuilders.sum((String)(field + index)).field(field);
            }
            case AVG: {
                return AggregationBuilders.avg((String)(field + index)).field(field);
            }
            case MIN: {
                return AggregationBuilders.min((String)(field + index)).field(field);
            }
            case MAX: {
                return AggregationBuilders.max((String)(field + index)).field(field);
            }
            case UNIQUE: {
                return AggregationBuilders.cardinality((String)(field + index)).field(field);
            }
        }
        return null;
    }

    public static void getDateHistogramByFormula(String formula, QueryBuilder filter, DateHistogramAggregationBuilder dateHistogramAggregationBuilder, List<FormulaHolder> formulas) {
        Pattern pattern = Pattern.compile("\\b(count|sum|min|max|avg|unique)+\\((k='([^']*)')?,?\\s*(q='([^']*)')?\\)?");
        Matcher matcher = pattern.matcher(formula);
        int index = 0;
        while (matcher.find()) {
            FormulaHolder holder = new FormulaHolder();
            holder.setFormula(matcher.group());
            holder.setFunction(Function.valueOf((String)matcher.group(1).toUpperCase()));
            String field = matcher.group(3) != null ? matcher.group(3) : "id.keyword";
            ValuesSourceAggregationBuilder subAgg = OpenSearchDynamicChartAggregatorInterface.getSubAggregationsByFunction(Function.valueOf((String)matcher.group(1).toUpperCase()), field, index);
            if (matcher.group(5) != null) {
                Object queryBuilder = filter != null ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.queryStringQuery((String)matcher.group(5))).must(filter) : QueryBuilders.queryStringQuery((String)matcher.group(5));
                dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.filter((String)("filer" + index), (QueryBuilder)queryBuilder).subAggregation((AggregationBuilder)subAgg));
                holder.setQuery(matcher.group(5));
            } else if (filter != null) {
                dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.filter((String)("filer" + index), (QueryBuilder)filter).subAggregation((AggregationBuilder)subAgg));
            } else {
                dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)subAgg);
            }
            formulas.add(holder);
            ++index;
        }
    }

    private List<DataInsightCustomChartResult> processMultiAggregations(List<Aggregation> aggregations, String formula, String group, List<FormulaHolder> holder) {
        ArrayList<DataInsightCustomChartResult> finalList = new ArrayList<DataInsightCustomChartResult>();
        List<List<DataInsightCustomChartResult>> results = this.processAggregationsInternal(aggregations, group);
        for (List<DataInsightCustomChartResult> result : results) {
            Expression expression;
            Double value;
            String formulaCopy = new String(formula);
            if (holder.size() != result.size()) continue;
            boolean evaluate = true;
            Double day = null;
            for (int i = 0; i < holder.size(); ++i) {
                if (result.get(i).getCount() == null) {
                    evaluate = false;
                    break;
                }
                day = result.get(i).getDay();
                formulaCopy = formulaCopy.replace(holder.get(i).getFormula(), result.get(i).getCount().toString());
            }
            if (!evaluate || !formulaCopy.matches("[\\d\\.+-\\/\\*\\(\\) ]+") || day == null || (value = (Double)(expression = CompiledRule.parseExpression(formulaCopy)).getValue()).isNaN() || value.isInfinite()) continue;
            finalList.add(new DataInsightCustomChartResult().withCount(value).withGroup(group).withDay(day));
        }
        return finalList;
    }

    default public void populateDateHistogram(Function function, String formula, String field, String filter, DateHistogramAggregationBuilder dateHistogramAggregationBuilder, List<FormulaHolder> formulas) throws IOException {
        if (formula != null) {
            if (filter != null && !filter.equals("{}")) {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(OpenSearchClient.X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);
                QueryBuilder queryFilter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                OpenSearchDynamicChartAggregatorInterface.getDateHistogramByFormula(formula, queryFilter, dateHistogramAggregationBuilder, formulas);
            } else {
                OpenSearchDynamicChartAggregatorInterface.getDateHistogramByFormula(formula, null, dateHistogramAggregationBuilder, formulas);
            }
            return;
        }
        ValuesSourceAggregationBuilder subAgg = OpenSearchDynamicChartAggregatorInterface.getSubAggregationsByFunction(function, field, 0);
        if (filter != null && !filter.equals("{}")) {
            XContentParser filterParser = XContentType.JSON.xContent().createParser(OpenSearchClient.X_CONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);
            QueryBuilder queryFilter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
            dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"filer", (QueryBuilder)queryFilter).subAggregation((AggregationBuilder)subAgg));
        } else {
            dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)subAgg);
        }
    }

    public SearchRequest prepareSearchRequest(@NotNull DataInsightCustomChart var1, long var2, long var4, List<FormulaHolder> var6) throws IOException;

    public DataInsightCustomChartResultList processSearchResponse(@NotNull DataInsightCustomChart var1, SearchResponse var2, List<FormulaHolder> var3);

    default public List<DataInsightCustomChartResult> processAggregations(List<Aggregation> aggregations, String formula, String group, List<FormulaHolder> holder) {
        if (formula != null) {
            return this.processMultiAggregations(aggregations, formula, group, holder);
        }
        return this.processSingleAggregations(aggregations, group);
    }

    private List<DataInsightCustomChartResult> processSingleAggregations(List<Aggregation> aggregations, String group) {
        List<List<DataInsightCustomChartResult>> rawResultList = this.processAggregationsInternal(aggregations, group);
        ArrayList<DataInsightCustomChartResult> finalResult = new ArrayList<DataInsightCustomChartResult>();
        for (List<DataInsightCustomChartResult> diResultList : rawResultList) {
            diResultList.forEach(result -> finalResult.add((DataInsightCustomChartResult)result));
        }
        return finalResult;
    }

    private List<List<DataInsightCustomChartResult>> processAggregationsInternal(List<Aggregation> aggregations, String group) {
        ArrayList<List<DataInsightCustomChartResult>> results = new ArrayList<List<DataInsightCustomChartResult>>();
        for (Aggregation arg : aggregations) {
            ParsedDateHistogram parsedDateHistogram = (ParsedDateHistogram)arg;
            for (Histogram.Bucket bucket : parsedDateHistogram.getBuckets()) {
                ArrayList<DataInsightCustomChartResult> subResults = new ArrayList<DataInsightCustomChartResult>();
                for (Aggregation subAggr : bucket.getAggregations().asList()) {
                    this.addByAggregationType(subAggr, subResults, Double.valueOf(((ZonedDateTime)bucket.getKey()).toInstant().toEpochMilli()), group);
                }
                results.add(subResults);
            }
        }
        return results;
    }

    private void addByAggregationType(Aggregation subAggr, List<DataInsightCustomChartResult> diChartResults, Double day, String group) {
        if (subAggr instanceof ParsedValueCount) {
            this.addProcessedSubResult((ParsedValueCount)subAggr, diChartResults, day, group);
        } else if (subAggr instanceof ParsedCardinality) {
            this.addProcessedSubResult((ParsedCardinality)subAggr, diChartResults, day, group);
        } else if (subAggr instanceof ParsedSingleValueNumericMetricsAggregation) {
            this.addProcessedSubResult((ParsedSingleValueNumericMetricsAggregation)subAggr, diChartResults, day, group);
        } else if (subAggr instanceof ParsedFilter) {
            this.addProcessedSubResult((ParsedFilter)subAggr, diChartResults, day, group);
        }
    }

    private void addProcessedSubResult(ParsedValueCount aggregation, List<DataInsightCustomChartResult> diChartResults, Double day, String group) {
        ParsedValueCount parsedValueCount = aggregation;
        Double value = parsedValueCount.getValue();
        if (!Double.isInfinite(value) && !Double.isNaN(value)) {
            DataInsightCustomChartResult diChartResult = new DataInsightCustomChartResult().withCount(value).withDay(day).withGroup(group);
            diChartResults.add(diChartResult);
        }
    }

    private void addProcessedSubResult(ParsedCardinality aggregation, List<DataInsightCustomChartResult> diChartResults, Double day, String group) {
        ParsedCardinality parsedValueCount = aggregation;
        Double value = parsedValueCount.getValue();
        if (!Double.isInfinite(value) && !Double.isNaN(value)) {
            DataInsightCustomChartResult diChartResult = new DataInsightCustomChartResult().withCount(value).withDay(day).withGroup(group);
            diChartResults.add(diChartResult);
        }
    }

    private void addProcessedSubResult(ParsedSingleValueNumericMetricsAggregation aggregation, List<DataInsightCustomChartResult> diChartResults, Double day, String group) {
        ParsedSingleValueNumericMetricsAggregation parsedValueCount = aggregation;
        Double value = parsedValueCount.value();
        if (!Double.isInfinite(value) && !Double.isNaN(value)) {
            DataInsightCustomChartResult diChartResult = new DataInsightCustomChartResult().withCount(value).withDay(day).withGroup(group);
            diChartResults.add(diChartResult);
        }
    }

    private void addProcessedSubResult(ParsedFilter aggregation, List<DataInsightCustomChartResult> diChartResults, Double day, String group) {
        ParsedFilter parsedValueCount = aggregation;
        for (Aggregation agg : parsedValueCount.getAggregations().asList()) {
            this.addByAggregationType(agg, diChartResults, day, group);
        }
    }
}

