/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch.dataInsightAggregator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChart;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResult;
import org.openmetadata.schema.dataInsight.custom.DataInsightCustomChartResultList;
import org.openmetadata.schema.dataInsight.custom.FormulaHolder;
import org.openmetadata.schema.dataInsight.custom.SummaryCard;
import org.openmetadata.service.search.opensearch.dataInsightAggregator.OpenSearchDynamicChartAggregatorInterface;
import org.openmetadata.service.util.JsonUtils;
import os.org.opensearch.action.search.SearchRequest;
import os.org.opensearch.action.search.SearchResponse;
import os.org.opensearch.index.query.QueryBuilder;
import os.org.opensearch.index.query.RangeQueryBuilder;
import os.org.opensearch.search.aggregations.AggregationBuilder;
import os.org.opensearch.search.aggregations.AggregationBuilders;
import os.org.opensearch.search.aggregations.Aggregations;
import os.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import os.org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import os.org.opensearch.search.builder.SearchSourceBuilder;

public class OpenSearchSummaryCardAggregator
implements OpenSearchDynamicChartAggregatorInterface {
    @Override
    public SearchRequest prepareSearchRequest(@NotNull DataInsightCustomChart diChart, long start, long end, List<FormulaHolder> formulas) throws IOException {
        SummaryCard summaryCard = JsonUtils.convertValue(diChart.getChartDetails(), SummaryCard.class);
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"1").field("@timestamp")).calendarInterval(DateHistogramInterval.DAY);
        this.populateDateHistogram(summaryCard.getFunction(), summaryCard.getFormula(), summaryCard.getField(), summaryCard.getFilter(), dateHistogramAggregationBuilder, formulas);
        RangeQueryBuilder queryFilter = new RangeQueryBuilder("@timestamp").gte((Object)start).lte((Object)end);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)dateHistogramAggregationBuilder);
        searchSourceBuilder.query((QueryBuilder)queryFilter);
        searchSourceBuilder.size(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{"di-data-assets-*"});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Override
    public DataInsightCustomChartResultList processSearchResponse(@NotNull DataInsightCustomChart diChart, SearchResponse searchResponse, List<FormulaHolder> formulas) {
        DataInsightCustomChartResultList resultList = new DataInsightCustomChartResultList();
        SummaryCard summaryCard = JsonUtils.convertValue(diChart.getChartDetails(), SummaryCard.class);
        List aggregationList = Optional.ofNullable(searchResponse.getAggregations()).orElse(new Aggregations(new ArrayList())).asList();
        List<DataInsightCustomChartResult> results = this.processAggregations(aggregationList, summaryCard.getFormula(), null, formulas);
        ArrayList<DataInsightCustomChartResult> finalResults = new ArrayList<DataInsightCustomChartResult>();
        for (int i = results.size() - 1; i >= 0; --i) {
            if (results.get(i).getCount() == null) continue;
            finalResults.add(results.get(i));
            resultList.setResults(finalResults);
            return resultList;
        }
        resultList.setResults(results);
        return resultList;
    }
}

