/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSBasedSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.Tag;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;

public class AWSSecretsManager
extends AWSBasedSecretsManager {
    private static final Logger LOG = LoggerFactory.getLogger(AWSSecretsManager.class);
    private static AWSSecretsManager instance = null;
    private SecretsManagerClient secretsClient;

    private AWSSecretsManager(SecretsManager.SecretsConfig secretsConfig) {
        super(SecretsManagerProvider.MANAGED_AWS, secretsConfig);
    }

    @Override
    void initClientWithoutCredentials() {
        this.secretsClient = SecretsManagerClient.create();
    }

    @Override
    void initClientWithCredentials(String region, AwsCredentialsProvider staticCredentialsProvider) {
        this.secretsClient = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).credentialsProvider(staticCredentialsProvider)).build();
    }

    @Override
    public void storeSecret(String secretName, String secretValue) {
        CreateSecretRequest createSecretRequest = (CreateSecretRequest)CreateSecretRequest.builder().name(secretName).description("This secret was created by OpenMetadata").secretString(Objects.isNull(secretValue) ? "null" : secretValue).tags(SecretsManager.getTags(this.getSecretsConfig()).entrySet().stream().map(entry -> (Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).toList()).build();
        this.secretsClient.createSecret(createSecretRequest);
    }

    @Override
    public void updateSecret(String secretName, String secretValue) {
        UpdateSecretRequest updateSecretRequest = (UpdateSecretRequest)UpdateSecretRequest.builder().secretId(secretName).description("This secret was created by OpenMetadata").secretString(this.cleanNullOrEmpty(secretValue)).build();
        this.secretsClient.updateSecret(updateSecretRequest);
    }

    @Override
    public String getSecret(String secretName) {
        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        return this.secretsClient.getSecretValue(getSecretValueRequest).secretString();
    }

    @Override
    protected void deleteSecretInternal(String secretName) {
        DeleteSecretRequest deleteSecretRequest = (DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).forceDeleteWithoutRecovery(Boolean.valueOf(true)).build();
        this.secretsClient.deleteSecret(deleteSecretRequest);
    }

    public static AWSSecretsManager getInstance(SecretsManager.SecretsConfig secretsConfig) {
        if (instance == null) {
            instance = new AWSSecretsManager(secretsConfig);
        }
        return instance;
    }

    @VisibleForTesting
    protected void setSecretsClient(SecretsManagerClient secretsClient) {
        this.secretsClient = secretsClient;
    }
}

