/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.polling.SyncPoller;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.Strings;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.secrets.ExternalSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;

public class AzureKVSecretsManager
extends ExternalSecretsManager {
    private static AzureKVSecretsManager instance = null;
    private SecretClient client;
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String TENANT_ID = "tenantId";
    public static final String VAULT_NAME = "vaultName";

    private AzureKVSecretsManager(SecretsManagerProvider secretsManagerProvider, SecretsManager.SecretsConfig secretsConfig) {
        super(secretsManagerProvider, secretsConfig, 100L);
        String vaultName = secretsConfig.parameters().getAdditionalProperties().getOrDefault(VAULT_NAME, "");
        if (Strings.isBlank((String)vaultName)) {
            throw new SecretsManagerException("Using Azure Secrets Manager we found a missing or empty `vaultName` parameter. Review your configuration. ");
        }
        TokenCredential credential = this.buildAzureCredentials(secretsConfig);
        String vaultUrl = String.format("https://%s.vault.azure.net/", vaultName);
        this.client = new SecretClientBuilder().vaultUrl(vaultUrl).credential(credential).buildClient();
    }

    private TokenCredential buildAzureCredentials(SecretsManager.SecretsConfig secretsConfig) {
        if (secretsConfig != null && secretsConfig.parameters() != null && !Strings.isBlank((String)secretsConfig.parameters().getAdditionalProperties().getOrDefault(TENANT_ID, ""))) {
            String clientId = secretsConfig.parameters().getAdditionalProperties().getOrDefault(CLIENT_ID, "");
            String clientSecret = secretsConfig.parameters().getAdditionalProperties().getOrDefault(CLIENT_SECRET, "");
            String tenantId = secretsConfig.parameters().getAdditionalProperties().getOrDefault(TENANT_ID, "");
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(clientSecret).tenantId(tenantId)).build();
        }
        return new DefaultAzureCredentialBuilder().build();
    }

    @Override
    protected SecretsManager.SecretsIdConfig builSecretsIdConfig() {
        return new SecretsManager.SecretsIdConfig("-", Boolean.FALSE, "", Pattern.compile("[^A-Za-z0-9\\-]"));
    }

    @Override
    void storeSecret(String secretName, String secretValue) {
        this.client.setSecret(new KeyVaultSecret(secretName, this.cleanNullOrEmpty(secretValue)).setProperties(new SecretProperties().setTags(SecretsManager.getTags(this.getSecretsConfig()))));
    }

    @Override
    void updateSecret(String secretName, String secretValue) {
        this.storeSecret(secretName, secretValue);
    }

    @Override
    String getSecret(String secretName) {
        return this.client.getSecret(secretName).getValue();
    }

    @Override
    protected void deleteSecretInternal(String secretName) {
        SyncPoller deletionPoller = this.client.beginDeleteSecret(secretName);
        deletionPoller.waitForCompletion();
    }

    public static AzureKVSecretsManager getInstance(SecretsManager.SecretsConfig secretsConfig) {
        if (instance == null) {
            instance = new AzureKVSecretsManager(SecretsManagerProvider.MANAGED_AZURE_KV, secretsConfig);
        }
        return instance;
    }
}

