/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.ProjectName;
import com.google.cloud.secretmanager.v1.Replication;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.zip.CRC32C;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.exception.SecretsManagerUpdateException;
import org.openmetadata.service.secrets.ExternalSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;

public class GCPSecretsManager
extends ExternalSecretsManager {
    private static final String FIXED_VERSION_ID = "latest";
    public static final String PROJECT_ID_NAME = "projectId";
    private static GCPSecretsManager instance = null;
    private String projectId = null;

    private GCPSecretsManager(SecretsManager.SecretsConfig secretsConfig) {
        super(SecretsManagerProvider.GCP, secretsConfig, 100L);
        this.projectId = secretsConfig.parameters().getAdditionalProperties().getOrDefault(PROJECT_ID_NAME, "");
    }

    @Override
    protected SecretsManager.SecretsIdConfig builSecretsIdConfig() {
        return new SecretsManager.SecretsIdConfig("_", Boolean.FALSE, "", Pattern.compile("[^A-Za-z0-9_]"));
    }

    @Override
    void storeSecret(String secretId, String secretValue) {
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            ProjectName projectName = ProjectName.of((String)this.projectId);
            Secret secret = Secret.newBuilder().setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.newBuilder().build()).build()).build();
            client.createSecret(projectName, secretId, secret);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e);
        }
        this.updateSecret(secretId, this.cleanNullOrEmpty(secretValue));
    }

    @Override
    void updateSecret(String secretId, String secretValue) {
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            SecretName secretName = SecretName.of((String)this.projectId, (String)secretId);
            byte[] data = secretValue.getBytes();
            CRC32C checksum = new CRC32C();
            checksum.update(data, 0, data.length);
            SecretPayload payload = SecretPayload.newBuilder().setData(ByteString.copyFrom((byte[])data)).setDataCrc32C(checksum.getValue()).build();
            client.addSecretVersion(secretName, payload);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e);
        }
    }

    @Override
    String getSecret(String secretId) {
        String string;
        block9: {
            SecretManagerServiceClient client = SecretManagerServiceClient.create();
            try {
                SecretVersionName secretVersionName = SecretVersionName.of((String)this.projectId, (String)secretId, (String)FIXED_VERSION_ID);
                AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
                byte[] data = response.getPayload().getData().toByteArray();
                CRC32C checksum = new CRC32C();
                checksum.update(data, 0, data.length);
                if (response.getPayload().getDataCrc32C() != checksum.getValue()) {
                    throw new SecretsManagerException("Data corruption detected.");
                }
                string = response.getPayload().getData().toStringUtf8();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SecretsManagerUpdateException(e.getMessage(), e);
                }
            }
            client.close();
        }
        return string;
    }

    @Override
    protected void deleteSecretInternal(String secretId) {
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            SecretName secretName = SecretName.of((String)this.projectId, (String)secretId);
            client.deleteSecret(secretName);
            System.out.printf("Deleted secret %s\n", secretId);
        }
        catch (IOException e) {
            throw new SecretsManagerUpdateException(e.getMessage(), e);
        }
    }

    public static GCPSecretsManager getInstance(SecretsManager.SecretsConfig secretsConfig) {
        if (instance == null) {
            instance = new GCPSecretsManager(secretsConfig);
        }
        return instance;
    }
}

