/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.security.ssl.ValidateSSLClientConfig;
import org.openmetadata.schema.services.connections.database.MysqlConnection;
import org.openmetadata.schema.services.connections.database.common.AzureConfig;
import org.openmetadata.schema.services.connections.database.common.IamAuthConfig;
import org.openmetadata.schema.services.connections.database.common.basicAuth;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class MysqlConnectionClassConverter
extends ClassConverter {
    private static final List<Class<?>> CONFIG_SOURCE_CLASSES = List.of(basicAuth.class, IamAuthConfig.class, AzureConfig.class);
    private static final List<Class<?>> SSL_SOURCE_CLASS = List.of(ValidateSSLClientConfig.class);

    public MysqlConnectionClassConverter() {
        super(MysqlConnection.class);
    }

    @Override
    public Object convert(Object object) {
        MysqlConnection mysqlConnection = (MysqlConnection)JsonUtils.convertValue(object, this.clazz);
        this.tryToConvert(mysqlConnection.getAuthType(), CONFIG_SOURCE_CLASSES).ifPresent(arg_0 -> ((MysqlConnection)mysqlConnection).setAuthType(arg_0));
        this.tryToConvert(mysqlConnection.getSslConfig(), SSL_SOURCE_CLASS).ifPresent(obj -> mysqlConnection.setSslConfig((Object)((ValidateSSLClientConfig)obj)));
        return mysqlConnection;
    }
}

