/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import com.onelogin.saml2.Auth;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.saml.SamlSettingsHolder;
import org.openmetadata.service.util.TokenUtil;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/saml/acs"})
public class SamlAssertionConsumerServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SamlAssertionConsumerServlet.class);
    private Set<String> admins;

    public SamlAssertionConsumerServlet(AuthorizerConfiguration configuration) {
        this.admins = configuration.getAdminPrincipals();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.handleResponse(req, resp);
        }
        catch (Exception e) {
            LOG.error("[SamlAssertionConsumerServlet] Exception :" + e.getMessage());
        }
    }

    private void handleResponse(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List errors;
        Auth auth = new Auth(SamlSettingsHolder.getInstance().getSaml2Settings(), req, resp);
        auth.processResponse();
        if (!auth.isAuthenticated()) {
            LOG.error("[SAML ACS] Not Authenticated");
            resp.sendError(403, "UnAuthenticated");
        }
        if (!(errors = auth.getErrors()).isEmpty()) {
            String errorReason = auth.getLastErrorReason();
            if (errorReason != null && !errorReason.isEmpty()) {
                LOG.error("[SAML ACS]" + errorReason);
                resp.sendError(500, errorReason);
            }
        } else {
            JWTAuthMechanism jwtAuthMechanism;
            User user;
            String username;
            String nameId;
            String email = nameId = auth.getNameId();
            if (nameId.contains("@")) {
                username = nameId.split("@")[0];
            } else {
                username = nameId;
                email = String.format("%s@%s", username, SamlSettingsHolder.getInstance().getDomain());
            }
            try {
                user = (User)Entity.getEntityByName("user", username, "id,roles", Include.NON_DELETED);
                jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(username, UserUtil.getRoleListFromUser(user), !CommonUtil.nullOrEmpty((Object)user.getIsAdmin()) && user.getIsAdmin() != false, user.getEmail(), SamlSettingsHolder.getInstance().getTokenValidity(), false, ServiceTokenType.OM_USER);
            }
            catch (Exception e) {
                LOG.error("[SAML ACS] User not found: " + username);
                user = UserUtil.addOrUpdateUser(UserUtil.user(username, email.split("@")[1], username));
                jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(username, new HashSet<String>(), this.admins.contains(username), email, SamlSettingsHolder.getInstance().getTokenValidity(), false, ServiceTokenType.OM_USER);
            }
            JwtResponse jwtResponse = this.getJwtResponseWithRefresh(user, jwtAuthMechanism);
            Cookie refreshTokenCookie = new Cookie("refreshToken", jwtResponse.getRefreshToken());
            refreshTokenCookie.setMaxAge(3600);
            refreshTokenCookie.setPath("/");
            resp.addCookie(refreshTokenCookie);
            String url = SamlSettingsHolder.getInstance().getRelayState() + "?id_token=" + jwtAuthMechanism.getJWTToken() + "&email=" + nameId + "&name=" + username;
            resp.sendRedirect(url);
        }
    }

    private JwtResponse getJwtResponseWithRefresh(User storedUser, JWTAuthMechanism jwtAuthMechanism) {
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(storedUser.getId(), UUID.randomUUID());
        Entity.getTokenRepository().insertToken((TokenInterface)newRefreshToken);
        JwtResponse response = new JwtResponse();
        response.setTokenType("Bearer");
        response.setAccessToken(jwtAuthMechanism.getJWTToken());
        response.setRefreshToken(newRefreshToken.getToken().toString());
        response.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
        return response;
    }
}

